/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import java.io.IOException;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.rest.RestStatus;

public class RestoreInfo
implements ToXContent,
Streamable {
    private String name;
    private ImmutableList<String> indices;
    private int totalShards;
    private int successfulShards;

    RestoreInfo() {
    }

    public RestoreInfo(String name, ImmutableList<String> indices, int totalShards, int successfulShards) {
        this.name = name;
        this.indices = indices;
        this.totalShards = totalShards;
        this.successfulShards = successfulShards;
    }

    public String name() {
        return this.name;
    }

    public ImmutableList<String> indices() {
        return this.indices;
    }

    public int totalShards() {
        return this.totalShards;
    }

    public int failedShards() {
        return this.totalShards - this.successfulShards;
    }

    public int successfulShards() {
        return this.successfulShards;
    }

    public RestStatus status() {
        return RestStatus.OK;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Fields.SNAPSHOT, this.name);
        builder.startArray(Fields.INDICES);
        for (String index : this.indices) {
            builder.value(index);
        }
        builder.endArray();
        builder.startObject(Fields.SHARDS);
        builder.field(Fields.TOTAL, this.totalShards);
        builder.field(Fields.FAILED, this.failedShards());
        builder.field(Fields.SUCCESSFUL, this.successfulShards);
        builder.endObject();
        builder.endObject();
        return builder;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readString();
        int size = in.readVInt();
        ImmutableList.Builder indicesListBuilder = ImmutableList.builder();
        for (int i = 0; i < size; ++i) {
            indicesListBuilder.add(in.readString());
        }
        this.indices = indicesListBuilder.build();
        this.totalShards = in.readVInt();
        this.successfulShards = in.readVInt();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeVInt(this.indices.size());
        for (String index : this.indices) {
            out.writeString(index);
        }
        out.writeVInt(this.totalShards);
        out.writeVInt(this.successfulShards);
    }

    public static RestoreInfo readRestoreInfo(StreamInput in) throws IOException {
        RestoreInfo snapshotInfo = new RestoreInfo();
        snapshotInfo.readFrom(in);
        return snapshotInfo;
    }

    public static RestoreInfo readOptionalRestoreInfo(StreamInput in) throws IOException {
        return in.readOptionalStreamable(new RestoreInfo());
    }

    static final class Fields {
        static final XContentBuilderString SNAPSHOT = new XContentBuilderString("snapshot");
        static final XContentBuilderString INDICES = new XContentBuilderString("indices");
        static final XContentBuilderString SHARDS = new XContentBuilderString("shards");
        static final XContentBuilderString TOTAL = new XContentBuilderString("total");
        static final XContentBuilderString FAILED = new XContentBuilderString("failed");
        static final XContentBuilderString SUCCESSFUL = new XContentBuilderString("successful");

        Fields() {
        }
    }
}

