/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.settings.NodeSettingsService;

public final class DestructiveOperations
implements NodeSettingsService.Listener {
    public static final String REQUIRES_NAME = "action.destructive_requires_name";
    private final ESLogger logger;
    private volatile boolean destructiveRequiresName;

    public DestructiveOperations(ESLogger logger, Settings settings, NodeSettingsService nodeSettingsService) {
        this.logger = logger;
        this.destructiveRequiresName = settings.getAsBoolean(REQUIRES_NAME, (Boolean)false);
        nodeSettingsService.addListener(this);
    }

    public void failDestructive(String[] aliasesOrIndices) {
        if (!this.destructiveRequiresName) {
            return;
        }
        if (aliasesOrIndices == null || aliasesOrIndices.length == 0) {
            throw new ElasticsearchIllegalArgumentException("Wildcard expressions or all indices are not allowed");
        }
        if (aliasesOrIndices.length == 1) {
            if (DestructiveOperations.hasWildcardUsage(aliasesOrIndices[0])) {
                throw new ElasticsearchIllegalArgumentException("Wildcard expressions or all indices are not allowed");
            }
        } else {
            for (String aliasesOrIndex : aliasesOrIndices) {
                if (!DestructiveOperations.hasWildcardUsage(aliasesOrIndex)) continue;
                throw new ElasticsearchIllegalArgumentException("Wildcard expressions or all indices are not allowed");
            }
        }
    }

    @Override
    public void onRefreshSettings(Settings settings) {
        boolean newValue = settings.getAsBoolean(REQUIRES_NAME, (Boolean)this.destructiveRequiresName);
        if (this.destructiveRequiresName != newValue) {
            this.logger.info("updating [action.operate_all_indices] from [{}] to [{}]", this.destructiveRequiresName, newValue);
            this.destructiveRequiresName = newValue;
        }
    }

    private static boolean hasWildcardUsage(String aliasOrIndex) {
        return "_all".equals(aliasOrIndex) || aliasOrIndex.indexOf(42) != -1;
    }
}

