/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.update;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.engine.DocumentMissingException;
import org.elasticsearch.index.engine.DocumentSourceMissingException;
import org.elasticsearch.index.get.GetField;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.fetch.source.FetchSourceContext;
import org.elasticsearch.search.lookup.SourceLookup;

public class UpdateHelper
extends AbstractComponent {
    private final IndicesService indicesService;
    private final ScriptService scriptService;

    @Inject
    public UpdateHelper(Settings settings, IndicesService indicesService, ScriptService scriptService) {
        super(settings);
        this.indicesService = indicesService;
        this.scriptService = scriptService;
    }

    public Result prepare(UpdateRequest request) {
        IndexService indexService = this.indicesService.indexServiceSafe(request.index());
        IndexShard indexShard = indexService.shardSafe(request.shardId());
        return this.prepare(request, indexShard);
    }

    public Result prepare(UpdateRequest request, IndexShard indexShard) {
        UpdateResponse update;
        Map updatedSourceAsMap;
        IndexRequest indexRequest;
        String parent;
        long getDate = System.currentTimeMillis();
        GetResult getResult = indexShard.getService().get(request.type(), request.id(), new String[]{"_routing", "_parent", "_ttl"}, true, request.version(), request.versionType(), FetchSourceContext.FETCH_SOURCE);
        if (!getResult.isExists()) {
            if (request.upsertRequest() == null && !request.docAsUpsert()) {
                throw new DocumentMissingException(new ShardId(request.index(), request.shardId()), request.type(), request.id());
            }
            IndexRequest indexRequest2 = request.docAsUpsert() ? request.doc() : request.upsertRequest();
            ((IndexRequest)((IndexRequest)indexRequest2.index(request.index())).type(request.type()).id(request.id()).create(true).routing(request.routing()).refresh(request.refresh()).replicationType(request.replicationType())).consistencyLevel(request.consistencyLevel());
            indexRequest2.operationThreaded(false);
            if (request.versionType() != VersionType.INTERNAL) {
                indexRequest2.version(request.version()).versionType(request.versionType());
            }
            return new Result(indexRequest2, Operation.UPSERT, null, null);
        }
        long updateVersion = getResult.getVersion();
        if (request.versionType() != VersionType.INTERNAL) {
            updateVersion = request.version();
        }
        if (getResult.internalSourceRef() == null) {
            throw new DocumentSourceMissingException(new ShardId(request.index(), request.shardId()), request.type(), request.id());
        }
        Tuple<XContentType, Map<String, Object>> sourceAndContent = XContentHelper.convertToMap(getResult.internalSourceRef(), true);
        String operation = null;
        String timestamp = null;
        Long ttl = null;
        Object fetchedTTL = null;
        XContentType updateSourceContentType = sourceAndContent.v1();
        String routing = getResult.getFields().containsKey("_routing") ? getResult.field("_routing").getValue().toString() : null;
        String string = parent = getResult.getFields().containsKey("_parent") ? getResult.field("_parent").getValue().toString() : null;
        if (request.script() == null && request.doc() != null) {
            indexRequest = request.doc();
            updatedSourceAsMap = sourceAndContent.v2();
            if (indexRequest.ttl() > 0L) {
                ttl = indexRequest.ttl();
            }
            timestamp = indexRequest.timestamp();
            if (indexRequest.routing() != null) {
                routing = indexRequest.routing();
            }
            if (indexRequest.parent() != null) {
                parent = indexRequest.parent();
            }
            XContentHelper.update(updatedSourceAsMap, indexRequest.sourceAsMap());
        } else {
            Map ctx = new HashMap<String, Map<String, Object>>(2);
            ctx.put("_source", sourceAndContent.v2());
            try {
                ExecutableScript script = this.scriptService.executable(request.scriptLang, request.script, request.scriptParams);
                script.setNextVar("ctx", ctx);
                script.run();
                ctx = (Map)script.unwrap(ctx);
            }
            catch (Exception e) {
                throw new ElasticsearchIllegalArgumentException("failed to execute script", e);
            }
            operation = (String)ctx.get("op");
            timestamp = (String)ctx.get("_timestamp");
            fetchedTTL = ctx.get("_ttl");
            if (fetchedTTL != null) {
                ttl = fetchedTTL instanceof Number ? Long.valueOf(((Number)fetchedTTL).longValue()) : Long.valueOf(TimeValue.parseTimeValue(fetchedTTL, null).millis());
            }
            updatedSourceAsMap = (Map)ctx.get("_source");
        }
        if (ttl == null) {
            Long l = ttl = getResult.getFields().containsKey("_ttl") ? (Long)getResult.field("_ttl").getValue() : null;
            if (ttl != null) {
                ttl = ttl - (System.currentTimeMillis() - getDate);
            }
        }
        if (operation == null || "index".equals(operation)) {
            indexRequest = ((IndexRequest)((IndexRequest)Requests.indexRequest(request.index()).type(request.type()).id(request.id()).routing(routing).parent(parent).source(updatedSourceAsMap, updateSourceContentType).version(updateVersion).versionType(request.versionType()).replicationType(request.replicationType())).consistencyLevel(request.consistencyLevel())).timestamp(timestamp).ttl(ttl).refresh(request.refresh());
            indexRequest.operationThreaded(false);
            return new Result(indexRequest, Operation.INDEX, updatedSourceAsMap, updateSourceContentType);
        }
        if ("delete".equals(operation)) {
            DeleteRequest deleteRequest = (DeleteRequest)((DeleteRequest)Requests.deleteRequest(request.index()).type(request.type()).id(request.id()).routing(routing).parent(parent).version(updateVersion).versionType(request.versionType()).replicationType(request.replicationType())).consistencyLevel(request.consistencyLevel());
            deleteRequest.operationThreaded(false);
            return new Result(deleteRequest, Operation.DELETE, updatedSourceAsMap, updateSourceContentType);
        }
        if ("none".equals(operation)) {
            update = new UpdateResponse(getResult.getIndex(), getResult.getType(), getResult.getId(), getResult.getVersion(), false);
            update.setGetResult(this.extractGetResult(request, getResult.getVersion(), updatedSourceAsMap, updateSourceContentType, null));
            return new Result(update, Operation.NONE, updatedSourceAsMap, updateSourceContentType);
        }
        this.logger.warn("Used update operation [{}] for script [{}], doing nothing...", operation, request.script);
        update = new UpdateResponse(getResult.getIndex(), getResult.getType(), getResult.getId(), getResult.getVersion(), false);
        return new Result(update, Operation.NONE, updatedSourceAsMap, updateSourceContentType);
    }

    public GetResult extractGetResult(UpdateRequest request, long version, Map<String, Object> source, XContentType sourceContentType, @Nullable BytesReference sourceAsBytes) {
        if (request.fields() == null || request.fields().length == 0) {
            return null;
        }
        boolean sourceRequested = false;
        HashMap<String, GetField> fields = null;
        if (request.fields() != null && request.fields().length > 0) {
            SourceLookup sourceLookup = new SourceLookup();
            sourceLookup.setNextSource(source);
            for (String field : request.fields()) {
                GetField getField;
                if (field.equals("_source")) {
                    sourceRequested = true;
                    continue;
                }
                Object value = sourceLookup.extractValue(field);
                if (value == null) continue;
                if (fields == null) {
                    fields = Maps.newHashMapWithExpectedSize(2);
                }
                if ((getField = (GetField)fields.get(field)) == null) {
                    getField = new GetField(field, new ArrayList<Object>(2));
                    fields.put(field, getField);
                }
                getField.getValues().add(value);
            }
        }
        return new GetResult(request.index(), request.type(), request.id(), version, true, sourceRequested ? sourceAsBytes : null, fields);
    }

    public static enum Operation {
        UPSERT,
        INDEX,
        DELETE,
        NONE;

    }

    public static class Result {
        private final Streamable action;
        private final Operation operation;
        private final Map<String, Object> updatedSourceAsMap;
        private final XContentType updateSourceContentType;

        public Result(Streamable action, Operation operation, Map<String, Object> updatedSourceAsMap, XContentType updateSourceContentType) {
            this.action = action;
            this.operation = operation;
            this.updatedSourceAsMap = updatedSourceAsMap;
            this.updateSourceContentType = updateSourceContentType;
        }

        public <T extends Streamable> T action() {
            return (T)this.action;
        }

        public Operation operation() {
            return this.operation;
        }

        public Map<String, Object> updatedSourceAsMap() {
            return this.updatedSourceAsMap;
        }

        public XContentType updateSourceContentType() {
            return this.updateSourceContentType;
        }
    }
}

