/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.config;

import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;

@XObject(value="elasticSearchIndex")
public class ElasticSearchIndexConfig {
    @XNode(value="@name")
    protected String name;
    @XNode(value="@repository")
    protected String repositoryName = "default";
    @XNode(value="@type")
    protected String type = "doc";
    @XNode(value="@create")
    protected boolean create = true;
    @XNode(value="settings")
    protected String settings;
    @XNode(value="mapping")
    protected String mapping;
    @XNodeList(value="fetchFromSource/exclude", type=String[].class, componentType=String.class)
    protected String[] excludes;
    @XNodeList(value="fetchFromSource/include", type=String[].class, componentType=String.class)
    protected String[] includes;

    public String[] getExcludes() {
        if (this.excludes == null) {
            return new String[]{"ecm:binarytext"};
        }
        return this.excludes;
    }

    public String[] getIncludes() {
        if (this.includes == null || this.includes.length == 0) {
            return new String[]{"*"};
        }
        return this.includes;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getSettings() {
        return this.settings;
    }

    public String getMapping() {
        return this.mapping;
    }

    public boolean mustCreate() {
        return this.create;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void merge(ElasticSearchIndexConfig other) {
        if (other == null) {
            return;
        }
        if (this.mapping == null) {
            this.mapping = other.getMapping();
        }
        if (this.settings == null) {
            this.settings = other.getSettings();
        }
    }
}

