/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.util.Arrays;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.cache.recycler.PageCacheRecycler;
import org.elasticsearch.common.base.Preconditions;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.AbstractArray;
import org.elasticsearch.common.util.BigByteArray;
import org.elasticsearch.common.util.BigDoubleArray;
import org.elasticsearch.common.util.BigFloatArray;
import org.elasticsearch.common.util.BigIntArray;
import org.elasticsearch.common.util.BigLongArray;
import org.elasticsearch.common.util.BigObjectArray;
import org.elasticsearch.common.util.ByteArray;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.common.util.FloatArray;
import org.elasticsearch.common.util.IntArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.common.util.ObjectArray;

public class BigArrays
extends AbstractComponent {
    public static final BigArrays NON_RECYCLING_INSTANCE = new BigArrays(ImmutableSettings.EMPTY, null);
    public static final int PAGE_SIZE_IN_BYTES = 16384;
    public static final int BYTE_PAGE_SIZE = 16384;
    public static final int INT_PAGE_SIZE = 4096;
    public static final int FLOAT_PAGE_SIZE = 4096;
    public static final int LONG_PAGE_SIZE = 2048;
    public static final int DOUBLE_PAGE_SIZE = 2048;
    public static final int OBJECT_PAGE_SIZE = 16384 / RamUsageEstimator.NUM_BYTES_OBJECT_REF;
    final PageCacheRecycler recycler;

    public static long overSize(long minTargetSize) {
        return BigArrays.overSize(minTargetSize, 2048, 1);
    }

    public static long overSize(long minTargetSize, int pageSize, int bytesPerElement) {
        Preconditions.checkArgument(minTargetSize >= 0L, "minTargetSize must be >= 0");
        Preconditions.checkArgument(pageSize >= 0, "pageSize must be > 0");
        Preconditions.checkArgument(bytesPerElement > 0, "bytesPerElement must be > 0");
        long newSize = minTargetSize < (long)pageSize ? (long)ArrayUtil.oversize((int)((int)minTargetSize), (int)bytesPerElement) : minTargetSize + (minTargetSize >>> 3);
        if (newSize > (long)pageSize) {
            newSize = newSize - newSize % (long)pageSize + (long)pageSize;
            assert (newSize % (long)pageSize == 0L);
        }
        return newSize;
    }

    static boolean indexIsInt(long index) {
        return index == (long)((int)index);
    }

    @Inject
    public BigArrays(Settings settings, PageCacheRecycler recycler) {
        super(settings);
        this.recycler = recycler;
    }

    public ByteArray newByteArray(long size, boolean clearOnResize) {
        if (size > 16384L) {
            return new BigByteArray(size, this.recycler, clearOnResize);
        }
        if (size >= 8192L && this.recycler != null) {
            Recycler.V<byte[]> page = this.recycler.bytePage(clearOnResize);
            return new ByteArrayWrapper(page.v(), size, page, clearOnResize);
        }
        return new ByteArrayWrapper(new byte[(int)size], size, null, clearOnResize);
    }

    public ByteArray newByteArray(long size) {
        return this.newByteArray(size, true);
    }

    public ByteArray resize(ByteArray array, long size) {
        if (array instanceof BigByteArray) {
            ((BigByteArray)array).resize(size);
            return array;
        }
        AbstractArray arr = (AbstractArray)((Object)array);
        ByteArray newArray = this.newByteArray(size, arr.clearOnResize);
        byte[] rawArray = ((ByteArrayWrapper)array).array;
        newArray.set(0L, rawArray, 0, (int)Math.min((long)rawArray.length, newArray.size()));
        array.release();
        return newArray;
    }

    public ByteArray grow(ByteArray array, long minSize) {
        if (minSize <= array.size()) {
            return array;
        }
        long newSize = BigArrays.overSize(minSize, 16384, 1);
        return this.resize(array, newSize);
    }

    public IntArray newIntArray(long size, boolean clearOnResize) {
        if (size > 4096L) {
            return new BigIntArray(size, this.recycler, clearOnResize);
        }
        if (size >= 2048L && this.recycler != null) {
            Recycler.V<int[]> page = this.recycler.intPage(clearOnResize);
            return new IntArrayWrapper(page.v(), size, page, clearOnResize);
        }
        return new IntArrayWrapper(new int[(int)size], size, null, clearOnResize);
    }

    public IntArray newIntArray(long size) {
        return this.newIntArray(size, true);
    }

    public IntArray resize(IntArray array, long size) {
        if (array instanceof BigIntArray) {
            ((BigIntArray)array).resize(size);
            return array;
        }
        AbstractArray arr = (AbstractArray)((Object)array);
        IntArray newArray = this.newIntArray(size, arr.clearOnResize);
        long end = Math.min(size, array.size());
        for (long i = 0L; i < end; ++i) {
            newArray.set(i, array.get(i));
        }
        array.release();
        return newArray;
    }

    public IntArray grow(IntArray array, long minSize) {
        if (minSize <= array.size()) {
            return array;
        }
        long newSize = BigArrays.overSize(minSize, 4096, 4);
        return this.resize(array, newSize);
    }

    public LongArray newLongArray(long size, boolean clearOnResize) {
        if (size > 2048L) {
            return new BigLongArray(size, this.recycler, clearOnResize);
        }
        if (size >= 1024L && this.recycler != null) {
            Recycler.V<long[]> page = this.recycler.longPage(clearOnResize);
            return new LongArrayWrapper(page.v(), size, page, clearOnResize);
        }
        return new LongArrayWrapper(new long[(int)size], size, null, clearOnResize);
    }

    public LongArray newLongArray(long size) {
        return this.newLongArray(size, true);
    }

    public LongArray resize(LongArray array, long size) {
        if (array instanceof BigLongArray) {
            ((BigLongArray)array).resize(size);
            return array;
        }
        AbstractArray arr = (AbstractArray)((Object)array);
        LongArray newArray = this.newLongArray(size, arr.clearOnResize);
        long end = Math.min(size, array.size());
        for (long i = 0L; i < end; ++i) {
            newArray.set(i, array.get(i));
        }
        array.release();
        return newArray;
    }

    public LongArray grow(LongArray array, long minSize) {
        if (minSize <= array.size()) {
            return array;
        }
        long newSize = BigArrays.overSize(minSize, 2048, 8);
        return this.resize(array, newSize);
    }

    public DoubleArray newDoubleArray(long size, boolean clearOnResize) {
        if (size > 2048L) {
            return new BigDoubleArray(size, this.recycler, clearOnResize);
        }
        if (size >= 1024L && this.recycler != null) {
            Recycler.V<double[]> page = this.recycler.doublePage(clearOnResize);
            return new DoubleArrayWrapper(page.v(), size, page, clearOnResize);
        }
        return new DoubleArrayWrapper(new double[(int)size], size, null, clearOnResize);
    }

    public DoubleArray newDoubleArray(long size) {
        return this.newDoubleArray(size, true);
    }

    public DoubleArray resize(DoubleArray array, long size) {
        if (array instanceof BigDoubleArray) {
            ((BigDoubleArray)array).resize(size);
            return array;
        }
        AbstractArray arr = (AbstractArray)((Object)array);
        DoubleArray newArray = this.newDoubleArray(size, arr.clearOnResize);
        long end = Math.min(size, array.size());
        for (long i = 0L; i < end; ++i) {
            newArray.set(i, array.get(i));
        }
        array.release();
        return newArray;
    }

    public DoubleArray grow(DoubleArray array, long minSize) {
        if (minSize <= array.size()) {
            return array;
        }
        long newSize = BigArrays.overSize(minSize, 2048, 8);
        return this.resize(array, newSize);
    }

    public FloatArray newFloatArray(long size, boolean clearOnResize) {
        if (size > 4096L) {
            return new BigFloatArray(size, this.recycler, clearOnResize);
        }
        if (size >= 2048L && this.recycler != null) {
            Recycler.V<float[]> page = this.recycler.floatPage(clearOnResize);
            return new FloatArrayWrapper(page.v(), size, page, clearOnResize);
        }
        return new FloatArrayWrapper(new float[(int)size], size, null, clearOnResize);
    }

    public FloatArray newFloatArray(long size) {
        return this.newFloatArray(size, true);
    }

    public FloatArray resize(FloatArray array, long size) {
        if (array instanceof BigFloatArray) {
            ((BigFloatArray)array).resize(size);
            return array;
        }
        AbstractArray arr = (AbstractArray)((Object)array);
        FloatArray newArray = this.newFloatArray(size, arr.clearOnResize);
        long end = Math.min(size, array.size());
        for (long i = 0L; i < end; ++i) {
            newArray.set(i, array.get(i));
        }
        return newArray;
    }

    public FloatArray grow(FloatArray array, long minSize) {
        if (minSize <= array.size()) {
            return array;
        }
        long newSize = BigArrays.overSize(minSize, 4096, 4);
        return this.resize(array, newSize);
    }

    public <T> ObjectArray<T> newObjectArray(long size) {
        if (size > (long)OBJECT_PAGE_SIZE) {
            return new BigObjectArray(size, this.recycler);
        }
        if (size >= (long)(OBJECT_PAGE_SIZE / 2) && this.recycler != null) {
            Recycler.V<Object[]> page = this.recycler.objectPage();
            return new ObjectArrayWrapper(page.v(), size, page);
        }
        return new ObjectArrayWrapper(new Object[(int)size], size, null);
    }

    public <T> ObjectArray<T> resize(ObjectArray<T> array, long size) {
        if (array instanceof BigObjectArray) {
            ((BigObjectArray)array).resize(size);
            return array;
        }
        ObjectArray<T> newArray = this.newObjectArray(size);
        long end = Math.min(size, array.size());
        for (long i = 0L; i < end; ++i) {
            newArray.set(i, array.get(i));
        }
        array.release();
        return newArray;
    }

    public <T> ObjectArray<T> grow(ObjectArray<T> array, long minSize) {
        if (minSize <= array.size()) {
            return array;
        }
        long newSize = BigArrays.overSize(minSize, OBJECT_PAGE_SIZE, RamUsageEstimator.NUM_BYTES_OBJECT_REF);
        return this.resize(array, newSize);
    }

    private static class ObjectArrayWrapper<T>
    extends AbstractArrayWrapper
    implements ObjectArray<T> {
        private final Object[] array;

        ObjectArrayWrapper(Object[] array, long size, Recycler.V<Object[]> releasable) {
            super(size, releasable, true);
            this.array = array;
        }

        @Override
        public T get(long index) {
            assert (BigArrays.indexIsInt(index));
            return (T)this.array[(int)index];
        }

        @Override
        public T set(long index, T value) {
            assert (BigArrays.indexIsInt(index));
            Object ret = this.array[(int)index];
            this.array[(int)index] = value;
            return (T)ret;
        }
    }

    private static class FloatArrayWrapper
    extends AbstractArrayWrapper
    implements FloatArray {
        private final float[] array;

        FloatArrayWrapper(float[] array, long size, Recycler.V<float[]> releasable, boolean clearOnResize) {
            super(size, releasable, clearOnResize);
            this.array = array;
        }

        @Override
        public float get(long index) {
            assert (BigArrays.indexIsInt(index));
            return this.array[(int)index];
        }

        @Override
        public float set(long index, float value) {
            assert (BigArrays.indexIsInt(index));
            float ret = this.array[(int)index];
            this.array[(int)index] = value;
            return ret;
        }

        @Override
        public float increment(long index, float inc) {
            assert (BigArrays.indexIsInt(index));
            int n = (int)index;
            float f = this.array[n] + inc;
            this.array[n] = f;
            return f;
        }

        @Override
        public void fill(long fromIndex, long toIndex, float value) {
            assert (BigArrays.indexIsInt(fromIndex));
            assert (BigArrays.indexIsInt(toIndex));
            Arrays.fill(this.array, (int)fromIndex, (int)toIndex, value);
        }
    }

    private static class DoubleArrayWrapper
    extends AbstractArrayWrapper
    implements DoubleArray {
        private final double[] array;

        DoubleArrayWrapper(double[] array, long size, Recycler.V<double[]> releasable, boolean clearOnResize) {
            super(size, releasable, clearOnResize);
            this.array = array;
        }

        @Override
        public double get(long index) {
            assert (BigArrays.indexIsInt(index));
            return this.array[(int)index];
        }

        @Override
        public double set(long index, double value) {
            assert (BigArrays.indexIsInt(index));
            double ret = this.array[(int)index];
            this.array[(int)index] = value;
            return ret;
        }

        @Override
        public double increment(long index, double inc) {
            assert (BigArrays.indexIsInt(index));
            int n = (int)index;
            double d = this.array[n] + inc;
            this.array[n] = d;
            return d;
        }

        @Override
        public void fill(long fromIndex, long toIndex, double value) {
            assert (BigArrays.indexIsInt(fromIndex));
            assert (BigArrays.indexIsInt(toIndex));
            Arrays.fill(this.array, (int)fromIndex, (int)toIndex, value);
        }
    }

    private static class LongArrayWrapper
    extends AbstractArrayWrapper
    implements LongArray {
        private final long[] array;

        LongArrayWrapper(long[] array, long size, Recycler.V<long[]> releasable, boolean clearOnResize) {
            super(size, releasable, clearOnResize);
            this.array = array;
        }

        @Override
        public long get(long index) {
            assert (BigArrays.indexIsInt(index));
            return this.array[(int)index];
        }

        @Override
        public long set(long index, long value) {
            assert (BigArrays.indexIsInt(index));
            long ret = this.array[(int)index];
            this.array[(int)index] = value;
            return ret;
        }

        @Override
        public long increment(long index, long inc) {
            assert (BigArrays.indexIsInt(index));
            int n = (int)index;
            long l = this.array[n] + inc;
            this.array[n] = l;
            return l;
        }

        @Override
        public void fill(long fromIndex, long toIndex, long value) {
            assert (BigArrays.indexIsInt(fromIndex));
            assert (BigArrays.indexIsInt(toIndex));
            Arrays.fill(this.array, (int)fromIndex, (int)toIndex, value);
        }
    }

    private static class IntArrayWrapper
    extends AbstractArrayWrapper
    implements IntArray {
        private final int[] array;

        IntArrayWrapper(int[] array, long size, Recycler.V<int[]> releasable, boolean clearOnResize) {
            super(size, releasable, clearOnResize);
            this.array = array;
        }

        @Override
        public int get(long index) {
            assert (BigArrays.indexIsInt(index));
            return this.array[(int)index];
        }

        @Override
        public int set(long index, int value) {
            assert (BigArrays.indexIsInt(index));
            int ret = this.array[(int)index];
            this.array[(int)index] = value;
            return ret;
        }

        @Override
        public int increment(long index, int inc) {
            assert (BigArrays.indexIsInt(index));
            int n = (int)index;
            int n2 = this.array[n] + inc;
            this.array[n] = n2;
            return n2;
        }

        @Override
        public void fill(long fromIndex, long toIndex, int value) {
            assert (BigArrays.indexIsInt(fromIndex));
            assert (BigArrays.indexIsInt(toIndex));
            Arrays.fill(this.array, (int)fromIndex, (int)toIndex, value);
        }
    }

    private static class ByteArrayWrapper
    extends AbstractArrayWrapper
    implements ByteArray {
        private final byte[] array;

        ByteArrayWrapper(byte[] array, long size, Recycler.V<byte[]> releasable, boolean clearOnResize) {
            super(size, releasable, clearOnResize);
            this.array = array;
        }

        @Override
        public byte get(long index) {
            assert (BigArrays.indexIsInt(index));
            return this.array[(int)index];
        }

        @Override
        public byte set(long index, byte value) {
            assert (BigArrays.indexIsInt(index));
            byte ret = this.array[(int)index];
            this.array[(int)index] = value;
            return ret;
        }

        @Override
        public void get(long index, int len, BytesRef ref) {
            assert (BigArrays.indexIsInt(index));
            ref.bytes = this.array;
            ref.offset = (int)index;
            ref.length = len;
        }

        @Override
        public void set(long index, byte[] buf, int offset, int len) {
            assert (BigArrays.indexIsInt(index));
            System.arraycopy(buf, offset, this.array, (int)index, len);
        }

        @Override
        public void fill(long fromIndex, long toIndex, byte value) {
            assert (BigArrays.indexIsInt(fromIndex));
            assert (BigArrays.indexIsInt(toIndex));
            Arrays.fill(this.array, (int)fromIndex, (int)toIndex, value);
        }
    }

    private static abstract class AbstractArrayWrapper
    extends AbstractArray {
        private final Releasable releasable;
        private final long size;

        AbstractArrayWrapper(long size, Releasable releasable, boolean clearOnResize) {
            super(clearOnResize);
            this.releasable = releasable;
            this.size = size;
        }

        public final long size() {
            return this.size;
        }

        @Override
        public final boolean release() {
            Releasables.release(this.releasable);
            return true;
        }
    }
}

