/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.percentiles;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.hppc.DoubleArrayList;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.metrics.percentiles.InternalPercentiles;
import org.elasticsearch.search.aggregations.metrics.percentiles.PercentilesAggregator;
import org.elasticsearch.search.aggregations.metrics.percentiles.PercentilesEstimator;
import org.elasticsearch.search.aggregations.metrics.percentiles.tdigest.TDigest;
import org.elasticsearch.search.aggregations.support.FieldContext;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.numeric.NumericValuesSource;
import org.elasticsearch.search.internal.SearchContext;

public class PercentilesParser
implements Aggregator.Parser {
    private static final double[] DEFAULT_PERCENTS = new double[]{1.0, 5.0, 25.0, 50.0, 75.0, 95.0, 99.0};

    @Override
    public String type() {
        return InternalPercentiles.TYPE.name();
    }

    @Override
    public AggregatorFactory parse(String aggregationName, XContentParser parser, SearchContext context) throws IOException {
        XContentParser.Token token;
        ValuesSourceConfig<NumericValuesSource> config = new ValuesSourceConfig<NumericValuesSource>(NumericValuesSource.class);
        String field = null;
        String script = null;
        String scriptLang = null;
        double[] percents = DEFAULT_PERCENTS;
        Map<String, Object> scriptParams = null;
        boolean assumeSorted = false;
        boolean keyed = true;
        HashMap<String, Object> settings = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if ("field".equals(currentFieldName)) {
                    field = parser.text();
                    continue;
                }
                if ("script".equals(currentFieldName)) {
                    script = parser.text();
                    continue;
                }
                if ("lang".equals(currentFieldName)) {
                    scriptLang = parser.text();
                    continue;
                }
                if (settings == null) {
                    settings = new HashMap<String, Object>();
                }
                settings.put(currentFieldName, parser.text());
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if ("percents".equals(currentFieldName)) {
                    DoubleArrayList values = new DoubleArrayList(10);
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        double percent = parser.doubleValue();
                        if (percent < 0.0 || percent > 100.0) {
                            throw new SearchParseException(context, "the percents in the percentiles aggregation [" + aggregationName + "] must be in the [0, 100] range");
                        }
                        values.add(percent);
                    }
                    percents = values.toArray();
                    Arrays.sort(percents);
                    continue;
                }
                throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].");
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if ("params".equals(currentFieldName)) {
                    scriptParams = parser.map();
                    continue;
                }
                throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].");
            }
            if (token == XContentParser.Token.VALUE_BOOLEAN) {
                if ("script_values_sorted".equals(currentFieldName) || "scriptValuesSorted".equals(currentFieldName)) {
                    assumeSorted = parser.booleanValue();
                }
                if ("keyed".equals(currentFieldName)) {
                    keyed = parser.booleanValue();
                    continue;
                }
                if (settings == null) {
                    settings = new HashMap();
                }
                settings.put(currentFieldName, parser.booleanValue());
                continue;
            }
            if (token == XContentParser.Token.VALUE_NUMBER) {
                if (settings == null) {
                    settings = new HashMap();
                }
                settings.put(currentFieldName, parser.numberValue());
                continue;
            }
            throw new SearchParseException(context, "Unexpected token " + (Object)((Object)token) + " in [" + aggregationName + "].");
        }
        PercentilesEstimator.Factory estimatorFactory = EstimatorType.TDIGEST.estimatorFactory(settings);
        if (script != null) {
            config.script(context.scriptService().search(context.lookup(), scriptLang, script, scriptParams));
        }
        if (!assumeSorted) {
            config.ensureSorted(true);
        }
        if (field == null) {
            return new PercentilesAggregator.Factory(aggregationName, config, percents, estimatorFactory, keyed);
        }
        FieldMapper mapper = context.smartNameFieldMapper(field);
        if (mapper == null) {
            config.unmapped(true);
            return new PercentilesAggregator.Factory(aggregationName, config, percents, estimatorFactory, keyed);
        }
        Object indexFieldData = context.fieldData().getForField(mapper);
        config.fieldContext(new FieldContext(field, (IndexFieldData<?>)indexFieldData));
        return new PercentilesAggregator.Factory(aggregationName, config, percents, estimatorFactory, keyed);
    }

    public static enum EstimatorType {
        TDIGEST{

            @Override
            public PercentilesEstimator.Factory estimatorFactory(Map<String, Object> settings) {
                return new TDigest.Factory(settings);
            }
        };


        public abstract PercentilesEstimator.Factory estimatorFactory(Map<String, Object> var1);

        public static EstimatorType resolve(String name, SearchContext context) {
            if (name.equals("tdigest")) {
                return TDIGEST;
            }
            throw new SearchParseException(context, "Unknown percentile estimator [" + name + "]");
        }
    }
}

