/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.datehistogram;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.cache.recycler.CacheRecycler;
import org.elasticsearch.common.hppc.LongObjectOpenHashMap;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.rounding.TimeZoneRounding;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.LongValues;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.LongFacetAggregatorBase;
import org.elasticsearch.search.facet.datehistogram.DateHistogramFacet;
import org.elasticsearch.search.facet.datehistogram.InternalFullDateHistogramFacet;

public class ValueScriptDateHistogramFacetExecutor
extends FacetExecutor {
    private final IndexNumericFieldData keyIndexFieldData;
    private final DateHistogramFacet.ComparatorType comparatorType;
    final SearchScript valueScript;
    final TimeZoneRounding tzRounding;
    final Recycler.V<LongObjectOpenHashMap<InternalFullDateHistogramFacet.FullEntry>> entries;

    public ValueScriptDateHistogramFacetExecutor(IndexNumericFieldData keyIndexFieldData, SearchScript valueScript, TimeZoneRounding tzRounding, DateHistogramFacet.ComparatorType comparatorType, CacheRecycler cacheRecycler) {
        this.comparatorType = comparatorType;
        this.keyIndexFieldData = keyIndexFieldData;
        this.valueScript = valueScript;
        this.tzRounding = tzRounding;
        this.entries = cacheRecycler.longObjectMap(-1);
    }

    @Override
    public Collector collector() {
        return new Collector();
    }

    @Override
    public InternalFacet buildFacet(String facetName) {
        ArrayList<InternalFullDateHistogramFacet.FullEntry> entries1 = new ArrayList<InternalFullDateHistogramFacet.FullEntry>(this.entries.v().size());
        boolean[] states = this.entries.v().allocated;
        VType[] values = this.entries.v().values;
        for (int i = 0; i < states.length; ++i) {
            if (!states[i]) continue;
            InternalFullDateHistogramFacet.FullEntry value = (InternalFullDateHistogramFacet.FullEntry)values[i];
            entries1.add(value);
        }
        this.entries.release();
        return new InternalFullDateHistogramFacet(facetName, this.comparatorType, entries1);
    }

    public static class DateHistogramProc
    extends LongFacetAggregatorBase {
        private final TimeZoneRounding tzRounding;
        protected final SearchScript valueScript;
        final LongObjectOpenHashMap<InternalFullDateHistogramFacet.FullEntry> entries;

        public DateHistogramProc(TimeZoneRounding tzRounding, SearchScript valueScript, LongObjectOpenHashMap<InternalFullDateHistogramFacet.FullEntry> entries) {
            this.tzRounding = tzRounding;
            this.valueScript = valueScript;
            this.entries = entries;
        }

        @Override
        public void onValue(int docId, long value) {
            this.valueScript.setNextDocId(docId);
            long time = this.tzRounding.round(value);
            double scriptValue = this.valueScript.runAsDouble();
            InternalFullDateHistogramFacet.FullEntry entry = this.entries.get(time);
            if (entry == null) {
                entry = new InternalFullDateHistogramFacet.FullEntry(time, 1L, scriptValue, scriptValue, 1L, scriptValue);
                this.entries.put(time, entry);
            } else {
                ++entry.count;
                ++entry.totalCount;
                entry.total += scriptValue;
                if (scriptValue < entry.min) {
                    entry.min = scriptValue;
                }
                if (scriptValue > entry.max) {
                    entry.max = scriptValue;
                }
            }
        }
    }

    class Collector
    extends FacetExecutor.Collector {
        private final DateHistogramProc histoProc;
        private LongValues keyValues;

        public Collector() {
            this.histoProc = new DateHistogramProc(ValueScriptDateHistogramFacetExecutor.this.tzRounding, ValueScriptDateHistogramFacetExecutor.this.valueScript, ValueScriptDateHistogramFacetExecutor.this.entries.v());
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            ValueScriptDateHistogramFacetExecutor.this.valueScript.setScorer(scorer);
        }

        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.keyValues = ValueScriptDateHistogramFacetExecutor.this.keyIndexFieldData.load(context).getLongValues();
            ValueScriptDateHistogramFacetExecutor.this.valueScript.setNextReader(context);
        }

        public void collect(int doc) throws IOException {
            this.histoProc.onDoc(doc, this.keyValues);
        }

        @Override
        public void postCollection() {
        }
    }
}

