/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.create;

import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.cluster.ack.ClusterStateUpdateRequest;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;

public class CreateIndexClusterStateUpdateRequest
extends ClusterStateUpdateRequest<CreateIndexClusterStateUpdateRequest> {
    final String cause;
    final String index;
    private IndexMetaData.State state = IndexMetaData.State.OPEN;
    private Settings settings = ImmutableSettings.Builder.EMPTY_SETTINGS;
    private final Map<String, String> mappings = Maps.newHashMap();
    private final Set<Alias> aliases = Sets.newHashSet();
    private final Map<String, IndexMetaData.Custom> customs = Maps.newHashMap();
    private final Set<ClusterBlock> blocks = Sets.newHashSet();

    CreateIndexClusterStateUpdateRequest(String cause, String index) {
        this.cause = cause;
        this.index = index;
    }

    public CreateIndexClusterStateUpdateRequest settings(Settings settings) {
        this.settings = settings;
        return this;
    }

    public CreateIndexClusterStateUpdateRequest mappings(Map<String, String> mappings) {
        this.mappings.putAll(mappings);
        return this;
    }

    public CreateIndexClusterStateUpdateRequest aliases(Set<Alias> aliases) {
        this.aliases.addAll(aliases);
        return this;
    }

    public CreateIndexClusterStateUpdateRequest customs(Map<String, IndexMetaData.Custom> customs) {
        this.customs.putAll(customs);
        return this;
    }

    public CreateIndexClusterStateUpdateRequest blocks(Set<ClusterBlock> blocks) {
        this.blocks.addAll(blocks);
        return this;
    }

    public CreateIndexClusterStateUpdateRequest state(IndexMetaData.State state) {
        this.state = state;
        return this;
    }

    public String cause() {
        return this.cause;
    }

    public String index() {
        return this.index;
    }

    public IndexMetaData.State state() {
        return this.state;
    }

    public Settings settings() {
        return this.settings;
    }

    public Map<String, String> mappings() {
        return this.mappings;
    }

    public Set<Alias> aliases() {
        return this.aliases;
    }

    public Map<String, IndexMetaData.Custom> customs() {
        return this.customs;
    }

    public Set<ClusterBlock> blocks() {
        return this.blocks;
    }
}

