/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.fieldcomparator;

import java.io.IOException;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.fieldcomparator.LongValuesComparatorBase;
import org.elasticsearch.index.fielddata.fieldcomparator.SortMode;

public final class LongValuesComparator
extends LongValuesComparatorBase<Long> {
    private final long[] values;

    public LongValuesComparator(IndexNumericFieldData<?> indexFieldData, long missingValue, int numHits, SortMode sortMode) {
        super(indexFieldData, missingValue, sortMode);
        this.values = new long[numHits];
        assert (indexFieldData.getNumericType().requiredBits() <= 64);
    }

    public int compare(int slot1, int slot2) {
        long v1 = this.values[slot1];
        long v2 = this.values[slot2];
        return LongValuesComparator.compare(v1, v2);
    }

    public void setBottom(int slot) {
        this.bottom = this.values[slot];
    }

    public void copy(int slot, int doc) throws IOException {
        this.values[slot] = this.sortMode.getRelevantValue(this.readerValues, doc, this.missingValue);
    }

    public Long value(int slot) {
        return this.values[slot];
    }

    @Override
    public void add(int slot, int doc) {
        int n = slot;
        this.values[n] = this.values[n] + this.sortMode.getRelevantValue(this.readerValues, doc, this.missingValue);
    }

    @Override
    public void divide(int slot, int divisor) {
        int n = slot;
        this.values[n] = this.values[n] / (long)divisor;
    }

    @Override
    public void missing(int slot) {
        this.values[slot] = this.missingValue;
    }
}

