/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.geo;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.lucene.docset.DocIdSets;
import org.elasticsearch.index.mapper.geo.GeoPointFieldMapper;

public class IndexedGeoBoundingBoxFilter {
    public static Filter create(GeoPoint topLeft, GeoPoint bottomRight, GeoPointFieldMapper fieldMapper) {
        if (!fieldMapper.isEnableLatLon()) {
            throw new ElasticsearchIllegalArgumentException("lat/lon is not enabled (indexed) for field [" + fieldMapper.name() + "], can't use indexed filter on it");
        }
        if (topLeft.lon() > bottomRight.lon()) {
            return new WestGeoBoundingBoxFilter(topLeft, bottomRight, fieldMapper);
        }
        return new EastGeoBoundingBoxFilter(topLeft, bottomRight, fieldMapper);
    }

    static class EastGeoBoundingBoxFilter
    extends Filter {
        final Filter lonFilter;
        final Filter latFilter;

        public EastGeoBoundingBoxFilter(GeoPoint topLeft, GeoPoint bottomRight, GeoPointFieldMapper fieldMapper) {
            this.lonFilter = fieldMapper.lonMapper().rangeFilter(topLeft.lon(), bottomRight.lon(), true, true);
            this.latFilter = fieldMapper.latMapper().rangeFilter(bottomRight.lat(), topLeft.lat(), true, true);
        }

        public FixedBitSet getDocIdSet(AtomicReaderContext context, Bits acceptedDocs) throws IOException {
            DocIdSet set = this.lonFilter.getDocIdSet(context, acceptedDocs);
            if (DocIdSets.isEmpty(set)) {
                return null;
            }
            FixedBitSet main = (FixedBitSet)set;
            set = this.latFilter.getDocIdSet(context, acceptedDocs);
            if (DocIdSets.isEmpty(set)) {
                return null;
            }
            main.and(set.iterator());
            return main;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            EastGeoBoundingBoxFilter that = (EastGeoBoundingBoxFilter)((Object)o);
            if (this.latFilter != null ? !this.latFilter.equals(that.latFilter) : that.latFilter != null) {
                return false;
            }
            return !(this.lonFilter != null ? !this.lonFilter.equals(that.lonFilter) : that.lonFilter != null);
        }

        public int hashCode() {
            int result = this.lonFilter != null ? this.lonFilter.hashCode() : 0;
            result = 31 * result + (this.latFilter != null ? this.latFilter.hashCode() : 0);
            return result;
        }
    }

    static class WestGeoBoundingBoxFilter
    extends Filter {
        final Filter lonFilter1;
        final Filter lonFilter2;
        final Filter latFilter;

        public WestGeoBoundingBoxFilter(GeoPoint topLeft, GeoPoint bottomRight, GeoPointFieldMapper fieldMapper) {
            this.lonFilter1 = fieldMapper.lonMapper().rangeFilter(null, bottomRight.lon(), true, true);
            this.lonFilter2 = fieldMapper.lonMapper().rangeFilter(topLeft.lon(), null, true, true);
            this.latFilter = fieldMapper.latMapper().rangeFilter(bottomRight.lat(), topLeft.lat(), true, true);
        }

        public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptedDocs) throws IOException {
            DocIdSet set = this.lonFilter1.getDocIdSet(context, acceptedDocs);
            FixedBitSet main = DocIdSets.isEmpty(set) ? null : (FixedBitSet)set;
            set = this.lonFilter2.getDocIdSet(context, acceptedDocs);
            if (DocIdSets.isEmpty(set)) {
                if (main == null) {
                    return null;
                }
            } else if (main == null) {
                main = (FixedBitSet)set;
            } else {
                main.or((FixedBitSet)set);
            }
            if (DocIdSets.isEmpty(set = this.latFilter.getDocIdSet(context, acceptedDocs))) {
                return null;
            }
            main.and(set.iterator());
            return main;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            WestGeoBoundingBoxFilter that = (WestGeoBoundingBoxFilter)((Object)o);
            if (this.latFilter != null ? !this.latFilter.equals(that.latFilter) : that.latFilter != null) {
                return false;
            }
            if (this.lonFilter1 != null ? !this.lonFilter1.equals(that.lonFilter1) : that.lonFilter1 != null) {
                return false;
            }
            return !(this.lonFilter2 != null ? !this.lonFilter2.equals(that.lonFilter2) : that.lonFilter2 != null);
        }

        public int hashCode() {
            int result = this.lonFilter1 != null ? this.lonFilter1.hashCode() : 0;
            result = 31 * result + (this.lonFilter2 != null ? this.lonFilter2.hashCode() : 0);
            result = 31 * result + (this.latFilter != null ? this.latFilter.hashCode() : 0);
            return result;
        }
    }
}

