/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.significant;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.bucket.significant.SignificantTermsAggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.significant.UnmappedSignificantTerms;
import org.elasticsearch.search.aggregations.support.AggregationContext;

public class UnmappedSignificantTermsAggregator
extends Aggregator {
    private final int requiredSize;
    private final long minDocCount;
    private final SignificantTermsAggregatorFactory termsAggFactory;

    public UnmappedSignificantTermsAggregator(String name, int requiredSize, long minDocCount, AggregationContext aggregationContext, Aggregator parent, SignificantTermsAggregatorFactory termsAggFactory) {
        super(name, Aggregator.BucketAggregationMode.PER_BUCKET, AggregatorFactories.EMPTY, 0L, aggregationContext, parent);
        this.requiredSize = requiredSize;
        this.minDocCount = minDocCount;
        this.termsAggFactory = termsAggFactory;
    }

    @Override
    public boolean shouldCollect() {
        return false;
    }

    @Override
    public void setNextReader(AtomicReaderContext reader) {
    }

    @Override
    public void collect(int doc, long owningBucketOrdinal) throws IOException {
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        assert (owningBucketOrdinal == 0L);
        return new UnmappedSignificantTerms(this.name, this.requiredSize, this.minDocCount);
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new UnmappedSignificantTerms(this.name, this.requiredSize, this.minDocCount);
    }

    @Override
    protected void doRelease() {
        Releasables.release(this.termsAggFactory);
    }
}

