/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.percentiles.tdigest;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.search.aggregations.metrics.percentiles.PercentilesEstimator;
import org.elasticsearch.search.aggregations.metrics.percentiles.tdigest.TDigestState;
import org.elasticsearch.search.aggregations.support.AggregationContext;

public class TDigest
extends PercentilesEstimator {
    public static final byte ID = 0;
    private final BigArrays bigArrays;
    private ObjectArray<TDigestState> states;
    private final double compression;

    public TDigest(double[] percents, double compression, long estimatedBucketsCount, AggregationContext context) {
        super(percents);
        this.bigArrays = context.bigArrays();
        this.states = this.bigArrays.newObjectArray(estimatedBucketsCount);
        this.compression = compression;
    }

    @Override
    public boolean release() throws ElasticsearchException {
        this.states.release();
        return true;
    }

    @Override
    public void offer(double value, long bucketOrd) {
        this.states = this.bigArrays.grow(this.states, bucketOrd + 1L);
        TDigestState state = this.states.get(bucketOrd);
        if (state == null) {
            state = new TDigestState(this.compression);
            this.states.set(bucketOrd, state);
        }
        state.add(value);
    }

    @Override
    public PercentilesEstimator.Result result(long bucketOrd) {
        if (bucketOrd >= this.states.size() || this.states.get(bucketOrd) == null) {
            return this.emptyResult();
        }
        return new Result(this.percents, this.states.get(bucketOrd));
    }

    @Override
    public PercentilesEstimator.Result emptyResult() {
        return new Result(this.percents, new TDigestState(this.compression));
    }

    public static class Factory
    implements PercentilesEstimator.Factory {
        private final double compression;

        public Factory(Map<String, Object> settings) {
            Object compressionObject;
            double compression = 100.0;
            if (settings != null && (compressionObject = settings.get("compression")) != null) {
                if (!(compressionObject instanceof Number)) {
                    throw new ElasticsearchIllegalArgumentException("tdigest compression must be number, got a " + compressionObject.getClass());
                }
                compression = ((Number)compressionObject).doubleValue();
            }
            this.compression = compression;
        }

        public TDigest create(double[] percents, long estimtedBucketCount, AggregationContext context) {
            return new TDigest(percents, this.compression, estimtedBucketCount, context);
        }
    }

    public static class Result
    extends PercentilesEstimator.Result<TDigest, Result> {
        private TDigestState state;

        public Result() {
        }

        public Result(double[] percents, TDigestState state) {
            super(percents);
            this.state = state;
        }

        @Override
        protected byte id() {
            return 0;
        }

        @Override
        public double estimate(int index) {
            return this.state.quantile(this.percents[index] / 100.0);
        }

        public Merger merger(int estimatedMerges) {
            return new Merger();
        }

        public static Result read(StreamInput in) throws IOException {
            Result result = new Result();
            result.readFrom(in);
            return result;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.percents = new double[in.readInt()];
            for (int i = 0; i < this.percents.length; ++i) {
                this.percents[i] = in.readDouble();
            }
            this.state = TDigestState.read(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeInt(this.percents.length);
            for (int i = 0; i < this.percents.length; ++i) {
                out.writeDouble(this.percents[i]);
            }
            TDigestState.write(this.state, out);
        }

        private class Merger
        implements PercentilesEstimator.Result.Merger<TDigest, Result> {
            private Result merged;

            private Merger() {
            }

            @Override
            public void add(Result result) {
                if (this.merged == null || this.merged.state == null) {
                    this.merged = result;
                    return;
                }
                if (result.state == null || result.state.size() == 0L) {
                    return;
                }
                this.merged.state.add(result.state);
            }

            @Override
            public Result merge() {
                return this.merged;
            }
        }
    }
}

