/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.util.BigDoubleArrayList;
import org.elasticsearch.index.fielddata.AbstractAtomicNumericFieldData;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.index.fielddata.LongValues;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.plain.DenseDoubleValues;
import org.elasticsearch.index.fielddata.plain.DenseLongValues;

public abstract class DoubleArrayAtomicFieldData
extends AbstractAtomicNumericFieldData {
    private final int numDocs;
    protected long size = -1L;

    public static DoubleArrayAtomicFieldData empty(int numDocs) {
        return new Empty(numDocs);
    }

    public DoubleArrayAtomicFieldData(int numDocs) {
        super(true);
        this.numDocs = numDocs;
    }

    @Override
    public void close() {
    }

    @Override
    public int getNumDocs() {
        return this.numDocs;
    }

    public static class Single
    extends DoubleArrayAtomicFieldData {
        private final BigDoubleArrayList values;
        private final long numOrds;

        public Single(BigDoubleArrayList values, int numDocs, long numOrds) {
            super(numDocs);
            this.values = values;
            this.numOrds = numOrds;
        }

        @Override
        public boolean isMultiValued() {
            return false;
        }

        @Override
        public boolean isValuesOrdered() {
            return false;
        }

        @Override
        public long getNumberUniqueValues() {
            return this.numOrds;
        }

        @Override
        public long getMemorySizeInBytes() {
            if (this.size == -1L) {
                this.size = (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + this.values.sizeInBytes();
            }
            return this.size;
        }

        @Override
        public LongValues getLongValues() {
            return new LongValues(this.values);
        }

        @Override
        public DoubleValues getDoubleValues() {
            return new DoubleValues(this.values);
        }

        static final class DoubleValues
        extends DenseDoubleValues {
            private final BigDoubleArrayList values;

            DoubleValues(BigDoubleArrayList values) {
                super(false);
                this.values = values;
            }

            @Override
            public double nextValue() {
                return this.values.get(this.docId);
            }
        }

        static final class LongValues
        extends DenseLongValues {
            private final BigDoubleArrayList values;

            LongValues(BigDoubleArrayList values) {
                super(false);
                this.values = values;
            }

            @Override
            public long nextValue() {
                return (long)this.values.get(this.docId);
            }
        }
    }

    public static class SingleFixedSet
    extends DoubleArrayAtomicFieldData {
        private final BigDoubleArrayList values;
        private final FixedBitSet set;
        private final long numOrds;

        public SingleFixedSet(BigDoubleArrayList values, int numDocs, FixedBitSet set, long numOrds) {
            super(numDocs);
            this.values = values;
            this.set = set;
            this.numOrds = numOrds;
        }

        @Override
        public boolean isMultiValued() {
            return false;
        }

        @Override
        public boolean isValuesOrdered() {
            return false;
        }

        @Override
        public long getNumberUniqueValues() {
            return this.numOrds;
        }

        @Override
        public long getMemorySizeInBytes() {
            if (this.size == -1L) {
                this.size = (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + this.values.sizeInBytes() + RamUsageEstimator.sizeOf((long[])this.set.getBits());
            }
            return this.size;
        }

        @Override
        public LongValues getLongValues() {
            return new LongValues(this.values, this.set);
        }

        @Override
        public DoubleValues getDoubleValues() {
            return new DoubleValues(this.values, this.set);
        }

        static class DoubleValues
        extends org.elasticsearch.index.fielddata.DoubleValues {
            private final BigDoubleArrayList values;
            private final FixedBitSet set;

            DoubleValues(BigDoubleArrayList values, FixedBitSet set) {
                super(false);
                this.values = values;
                this.set = set;
            }

            @Override
            public int setDocument(int docId) {
                this.docId = docId;
                return this.set.get(docId) ? 1 : 0;
            }

            @Override
            public double nextValue() {
                return this.values.get(this.docId);
            }
        }

        static class LongValues
        extends org.elasticsearch.index.fielddata.LongValues {
            private final BigDoubleArrayList values;
            private final FixedBitSet set;

            LongValues(BigDoubleArrayList values, FixedBitSet set) {
                super(false);
                this.values = values;
                this.set = set;
            }

            @Override
            public int setDocument(int docId) {
                this.docId = docId;
                return this.set.get(docId) ? 1 : 0;
            }

            @Override
            public long nextValue() {
                return (long)this.values.get(this.docId);
            }
        }
    }

    public static class WithOrdinals
    extends DoubleArrayAtomicFieldData {
        private final BigDoubleArrayList values;
        private final Ordinals ordinals;

        public WithOrdinals(BigDoubleArrayList values, int numDocs, Ordinals ordinals) {
            super(numDocs);
            this.values = values;
            this.ordinals = ordinals;
        }

        @Override
        public boolean isMultiValued() {
            return this.ordinals.isMultiValued();
        }

        @Override
        public boolean isValuesOrdered() {
            return true;
        }

        @Override
        public long getNumberUniqueValues() {
            return this.ordinals.getNumOrds();
        }

        @Override
        public long getMemorySizeInBytes() {
            if (this.size == -1L) {
                this.size = 8L + this.values.sizeInBytes() + this.ordinals.getMemorySizeInBytes();
            }
            return this.size;
        }

        @Override
        public LongValues getLongValues() {
            return new LongValues(this.values, this.ordinals.ordinals());
        }

        @Override
        public DoubleValues getDoubleValues() {
            return new DoubleValues(this.values, this.ordinals.ordinals());
        }

        static class DoubleValues
        extends DoubleValues.WithOrdinals {
            private final BigDoubleArrayList values;

            DoubleValues(BigDoubleArrayList values, Ordinals.Docs ordinals) {
                super(ordinals);
                this.values = values;
            }

            @Override
            public double getValueByOrd(long ord) {
                assert (ord != 0L);
                return this.values.get(ord);
            }
        }

        static class LongValues
        extends LongValues.WithOrdinals {
            private final BigDoubleArrayList values;

            LongValues(BigDoubleArrayList values, Ordinals.Docs ordinals) {
                super(ordinals);
                this.values = values;
            }

            @Override
            public final long getValueByOrd(long ord) {
                assert (ord != 0L);
                return (long)this.values.get(ord);
            }
        }
    }

    static class Empty
    extends DoubleArrayAtomicFieldData {
        Empty(int numDocs) {
            super(numDocs);
        }

        @Override
        public LongValues getLongValues() {
            return LongValues.EMPTY;
        }

        @Override
        public DoubleValues getDoubleValues() {
            return DoubleValues.EMPTY;
        }

        @Override
        public boolean isMultiValued() {
            return false;
        }

        @Override
        public boolean isValuesOrdered() {
            return false;
        }

        @Override
        public long getNumberUniqueValues() {
            return 0L;
        }

        @Override
        public long getMemorySizeInBytes() {
            return 0L;
        }

        @Override
        public BytesValues getBytesValues(boolean needsHashes) {
            return BytesValues.EMPTY;
        }

        @Override
        public ScriptDocValues getScriptValues() {
            return ScriptDocValues.EMPTY_DOUBLES;
        }
    }
}

