/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.range.ipv4;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.range.InternalRange;
import org.elasticsearch.search.aggregations.bucket.range.ipv4.IPv4Range;
import org.elasticsearch.search.aggregations.support.numeric.ValueFormatter;

public class InternalIPv4Range
extends InternalRange<Bucket>
implements IPv4Range {
    public static final long MAX_IP = 0x100000000L;
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("ip_range", "iprange");
    private static final AggregationStreams.Stream STREAM = new AggregationStreams.Stream(){

        @Override
        public InternalIPv4Range readResult(StreamInput in) throws IOException {
            InternalIPv4Range range = new InternalIPv4Range();
            range.readFrom(in);
            return range;
        }
    };
    public static final Factory FACTORY = new Factory();

    public static void registerStream() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
    }

    public InternalIPv4Range() {
    }

    public InternalIPv4Range(String name, List<Bucket> ranges, boolean keyed, boolean unmapped) {
        super(name, ranges, ValueFormatter.IPv4, keyed, unmapped);
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    @Override
    protected Bucket createBucket(String key, double from, double to, long docCount, InternalAggregations aggregations, ValueFormatter formatter) {
        return new Bucket(key, from, to, docCount, aggregations, formatter);
    }

    private static class Factory
    extends InternalRange.Factory<Bucket, InternalIPv4Range> {
        private Factory() {
        }

        @Override
        public String type() {
            return TYPE.name();
        }

        @Override
        public InternalIPv4Range create(String name, List<Bucket> ranges, ValueFormatter formatter, boolean keyed, boolean unmapped) {
            return new InternalIPv4Range(name, ranges, keyed, unmapped);
        }

        @Override
        public Bucket createBucket(String key, double from, double to, long docCount, InternalAggregations aggregations, ValueFormatter formatter) {
            return new Bucket(key, from, to, docCount, aggregations, formatter);
        }
    }

    public static class Bucket
    extends InternalRange.Bucket
    implements IPv4Range.Bucket {
        public Bucket(String key, double from, double to, long docCount, List<InternalAggregation> aggregations, ValueFormatter formatter) {
            super(key, from, to, docCount, new InternalAggregations(aggregations), formatter);
        }

        public Bucket(String key, double from, double to, long docCount, InternalAggregations aggregations, ValueFormatter formatter) {
            super(key, from, to, docCount, aggregations, formatter);
        }

        @Override
        public String getFromAsString() {
            double from = this.getFrom().doubleValue();
            return Double.isInfinite(from) ? null : (from == 0.0 ? null : ValueFormatter.IPv4.format(from));
        }

        @Override
        public String getToAsString() {
            double to = this.getTo().doubleValue();
            return Double.isInfinite(to) ? null : (4.294967296E9 == to ? null : ValueFormatter.IPv4.format(to));
        }
    }
}

