/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.AbstractIndexFieldData;
import org.elasticsearch.index.fielddata.AtomicGeoPointFieldData;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.GeoPointValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.fieldcomparator.SortMode;
import org.elasticsearch.index.mapper.FieldMapper;

abstract class AbstractGeoPointIndexFieldData
extends AbstractIndexFieldData<AtomicGeoPointFieldData<ScriptDocValues>>
implements IndexGeoPointFieldData<AtomicGeoPointFieldData<ScriptDocValues>> {
    public AbstractGeoPointIndexFieldData(Index index, Settings indexSettings, FieldMapper.Names fieldNames, FieldDataType fieldDataType, IndexFieldDataCache cache) {
        super(index, indexSettings, fieldNames, fieldDataType, cache);
    }

    @Override
    public boolean valuesOrdered() {
        return false;
    }

    @Override
    public final IndexFieldData.XFieldComparatorSource comparatorSource(@Nullable Object missingValue, SortMode sortMode) {
        throw new ElasticsearchIllegalArgumentException("can't sort on geo_point field without using specific sorting feature, like geo_distance");
    }

    protected static class GeoPointEnum {
        private final BytesRefIterator termsEnum;
        private final GeoPoint next;
        private final CharsRef spare;

        protected GeoPointEnum(BytesRefIterator termsEnum) {
            this.termsEnum = termsEnum;
            this.next = new GeoPoint();
            this.spare = new CharsRef();
        }

        public GeoPoint next() throws IOException {
            BytesRef term = this.termsEnum.next();
            if (term == null) {
                return null;
            }
            UnicodeUtil.UTF8toUTF16((BytesRef)term, (CharsRef)this.spare);
            int commaIndex = -1;
            for (int i = 0; i < this.spare.length; ++i) {
                if (this.spare.chars[this.spare.offset + i] != ',') continue;
                commaIndex = i;
                break;
            }
            if (commaIndex == -1) {
                assert (false);
                return this.next.reset(0.0, 0.0);
            }
            double lat = Double.parseDouble(new String(this.spare.chars, this.spare.offset, commaIndex - this.spare.offset));
            double lon = Double.parseDouble(new String(this.spare.chars, this.spare.offset + (commaIndex + 1), this.spare.length - (commaIndex + 1 - this.spare.offset)));
            return this.next.reset(lat, lon);
        }
    }

    protected static class Empty
    extends AtomicGeoPointFieldData<ScriptDocValues> {
        private final int numDocs;

        Empty(int numDocs) {
            this.numDocs = numDocs;
        }

        @Override
        public boolean isMultiValued() {
            return false;
        }

        @Override
        public boolean isValuesOrdered() {
            return false;
        }

        @Override
        public long getNumberUniqueValues() {
            return 0L;
        }

        @Override
        public long getMemorySizeInBytes() {
            return 0L;
        }

        @Override
        public BytesValues getBytesValues(boolean needsHashes) {
            return BytesValues.EMPTY;
        }

        @Override
        public GeoPointValues getGeoPointValues() {
            return GeoPointValues.EMPTY;
        }

        @Override
        public ScriptDocValues getScriptValues() {
            return ScriptDocValues.EMPTY_GEOPOINTS;
        }

        @Override
        public int getNumDocs() {
            return this.numDocs;
        }

        @Override
        public void close() {
        }
    }
}

