/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.valuecount;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.MetricsAggregator;
import org.elasticsearch.search.aggregations.metrics.valuecount.InternalValueCount;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValueSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.bytes.BytesValuesSource;

public class ValueCountAggregator
extends MetricsAggregator.SingleValue {
    private final BytesValuesSource valuesSource;
    private BytesValues values;
    LongArray counts;

    public ValueCountAggregator(String name, long expectedBucketsCount, BytesValuesSource valuesSource, AggregationContext aggregationContext, Aggregator parent) {
        super(name, 0L, aggregationContext, parent);
        this.valuesSource = valuesSource;
        if (valuesSource != null) {
            long initialSize = expectedBucketsCount < 2L ? 1L : expectedBucketsCount;
            this.counts = this.bigArrays.newLongArray(initialSize, true);
        }
    }

    @Override
    public boolean shouldCollect() {
        return this.valuesSource != null;
    }

    @Override
    public void setNextReader(AtomicReaderContext reader) {
        this.values = this.valuesSource.bytesValues();
    }

    @Override
    public void collect(int doc, long owningBucketOrdinal) throws IOException {
        this.counts = this.bigArrays.grow(this.counts, owningBucketOrdinal + 1L);
        this.counts.increment(owningBucketOrdinal, this.values.setDocument(doc));
    }

    @Override
    public double metric(long owningBucketOrd) {
        return this.valuesSource == null ? 0.0 : (double)this.counts.get(owningBucketOrd);
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        if (this.valuesSource == null) {
            return new InternalValueCount(this.name, 0L);
        }
        assert (owningBucketOrdinal < this.counts.size());
        return new InternalValueCount(this.name, this.counts.get(owningBucketOrdinal));
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalValueCount(this.name, 0L);
    }

    @Override
    public void doRelease() {
        Releasables.release(this.counts);
    }

    public static class Factory
    extends ValueSourceAggregatorFactory.LeafOnly<BytesValuesSource> {
        public Factory(String name, ValuesSourceConfig<BytesValuesSource> valuesSourceBuilder) {
            super(name, InternalValueCount.TYPE.name(), valuesSourceBuilder);
        }

        @Override
        protected Aggregator createUnmapped(AggregationContext aggregationContext, Aggregator parent) {
            return new ValueCountAggregator(this.name, 0L, null, aggregationContext, parent);
        }

        @Override
        protected Aggregator create(BytesValuesSource valuesSource, long expectedBucketsCount, AggregationContext aggregationContext, Aggregator parent) {
            return new ValueCountAggregator(this.name, expectedBucketsCount, valuesSource, aggregationContext, parent);
        }
    }
}

