/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.queries.CommonTermsQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.Version;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.index.mapper.FieldMapper;

public class ExtendedCommonTermsQuery
extends CommonTermsQuery {
    private final FieldMapper<?> mapper;
    private String lowFreqMinNumShouldMatchSpec;
    private String highFreqMinNumShouldMatchSpec;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ExtendedCommonTermsQuery(BooleanClause.Occur highFreqOccur, BooleanClause.Occur lowFreqOccur, float maxTermFrequency, boolean disableCoord, FieldMapper<?> mapper) {
        super(highFreqOccur, lowFreqOccur, maxTermFrequency, disableCoord);
        this.mapper = mapper;
    }

    protected int calcLowFreqMinimumNumberShouldMatch(int numOptional) {
        return this.calcMinimumNumberShouldMatch(this.lowFreqMinNumShouldMatchSpec, numOptional);
    }

    protected int calcMinimumNumberShouldMatch(String spec, int numOptional) {
        if (spec == null) {
            return 0;
        }
        return Queries.calculateMinShouldMatch(numOptional, spec);
    }

    protected int calcHighFreqMinimumNumberShouldMatch(int numOptional) {
        return this.calcMinimumNumberShouldMatch(this.highFreqMinNumShouldMatchSpec, numOptional);
    }

    public void setHighFreqMinimumNumberShouldMatch(String spec) {
        this.highFreqMinNumShouldMatchSpec = spec;
    }

    public String getHighFreqMinimumNumberShouldMatchSpec() {
        return this.highFreqMinNumShouldMatchSpec;
    }

    public void setLowFreqMinimumNumberShouldMatch(String spec) {
        this.lowFreqMinNumShouldMatchSpec = spec;
    }

    public String getLowFreqMinimumNumberShouldMatchSpec() {
        return this.lowFreqMinNumShouldMatchSpec;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        if (this.terms.isEmpty()) {
            return new BooleanQuery();
        }
        if (this.terms.size() == 1) {
            Query tq = this.newTermQuery((Term)this.terms.get(0), null);
            tq.setBoost(this.getBoost());
            return tq;
        }
        return super.rewrite(reader);
    }

    protected Query buildQuery(int maxDoc, TermContext[] contextArray, Term[] queryTerms) {
        int minMustMatch;
        BooleanQuery lowFreq = new BooleanQuery(this.disableCoord);
        BooleanQuery highFreq = new BooleanQuery(this.disableCoord);
        highFreq.setBoost(this.highFreqBoost);
        lowFreq.setBoost(this.lowFreqBoost);
        BooleanQuery query = new BooleanQuery(true);
        for (int i = 0; i < queryTerms.length; ++i) {
            TermContext termContext = contextArray[i];
            if (termContext == null) {
                lowFreq.add(this.newTermQuery(queryTerms[i], null), this.lowFreqOccur);
                continue;
            }
            if (this.maxTermFrequency >= 1.0f && (float)termContext.docFreq() > this.maxTermFrequency || termContext.docFreq() > (int)Math.ceil(this.maxTermFrequency * (float)maxDoc)) {
                highFreq.add(this.newTermQuery(queryTerms[i], termContext), this.highFreqOccur);
                continue;
            }
            lowFreq.add(this.newTermQuery(queryTerms[i], termContext), this.lowFreqOccur);
        }
        int numLowFreqClauses = lowFreq.clauses().size();
        int numHighFreqClauses = highFreq.clauses().size();
        if (this.lowFreqOccur == BooleanClause.Occur.SHOULD && numLowFreqClauses > 0) {
            minMustMatch = this.calcLowFreqMinimumNumberShouldMatch(numLowFreqClauses);
            lowFreq.setMinimumNumberShouldMatch(minMustMatch);
        }
        if (this.highFreqOccur == BooleanClause.Occur.SHOULD && numHighFreqClauses > 0) {
            minMustMatch = this.calcHighFreqMinimumNumberShouldMatch(numHighFreqClauses);
            highFreq.setMinimumNumberShouldMatch(minMustMatch);
        }
        if (lowFreq.clauses().isEmpty()) {
            if (highFreq.getMinimumNumberShouldMatch() == 0 && this.highFreqOccur != BooleanClause.Occur.MUST) {
                for (BooleanClause booleanClause : highFreq) {
                    booleanClause.setOccur(BooleanClause.Occur.MUST);
                }
            }
            highFreq.setBoost(this.getBoost());
            return highFreq;
        }
        if (highFreq.clauses().isEmpty()) {
            lowFreq.setBoost(this.getBoost());
            return lowFreq;
        }
        query.add((Query)highFreq, BooleanClause.Occur.SHOULD);
        query.add((Query)lowFreq, BooleanClause.Occur.MUST);
        query.setBoost(this.getBoost());
        return query;
    }

    protected Query newTermQuery(Term term, TermContext context) {
        if (this.mapper == null) {
            return context == null ? new TermQuery(term) : new TermQuery(term, context);
        }
        Query query = this.mapper.queryStringTermQuery(term);
        if (query == null) {
            return context == null ? new TermQuery(term) : new TermQuery(term, context);
        }
        return query;
    }

    static {
        boolean bl = $assertionsDisabled = !ExtendedCommonTermsQuery.class.desiredAssertionStatus();
        if (!$assertionsDisabled && !Version.LUCENE_47.onOrAfter(Lucene.VERSION)) {
            throw new AssertionError((Object)"Remove obsolete code after upgrade to lucene 4.8");
        }
    }
}

