/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lease;

import java.util.Arrays;
import org.elasticsearch.common.lease.Releasable;

public enum Releasables {


    private static void rethrow(Throwable t) {
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new RuntimeException(t);
    }

    private static void release(Iterable<? extends Releasable> releasables, boolean ignoreException) {
        Throwable th = null;
        for (Releasable releasable : releasables) {
            if (releasable == null) continue;
            try {
                releasable.release();
            }
            catch (Throwable t) {
                if (th != null) continue;
                th = t;
            }
        }
        if (th != null && !ignoreException) {
            Releasables.rethrow(th);
        }
    }

    public static void release(Iterable<? extends Releasable> releasables) {
        Releasables.release(releasables, false);
    }

    public static void release(Releasable ... releasables) {
        Releasables.release(Arrays.asList(releasables));
    }

    public static void releaseWhileHandlingException(Iterable<Releasable> releasables) {
        Releasables.release(releasables, true);
    }

    public static void releaseWhileHandlingException(Releasable ... releasables) {
        Releasables.releaseWhileHandlingException(Arrays.asList(releasables));
    }

    public static void release(boolean success, Iterable<Releasable> releasables) {
        if (success) {
            Releasables.release(releasables);
        } else {
            Releasables.releaseWhileHandlingException(releasables);
        }
    }

    public static void release(boolean success, Releasable ... releasables) {
        Releasables.release(success, Arrays.asList(releasables));
    }
}

