/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.admin.indices.stats.CommonStats;
import org.elasticsearch.action.admin.indices.stats.IndexShardStats;
import org.elasticsearch.action.admin.indices.stats.ShardStats;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.cache.filter.FilterCacheStats;
import org.elasticsearch.index.cache.id.IdCacheStats;
import org.elasticsearch.index.engine.SegmentsStats;
import org.elasticsearch.index.fielddata.FieldDataStats;
import org.elasticsearch.index.flush.FlushStats;
import org.elasticsearch.index.get.GetStats;
import org.elasticsearch.index.indexing.IndexingStats;
import org.elasticsearch.index.merge.MergeStats;
import org.elasticsearch.index.percolator.stats.PercolateStats;
import org.elasticsearch.index.refresh.RefreshStats;
import org.elasticsearch.index.search.stats.SearchStats;
import org.elasticsearch.index.shard.DocsStats;
import org.elasticsearch.index.store.StoreStats;
import org.elasticsearch.search.suggest.completion.CompletionStats;

public class NodeIndicesStats
implements Streamable,
Serializable,
ToXContent {
    private CommonStats stats;
    private Map<Index, List<IndexShardStats>> statsByShard;

    NodeIndicesStats() {
    }

    public NodeIndicesStats(CommonStats oldStats, Map<Index, List<IndexShardStats>> statsByShard) {
        this.statsByShard = statsByShard;
        this.stats = oldStats;
        for (List<IndexShardStats> shardStatsList : statsByShard.values()) {
            for (IndexShardStats indexShardStats : shardStatsList) {
                for (ShardStats shardStats : indexShardStats.getShards()) {
                    this.stats.add(shardStats.getStats());
                }
            }
        }
    }

    @Nullable
    public StoreStats getStore() {
        return this.stats.getStore();
    }

    @Nullable
    public DocsStats getDocs() {
        return this.stats.getDocs();
    }

    @Nullable
    public IndexingStats getIndexing() {
        return this.stats.getIndexing();
    }

    @Nullable
    public GetStats getGet() {
        return this.stats.getGet();
    }

    @Nullable
    public SearchStats getSearch() {
        return this.stats.getSearch();
    }

    @Nullable
    public PercolateStats getPercolate() {
        return this.stats.getPercolate();
    }

    @Nullable
    public MergeStats getMerge() {
        return this.stats.getMerge();
    }

    @Nullable
    public RefreshStats getRefresh() {
        return this.stats.getRefresh();
    }

    @Nullable
    public FlushStats getFlush() {
        return this.stats.getFlush();
    }

    @Nullable
    public FieldDataStats getFieldData() {
        return this.stats.getFieldData();
    }

    @Nullable
    public FilterCacheStats getFilterCache() {
        return this.stats.getFilterCache();
    }

    @Nullable
    public IdCacheStats getIdCache() {
        return this.stats.getIdCache();
    }

    @Nullable
    public CompletionStats getCompletion() {
        return this.stats.getCompletion();
    }

    @Nullable
    public SegmentsStats getSegments() {
        return this.stats.getSegments();
    }

    public static NodeIndicesStats readIndicesStats(StreamInput in) throws IOException {
        NodeIndicesStats stats = new NodeIndicesStats();
        stats.readFrom(in);
        return stats;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.stats = CommonStats.readCommonStats(in);
        if (in.readBoolean()) {
            int entries = in.readVInt();
            this.statsByShard = Maps.newHashMap();
            for (int i = 0; i < entries; ++i) {
                Index index = Index.readIndexName(in);
                int indexShardListSize = in.readVInt();
                ArrayList<IndexShardStats> indexShardStats = Lists.newArrayListWithCapacity(indexShardListSize);
                for (int j = 0; j < indexShardListSize; ++j) {
                    indexShardStats.add(IndexShardStats.readIndexShardStats(in));
                }
                this.statsByShard.put(index, indexShardStats);
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.stats.writeTo(out);
        out.writeBoolean(this.statsByShard != null);
        if (this.statsByShard != null) {
            out.writeVInt(this.statsByShard.size());
            for (Map.Entry<Index, List<IndexShardStats>> entry : this.statsByShard.entrySet()) {
                entry.getKey().writeTo(out);
                out.writeVInt(entry.getValue().size());
                for (IndexShardStats indexShardStats : entry.getValue()) {
                    indexShardStats.writeTo(out);
                }
            }
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean isLevelValid;
        String level = params.param("level", "node");
        boolean bl = isLevelValid = "node".equalsIgnoreCase(level) || "indices".equalsIgnoreCase(level) || "shards".equalsIgnoreCase(level);
        if (!isLevelValid) {
            return builder;
        }
        builder.startObject(Fields.INDICES);
        this.stats.toXContent(builder, params);
        if ("indices".equals(level)) {
            Map<Index, CommonStats> indexStats = this.createStatsByIndex();
            builder.startObject(Fields.INDICES);
            for (Map.Entry<Index, CommonStats> entry : indexStats.entrySet()) {
                builder.startObject(entry.getKey().name());
                entry.getValue().toXContent(builder, params);
                builder.endObject();
            }
            builder.endObject();
        } else if ("shards".equals(level)) {
            builder.startObject("shards");
            for (Map.Entry<Index, List<IndexShardStats>> entry : this.statsByShard.entrySet()) {
                builder.startArray(entry.getKey().name());
                for (IndexShardStats indexShardStats : entry.getValue()) {
                    builder.startObject().startObject(String.valueOf(indexShardStats.getShardId().getId()));
                    for (ShardStats shardStats : indexShardStats.getShards()) {
                        shardStats.toXContent(builder, params);
                    }
                    builder.endObject().endObject();
                }
                builder.endArray();
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    private Map<Index, CommonStats> createStatsByIndex() {
        HashMap<Index, CommonStats> statsMap = Maps.newHashMap();
        for (Map.Entry<Index, List<IndexShardStats>> entry : this.statsByShard.entrySet()) {
            if (!statsMap.containsKey(entry.getKey())) {
                statsMap.put(entry.getKey(), new CommonStats());
            }
            for (IndexShardStats indexShardStats : entry.getValue()) {
                for (ShardStats shardStats : indexShardStats.getShards()) {
                    ((CommonStats)statsMap.get(entry.getKey())).add(shardStats.getStats());
                }
            }
        }
        return statsMap;
    }

    static final class Fields {
        static final XContentBuilderString INDICES = new XContentBuilderString("indices");

        Fields() {
        }
    }
}

