/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.master;

import java.io.IOException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;

public abstract class MasterNodeOperationRequest<T extends MasterNodeOperationRequest>
extends ActionRequest<T> {
    public static TimeValue DEFAULT_MASTER_NODE_TIMEOUT = TimeValue.timeValueSeconds(30L);
    protected TimeValue masterNodeTimeout = DEFAULT_MASTER_NODE_TIMEOUT;

    public final T masterNodeTimeout(TimeValue timeout) {
        this.masterNodeTimeout = timeout;
        return (T)this;
    }

    public final T masterNodeTimeout(String timeout) {
        return this.masterNodeTimeout(TimeValue.parseTimeValue(timeout, null));
    }

    public final TimeValue masterNodeTimeout() {
        return this.masterNodeTimeout;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.masterNodeTimeout = TimeValue.readTimeValue(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.masterNodeTimeout.writeTo(out);
    }
}

