/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.cat;

import java.io.IOException;
import java.util.Set;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.StringRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.cat.AbstractCatAction;

public class RestCatAction
extends BaseRestHandler {
    private static final String CAT = "=^.^=";
    private static final String CAT_NL = "=^.^=\n";
    private final String HELP;

    @Inject
    public RestCatAction(Settings settings, Client client, RestController controller, Set<AbstractCatAction> catActions) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.GET, "/_cat", this);
        StringBuilder sb = new StringBuilder();
        sb.append(CAT_NL);
        for (AbstractCatAction catAction : catActions) {
            catAction.documentation(sb);
        }
        this.HELP = sb.toString();
    }

    @Override
    public void handleRequest(RestRequest request, RestChannel channel) {
        try {
            channel.sendResponse(new StringRestResponse(RestStatus.OK, this.HELP));
        }
        catch (Throwable t) {
            try {
                channel.sendResponse(new XContentThrowableRestResponse(request, t));
            }
            catch (IOException e1) {
                this.logger.error("Failed to send failure response", e1, new Object[0]);
            }
        }
    }
}

