/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.partial;

import java.util.ArrayList;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.fetch.partial.PartialFieldsContext;
import org.elasticsearch.search.internal.SearchContext;

public class PartialFieldsParseElement
implements SearchParseElement {
    @Override
    public void parse(XContentParser parser, SearchContext context) throws Exception {
        XContentParser.Token token;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token != XContentParser.Token.START_OBJECT) continue;
            String fieldName = currentFieldName;
            ArrayList<String> includes = null;
            ArrayList<String> excludes = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    if ("includes".equals(currentFieldName) || "include".equals(currentFieldName)) {
                        if (includes == null) {
                            includes = new ArrayList<String>(2);
                        }
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            includes.add(parser.text());
                        }
                        continue;
                    }
                    if (!"excludes".equals(currentFieldName) && !"exclude".equals(currentFieldName)) continue;
                    if (excludes == null) {
                        excludes = new ArrayList(2);
                    }
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        excludes.add(parser.text());
                    }
                    continue;
                }
                if (!token.isValue()) continue;
                if ("include".equals(currentFieldName)) {
                    if (includes == null) {
                        includes = new ArrayList(2);
                    }
                    includes.add(parser.text());
                    continue;
                }
                if (!"exclude".equals(currentFieldName)) continue;
                if (excludes == null) {
                    excludes = new ArrayList<String>(2);
                }
                excludes.add(parser.text());
            }
            PartialFieldsContext.PartialField field = new PartialFieldsContext.PartialField(fieldName, includes == null ? Strings.EMPTY_ARRAY : includes.toArray(new String[includes.size()]), excludes == null ? Strings.EMPTY_ARRAY : excludes.toArray(new String[excludes.size()]));
            context.partialFields().add(field);
        }
    }
}

