/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.test;

import com.google.inject.Binder;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import java.io.File;
import java.security.InvalidParameterException;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.RuntimeFeature;
import org.nuxeo.runtime.test.runner.SimpleFeature;

@Features(value={RuntimeFeature.class})
public class BareElasticSearchFeature
extends SimpleFeature {
    protected Client client;
    protected Node node;

    public void start(FeaturesRunner runner) throws Exception {
        File home = Framework.getRuntime().getHome();
        File esDirectory = new File(home, "elasticsearch");
        if (!esDirectory.exists() && !esDirectory.mkdir()) {
            throw new InvalidParameterException("Can not create directory: " + esDirectory.getAbsolutePath());
        }
        Settings settings = ImmutableSettings.settingsBuilder().put("node.http.enabled", true).put("path.logs", esDirectory.getPath() + "/logs").put("path.data", esDirectory.getPath() + "/data").put("gateway.type", "none").put("index.store.type", "memory").put("index.number_of_shards", 1).put("index.number_of_replicas", 1).build();
        this.node = NodeBuilder.nodeBuilder().local(true).settings(settings).node();
        this.client = this.node.client();
        super.start(runner);
    }

    public void configure(FeaturesRunner runner, Binder binder) {
        super.configure(runner, binder);
        binder.bind(Node.class).toProvider((Provider)new Provider<Node>(){

            public Node get() {
                return BareElasticSearchFeature.this.node;
            }
        }).in(Scopes.SINGLETON);
        binder.bind(Client.class).toProvider((Provider)new Provider<Client>(){

            public Client get() {
                return BareElasticSearchFeature.this.client;
            }
        }).in(Scopes.SINGLETON);
    }

    public void afterRun(FeaturesRunner runner) throws Exception {
        super.afterRun(runner);
        this.node.close();
    }
}

