/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.phrase;

import java.io.IOException;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.FilterAtomicReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.hppc.ObjectObjectMap;
import org.elasticsearch.common.hppc.ObjectObjectOpenHashMap;
import org.elasticsearch.search.suggest.phrase.DirectCandidateGenerator;

public abstract class WordScorer {
    protected final IndexReader reader;
    protected final String field;
    protected final Terms terms;
    protected final long vocabluarySize;
    protected final double realWordLikelyhood;
    protected final BytesRef spare = new BytesRef();
    protected final BytesRef separator;
    protected final TermsEnum termsEnum;
    private final long numTerms;
    private final boolean useTotalTermFreq;

    public WordScorer(IndexReader reader, String field, double realWordLikelyHood, BytesRef separator) throws IOException {
        this(reader, MultiFields.getTerms((IndexReader)reader, (String)field), field, realWordLikelyHood, separator);
    }

    public WordScorer(IndexReader reader, Terms terms, String field, double realWordLikelyHood, BytesRef separator) throws IOException {
        this.field = field;
        if (terms == null) {
            throw new ElasticsearchIllegalArgumentException("Field: [" + field + "] does not exist");
        }
        this.terms = terms;
        long vocSize = terms.getSumTotalTermFreq();
        this.vocabluarySize = vocSize == -1L ? (long)reader.maxDoc() : vocSize;
        this.useTotalTermFreq = vocSize != -1L;
        this.numTerms = terms.size();
        this.termsEnum = new FrequencyCachingTermsEnumWrapper(terms.iterator(null));
        this.reader = reader;
        this.realWordLikelyhood = realWordLikelyHood;
        this.separator = separator;
    }

    public long frequency(BytesRef term) throws IOException {
        if (this.termsEnum.seekExact(term)) {
            return this.useTotalTermFreq ? this.termsEnum.totalTermFreq() : (long)this.termsEnum.docFreq();
        }
        return 0L;
    }

    protected double channelScore(DirectCandidateGenerator.Candidate candidate, DirectCandidateGenerator.Candidate original) throws IOException {
        if (candidate.stringDistance == 1.0) {
            return this.realWordLikelyhood;
        }
        return candidate.stringDistance;
    }

    public double score(DirectCandidateGenerator.Candidate[] path, DirectCandidateGenerator.CandidateSet[] candidateSet, int at, int gramSize) throws IOException {
        if (at == 0 || gramSize == 1) {
            return Math.log10(this.channelScore(path[at], candidateSet[at].originalTerm) * this.scoreUnigram(path[at]));
        }
        if (at == 1 || gramSize == 2) {
            return Math.log10(this.channelScore(path[at], candidateSet[at].originalTerm) * this.scoreBigram(path[at], path[at - 1]));
        }
        return Math.log10(this.channelScore(path[at], candidateSet[at].originalTerm) * this.scoreTrigram(path[at], path[at - 1], path[at - 2]));
    }

    protected double scoreUnigram(DirectCandidateGenerator.Candidate word) throws IOException {
        return (1.0 + (double)this.frequency(word.term)) / (double)(this.vocabluarySize + this.numTerms);
    }

    protected double scoreBigram(DirectCandidateGenerator.Candidate word, DirectCandidateGenerator.Candidate w_1) throws IOException {
        return this.scoreUnigram(word);
    }

    protected double scoreTrigram(DirectCandidateGenerator.Candidate word, DirectCandidateGenerator.Candidate w_1, DirectCandidateGenerator.Candidate w_2) throws IOException {
        return this.scoreBigram(word, w_1);
    }

    private static class FrequencyCachingTermsEnumWrapper
    extends FilterAtomicReader.FilterTermsEnum {
        private ObjectObjectMap<BytesRef, CacheEntry> cache = new ObjectObjectOpenHashMap<BytesRef, CacheEntry>();
        private CacheEntry last;

        public FrequencyCachingTermsEnumWrapper(TermsEnum in) {
            super(in);
        }

        public boolean seekExact(BytesRef text) throws IOException {
            this.last = this.cache.get(text);
            if (this.last != null) {
                return this.last.ttf != 0L || this.last.df != 0;
            }
            this.last = new CacheEntry();
            this.cache.put(BytesRef.deepCopyOf((BytesRef)text), this.last);
            if (this.in.seekExact(text)) {
                this.last.df = -1;
                this.last.ttf = -1L;
                return true;
            }
            return false;
        }

        public long totalTermFreq() throws IOException {
            if (this.last.ttf == -1L) {
                this.last.ttf = this.in.totalTermFreq();
            }
            return this.last.ttf;
        }

        public int docFreq() throws IOException {
            if (this.last.df == -1) {
                this.last.df = this.in.docFreq();
            }
            return this.last.df;
        }

        public void seekExact(long ord) throws IOException {
            throw new UnsupportedOperationException();
        }

        public DocsEnum docs(Bits liveDocs, DocsEnum reuse, int flags) throws IOException {
            throw new UnsupportedOperationException();
        }

        public DocsAndPositionsEnum docsAndPositions(Bits liveDocs, DocsAndPositionsEnum reuse, int flags) throws IOException {
            throw new UnsupportedOperationException();
        }

        public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
            throw new UnsupportedOperationException();
        }

        public BytesRef next() {
            throw new UnsupportedOperationException();
        }

        private static class CacheEntry {
            private long ttf;
            private int df;

            private CacheEntry() {
            }
        }
    }

    public static interface WordScorerFactory {
        public WordScorer newScorer(IndexReader var1, Terms var2, String var3, double var4, BytesRef var6) throws IOException;
    }
}

