/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.percolate;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.percolate.PercolateRequest;
import org.elasticsearch.action.percolate.PercolateRequestBuilder;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;

public class MultiPercolateRequest
extends ActionRequest<MultiPercolateRequest> {
    private String[] indices;
    private String documentType;
    private IndicesOptions indicesOptions = IndicesOptions.strict();
    private List<PercolateRequest> requests = Lists.newArrayList();

    public MultiPercolateRequest add(PercolateRequestBuilder requestBuilder) {
        return this.add(requestBuilder.request());
    }

    public MultiPercolateRequest add(PercolateRequest request) {
        if (request.indices() == null && this.indices != null) {
            request.indices(this.indices);
        }
        if (request.documentType() == null && this.documentType != null) {
            request.documentType(this.documentType);
        }
        if (request.indicesOptions() == IndicesOptions.strict() && this.indicesOptions != IndicesOptions.strict()) {
            request.indicesOptions(this.indicesOptions);
        }
        this.requests.add(request);
        return this;
    }

    public MultiPercolateRequest add(byte[] data, int from, int length, boolean contentUnsafe) throws Exception {
        return this.add(new BytesArray(data, from, length), contentUnsafe, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiPercolateRequest add(BytesReference data, boolean contentUnsafe, boolean allowExplicitIndex) throws Exception {
        int nextMarker;
        XContent xContent = XContentFactory.xContent(data);
        int from = 0;
        int length = data.length();
        byte marker = xContent.streamSeparator();
        while ((nextMarker = this.findNextMarker(marker, from, data, length)) != -1) {
            PercolateRequest percolateRequest;
            block14: {
                if (nextMarker == 0) {
                    from = nextMarker + 1;
                    continue;
                }
                percolateRequest = new PercolateRequest();
                if (this.indices != null) {
                    percolateRequest.indices(this.indices);
                }
                if (this.documentType != null) {
                    percolateRequest.documentType(this.documentType);
                }
                if (this.indicesOptions != IndicesOptions.strict()) {
                    percolateRequest.indicesOptions(this.indicesOptions);
                }
                if (nextMarker - from > 0) {
                    XContentParser parser = xContent.createParser(data.slice(from, nextMarker - from));
                    try {
                        XContentParser.Token token = parser.nextToken();
                        if (token == null) break block14;
                        assert (token == XContentParser.Token.START_OBJECT);
                        token = parser.nextToken();
                        if (token != XContentParser.Token.FIELD_NAME) {
                            throw new ElasticsearchParseException("Expected field");
                        }
                        token = parser.nextToken();
                        if (token != XContentParser.Token.START_OBJECT) {
                            throw new ElasticsearchParseException("expected start object");
                        }
                        String percolateAction = parser.currentName();
                        if ("percolate".equals(percolateAction)) {
                            this.parsePercolateAction(parser, percolateRequest, allowExplicitIndex);
                            break block14;
                        }
                        if ("count".equals(percolateAction)) {
                            percolateRequest.onlyCount(true);
                            this.parsePercolateAction(parser, percolateRequest, allowExplicitIndex);
                            break block14;
                        }
                        throw new ElasticsearchParseException(percolateAction + " isn't a supported percolate operation");
                    }
                    finally {
                        parser.close();
                    }
                }
            }
            if ((nextMarker = this.findNextMarker(marker, from = nextMarker + 1, data, length)) == -1) break;
            percolateRequest.source(data.slice(from, nextMarker - from), contentUnsafe);
            from = nextMarker + 1;
            this.add(percolateRequest);
        }
        return this;
    }

    private void parsePercolateAction(XContentParser parser, PercolateRequest percolateRequest, boolean allowExplicitIndex) throws IOException {
        XContentParser.Token token;
        String globalIndex = this.indices != null && this.indices.length > 0 ? this.indices[0] : null;
        HashMap<String, Object> header = new HashMap<String, Object>();
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                header.put(currentFieldName, parser.text());
                continue;
            }
            if (token != XContentParser.Token.START_ARRAY) continue;
            header.put(currentFieldName, this.parseArray(parser));
        }
        boolean ignoreUnavailable = IndicesOptions.strict().ignoreUnavailable();
        boolean allowNoIndices = IndicesOptions.strict().allowNoIndices();
        boolean expandWildcardsOpen = IndicesOptions.strict().expandWildcardsOpen();
        boolean expandWildcardsClosed = IndicesOptions.strict().expandWildcardsClosed();
        if (header.containsKey("id")) {
            GetRequest getRequest = new GetRequest(globalIndex);
            percolateRequest.getRequest(getRequest);
            for (Map.Entry entry : header.entrySet()) {
                Object value = entry.getValue();
                if ("id".equals(entry.getKey())) {
                    getRequest.id((String)value);
                    header.put("id", entry.getValue());
                    continue;
                }
                if ("index".equals(entry.getKey()) || "indices".equals(entry.getKey())) {
                    if (!allowExplicitIndex) {
                        throw new ElasticsearchIllegalArgumentException("explicit index in multi percolate is not allowed");
                    }
                    getRequest.index((String)value);
                    continue;
                }
                if ("type".equals(entry.getKey())) {
                    getRequest.type((String)value);
                    continue;
                }
                if ("preference".equals(entry.getKey())) {
                    getRequest.preference((String)value);
                    continue;
                }
                if ("routing".equals(entry.getKey())) {
                    getRequest.routing((String)value);
                    continue;
                }
                if ("percolate_index".equals(entry.getKey()) || "percolate_indices".equals(entry.getKey()) || "percolateIndex".equals(entry.getKey()) || "percolateIndices".equals(entry.getKey())) {
                    if (value instanceof String[]) {
                        percolateRequest.indices((String[])value);
                        continue;
                    }
                    percolateRequest.indices(Strings.splitStringByCommaToArray((String)value));
                    continue;
                }
                if ("percolate_type".equals(entry.getKey()) || "percolateType".equals(entry.getKey())) {
                    percolateRequest.documentType((String)value);
                    continue;
                }
                if ("percolate_preference".equals(entry.getKey()) || "percolatePreference".equals(entry.getKey())) {
                    percolateRequest.preference((String)value);
                    continue;
                }
                if ("percolate_routing".equals(entry.getKey()) || "percolateRouting".equals(entry.getKey())) {
                    percolateRequest.routing((String)value);
                    continue;
                }
                if ("ignore_unavailable".equals(currentFieldName) || "ignoreUnavailable".equals(currentFieldName)) {
                    ignoreUnavailable = Boolean.valueOf((String)value);
                    continue;
                }
                if ("allow_no_indices".equals(currentFieldName) || "allowNoIndices".equals(currentFieldName)) {
                    allowNoIndices = Boolean.valueOf((String)value);
                    continue;
                }
                if (!"expand_wildcards".equals(currentFieldName) && !"expandWildcards".equals(currentFieldName)) continue;
                String[] wildcards = value instanceof String[] ? (String[])value : Strings.splitStringByCommaToArray((String)value);
                for (String wildcard : wildcards) {
                    if ("open".equals(wildcard)) {
                        expandWildcardsOpen = true;
                        continue;
                    }
                    if ("closed".equals(wildcard)) {
                        expandWildcardsClosed = true;
                        continue;
                    }
                    throw new ElasticsearchIllegalArgumentException("No valid expand wildcard value [" + wildcard + "]");
                }
            }
            if ((percolateRequest.indices() == null || percolateRequest.indices().length == 0) && getRequest.index() != null) {
                percolateRequest.indices(getRequest.index());
            }
            if (percolateRequest.documentType() == null && getRequest.type() != null) {
                percolateRequest.documentType(getRequest.type());
            }
            if (percolateRequest.routing() == null && getRequest.routing() != null) {
                percolateRequest.routing(getRequest.routing());
            }
            if (percolateRequest.preference() == null && getRequest.preference() != null) {
                percolateRequest.preference(getRequest.preference());
            }
        } else {
            for (Map.Entry entry : header.entrySet()) {
                Object value = entry.getValue();
                if ("index".equals(entry.getKey()) || "indices".equals(entry.getKey())) {
                    if (!allowExplicitIndex) {
                        throw new ElasticsearchIllegalArgumentException("explicit index in multi percolate is not allowed");
                    }
                    if (value instanceof String[]) {
                        percolateRequest.indices((String[])value);
                        continue;
                    }
                    percolateRequest.indices(Strings.splitStringByCommaToArray((String)value));
                    continue;
                }
                if ("type".equals(entry.getKey())) {
                    percolateRequest.documentType((String)value);
                    continue;
                }
                if ("preference".equals(entry.getKey())) {
                    percolateRequest.preference((String)value);
                    continue;
                }
                if ("routing".equals(entry.getKey())) {
                    percolateRequest.routing((String)value);
                    continue;
                }
                if ("ignore_unavailable".equals(currentFieldName) || "ignoreUnavailable".equals(currentFieldName)) {
                    ignoreUnavailable = Boolean.valueOf((String)value);
                    continue;
                }
                if ("allow_no_indices".equals(currentFieldName) || "allowNoIndices".equals(currentFieldName)) {
                    allowNoIndices = Boolean.valueOf((String)value);
                    continue;
                }
                if (!"expand_wildcards".equals(currentFieldName) && !"expandWildcards".equals(currentFieldName)) continue;
                String[] wildcards = value instanceof String[] ? (String[])value : Strings.splitStringByCommaToArray((String)value);
                for (String wildcard : wildcards) {
                    if ("open".equals(wildcard)) {
                        expandWildcardsOpen = true;
                        continue;
                    }
                    if ("closed".equals(wildcard)) {
                        expandWildcardsClosed = true;
                        continue;
                    }
                    throw new ElasticsearchIllegalArgumentException("No valid expand wildcard value [" + wildcard + "]");
                }
            }
        }
        percolateRequest.indicesOptions(IndicesOptions.fromOptions(ignoreUnavailable, allowNoIndices, expandWildcardsOpen, expandWildcardsClosed));
    }

    private String[] parseArray(XContentParser parser) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        assert (parser.currentToken() == XContentParser.Token.START_ARRAY);
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            list.add(parser.text());
        }
        return list.toArray(new String[list.size()]);
    }

    private int findNextMarker(byte marker, int from, BytesReference data, int length) {
        for (int i = from; i < length; ++i) {
            if (data.get(i) != marker) continue;
            return i;
        }
        return -1;
    }

    public List<PercolateRequest> requests() {
        return this.requests;
    }

    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public MultiPercolateRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    public String[] indices() {
        return this.indices;
    }

    public MultiPercolateRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    public String documentType() {
        return this.documentType;
    }

    public MultiPercolateRequest documentType(String type) {
        this.documentType = type;
        return this;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.requests.isEmpty()) {
            validationException = ValidateActions.addValidationError("no requests added", validationException);
        }
        for (int i = 0; i < this.requests.size(); ++i) {
            ActionRequestValidationException ex = this.requests.get(i).validate();
            if (ex == null) continue;
            if (validationException == null) {
                validationException = new ActionRequestValidationException();
            }
            validationException.addValidationErrors(ex.validationErrors());
        }
        return validationException;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.indices = in.readStringArray();
        this.documentType = in.readOptionalString();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            PercolateRequest request = new PercolateRequest();
            request.readFrom(in);
            this.requests.add(request);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArrayNullable(this.indices);
        out.writeOptionalString(this.documentType);
        this.indicesOptions.writeIndicesOptions(out);
        out.writeVInt(this.requests.size());
        for (PercolateRequest request : this.requests) {
            request.writeTo(out);
        }
    }
}

