/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.percentiles;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.common.collect.UnmodifiableIterator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.MetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.percentiles.Percentiles;
import org.elasticsearch.search.aggregations.metrics.percentiles.PercentilesEstimator;
import org.elasticsearch.search.aggregations.support.numeric.ValueFormatterStreams;

public class InternalPercentiles
extends MetricsAggregation.MultiValue
implements Percentiles {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("percentiles");
    public static final AggregationStreams.Stream STREAM = new AggregationStreams.Stream(){

        @Override
        public InternalPercentiles readResult(StreamInput in) throws IOException {
            InternalPercentiles result = new InternalPercentiles();
            result.readFrom(in);
            return result;
        }
    };
    private PercentilesEstimator.Result result;
    private boolean keyed;

    public static void registerStreams() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
    }

    InternalPercentiles() {
    }

    public InternalPercentiles(String name, PercentilesEstimator.Result result, boolean keyed) {
        super(name);
        this.result = result;
        this.keyed = keyed;
    }

    @Override
    public double value(String name) {
        return this.result.estimate(Double.valueOf(name));
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    @Override
    public double percentile(double percent) {
        return this.result.estimate(percent);
    }

    @Override
    public Iterator<Percentiles.Percentile> iterator() {
        return new Iter(this.result);
    }

    @Override
    public InternalPercentiles reduce(InternalAggregation.ReduceContext reduceContext) {
        List<InternalAggregation> aggregations = reduceContext.aggregations();
        InternalPercentiles first = (InternalPercentiles)aggregations.get(0);
        if (aggregations.size() == 1) {
            return first;
        }
        PercentilesEstimator.Result.Merger merger = first.result.merger(aggregations.size());
        for (InternalAggregation aggregation : aggregations) {
            merger.add(((InternalPercentiles)aggregation).result);
        }
        first.result = merger.merge();
        return first;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readString();
        this.valueFormatter = ValueFormatterStreams.readOptional(in);
        this.result = PercentilesEstimator.Streams.read(in);
        this.keyed = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        ValueFormatterStreams.writeOptional(this.valueFormatter, out);
        PercentilesEstimator.Streams.write(this.result, out);
        out.writeBoolean(this.keyed);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        double[] percents = this.result.percents;
        if (this.keyed) {
            builder.startObject(this.name);
            for (int i = 0; i < percents.length; ++i) {
                String key = String.valueOf(percents[i]);
                double value = this.result.estimate(i);
                builder.field(key, value);
                if (this.valueFormatter == null) continue;
                builder.field(key + "_as_string", this.valueFormatter.format(value));
            }
            builder.endObject();
        } else {
            builder.startArray(this.name);
            for (int i = 0; i < percents.length; ++i) {
                double value = this.result.estimate(i);
                builder.startObject();
                builder.field(InternalAggregation.CommonFields.KEY, percents[i]);
                builder.field(InternalAggregation.CommonFields.VALUE, value);
                if (this.valueFormatter != null) {
                    builder.field(InternalAggregation.CommonFields.VALUE_AS_STRING, this.valueFormatter.format(value));
                }
                builder.endObject();
            }
            builder.endArray();
        }
        return builder;
    }

    private static class InnerPercentile
    implements Percentiles.Percentile {
        private final double percent;
        private final double value;

        private InnerPercentile(double percent, double value) {
            this.percent = percent;
            this.value = value;
        }

        @Override
        public double getPercent() {
            return this.percent;
        }

        @Override
        public double getValue() {
            return this.value;
        }
    }

    public static class Iter
    extends UnmodifiableIterator<Percentiles.Percentile> {
        private final PercentilesEstimator.Result result;
        private int i;

        public Iter(PercentilesEstimator.Result estimator) {
            this.result = estimator;
            this.i = 0;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.result.percents.length;
        }

        @Override
        public Percentiles.Percentile next() {
            InnerPercentile next = new InnerPercentile(this.result.percents[this.i], this.result.estimate(this.i));
            ++this.i;
            return next;
        }
    }
}

