/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.transaction.Synchronization;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.elasticsearch.commands.IndexingCommand;
import org.nuxeo.elasticsearch.commands.IndexingCommands;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public abstract class IndexingCommandsStacker {
    protected static final Log log = LogFactory.getLog(IndexingCommandsStacker.class);

    protected abstract Map<String, IndexingCommands> getAllCommands();

    protected IndexingCommands getCommands(DocumentModel doc) {
        return this.getAllCommands().get(this.getDocKey(doc));
    }

    protected String getDocKey(DocumentModel doc) {
        return doc.getId() + "#" + doc.getSessionId();
    }

    protected IndexingCommands getOrCreateCommands(DocumentModel doc) {
        IndexingCommands cmds = this.getCommands(doc);
        if (cmds == null) {
            cmds = new IndexingCommands(doc);
            this.getAllCommands().put(this.getDocKey(doc), cmds);
        }
        return cmds;
    }

    protected void stackCommand(DocumentModel doc, String eventId, boolean sync) {
        if (doc == null) {
            return;
        }
        IndexingCommands cmds = this.getOrCreateCommands(doc);
        if ("documentCreated".equals(eventId)) {
            cmds.add("ES_INSERT", sync, false);
        } else if ("beforeDocumentModification".equals(eventId)) {
            cmds.add("ES_UPDATE", sync, false);
        } else if ("documentCheckedOut".equals(eventId)) {
            cmds.add("ES_UPDATE", sync, false);
        } else if ("documentCheckedIn".equals(eventId)) {
            cmds.add("ES_UPDATE", sync, false);
        } else if ("documentCreatedByCopy".equals(eventId)) {
            cmds.add("ES_INSERT", sync, doc.isFolder());
        } else if ("lifecycle_transition_event".equals(eventId)) {
            cmds.add("ES_INSERT", sync, false);
        } else if ("documentMoved".equals(eventId)) {
            cmds.add("ES_UPDATE", sync, doc.isFolder());
        } else if ("documentSecurityUpdated".equals(eventId)) {
            cmds.add("ES_UPDATE_SECURITY", sync, doc.isFolder());
        } else if ("documentRemoved".equals(eventId)) {
            cmds.add("ES_DELETE", sync, doc.isFolder());
        } else if ("binaryTextUpdated".equals(eventId)) {
            cmds.add("ES_UPDATE", sync, false);
        }
    }

    protected boolean registerSynchronization(Synchronization sync) {
        try {
            TransactionManager tm = TransactionHelper.lookupTransactionManager();
            if (tm != null) {
                if (tm.getTransaction() != null) {
                    tm.getTransaction().registerSynchronization(sync);
                    return true;
                }
                if (!Framework.isTestModeSet()) {
                    log.error((Object)"Unable to register synchronization : no active transaction");
                }
                return false;
            }
            log.error((Object)"Unable to register synchronization : no TransactionManager");
            return false;
        }
        catch (Exception e) {
            log.error((Object)"Unable to register synchronization", (Throwable)e);
            return false;
        }
    }

    protected void prepareFlush() {
        Map<String, IndexingCommands> allCmds = this.getAllCommands();
        for (IndexingCommands cmds : allCmds.values()) {
            for (IndexingCommand cmd : cmds.getCommands()) {
                if (!cmd.isSync()) continue;
                cmd.computeIndexingEvent();
            }
        }
    }

    protected void flushCommands() throws ClientException {
        Map<String, IndexingCommands> allCmds = this.getAllCommands();
        ArrayList<IndexingCommand> syncCommands = new ArrayList<IndexingCommand>();
        ArrayList<IndexingCommand> asyncCommands = new ArrayList<IndexingCommand>();
        for (IndexingCommands cmds : allCmds.values()) {
            for (IndexingCommand cmd : cmds.getCommands()) {
                if (cmd.isSync()) {
                    syncCommands.add(cmd);
                    continue;
                }
                asyncCommands.add(cmd);
            }
        }
        this.getAllCommands().clear();
        if (syncCommands.size() > 0) {
            this.fireSyncIndexing(syncCommands);
        }
        if (asyncCommands.size() > 0) {
            this.fireAsyncIndexing(asyncCommands);
        }
    }

    protected abstract void fireSyncIndexing(List<IndexingCommand> var1) throws ClientException;

    protected abstract void fireAsyncIndexing(List<IndexingCommand> var1) throws ClientException;
}

