/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.mustache;

import java.io.IOException;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.util.Map;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.FastStringReader;
import org.elasticsearch.common.io.UTF8StreamWriter;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.mustache.Mustache;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.ScriptEngineService;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.script.mustache.JsonEscapingMustacheFactory;
import org.elasticsearch.search.lookup.SearchLookup;

public class MustacheScriptEngineService
extends AbstractComponent
implements ScriptEngineService {
    private static ThreadLocal<SoftReference<UTF8StreamWriter>> utf8StreamWriter = new ThreadLocal();

    private static UTF8StreamWriter utf8StreamWriter() {
        UTF8StreamWriter writer;
        SoftReference<UTF8StreamWriter> ref = utf8StreamWriter.get();
        UTF8StreamWriter uTF8StreamWriter = writer = ref == null ? null : ref.get();
        if (writer == null) {
            writer = new UTF8StreamWriter(4096);
            utf8StreamWriter.set(new SoftReference<UTF8StreamWriter>(writer));
        }
        writer.reset();
        return writer;
    }

    @Inject
    public MustacheScriptEngineService(Settings settings) {
        super(settings);
    }

    @Override
    public Object compile(String template) {
        return new JsonEscapingMustacheFactory().compile(new FastStringReader(template), "query-template");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(Object template, Map<String, Object> vars) {
        BytesStreamOutput result = new BytesStreamOutput();
        UTF8StreamWriter writer = MustacheScriptEngineService.utf8StreamWriter().setOutput(result);
        ((Mustache)template).execute((Writer)writer, vars);
        try {
            writer.flush();
        }
        catch (IOException e) {
            this.logger.error("Could not execute query template (failed to flush writer): ", e, new Object[0]);
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException e) {
                this.logger.error("Could not execute query template (failed to close writer): ", e, new Object[0]);
            }
        }
        return result.bytes();
    }

    @Override
    public String[] types() {
        return new String[]{"mustache"};
    }

    @Override
    public String[] extensions() {
        return new String[]{"mustache"};
    }

    @Override
    public ExecutableScript executable(Object mustache, @Nullable Map<String, Object> vars) {
        return new MustacheExecutableScript((Mustache)mustache, vars);
    }

    @Override
    public SearchScript search(Object compiledScript, SearchLookup lookup, @Nullable Map<String, Object> vars) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object unwrap(Object value) {
        return value;
    }

    @Override
    public void close() {
    }

    private class MustacheExecutableScript
    implements ExecutableScript {
        private Mustache mustache;
        private Map<String, Object> vars;

        public MustacheExecutableScript(Mustache mustache, Map<String, Object> vars) {
            this.mustache = mustache;
            this.vars = vars;
        }

        @Override
        public void setNextVar(String name, Object value) {
            this.vars.put(name, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object run() {
            BytesStreamOutput result = new BytesStreamOutput();
            UTF8StreamWriter writer = MustacheScriptEngineService.utf8StreamWriter().setOutput(result);
            this.mustache.execute((Writer)writer, this.vars);
            try {
                writer.flush();
            }
            catch (IOException e) {
                MustacheScriptEngineService.this.logger.error("Could not execute query template (failed to flush writer): ", e, new Object[0]);
            }
            finally {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    MustacheScriptEngineService.this.logger.error("Could not execute query template (failed to close writer): ", e, new Object[0]);
                }
            }
            return result.bytes();
        }

        @Override
        public Object unwrap(Object value) {
            return value;
        }
    }
}

