/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.SegmentReader;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.lucene.SegmentReaderUtils;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.DirectoryUtils;
import org.elasticsearch.index.store.Store;

public class ShardUtils {
    @Nullable
    public static ShardId extractShardId(AtomicReader reader) {
        return ShardUtils.extractShardId(SegmentReaderUtils.segmentReaderOrNull(reader));
    }

    @Nullable
    private static ShardId extractShardId(SegmentReader reader) {
        if (reader != null) {
            assert (reader.getRefCount() > 0) : "SegmentReader is already closed";
            Store.StoreDirectory storeDir = DirectoryUtils.getStoreDirectory(reader.directory());
            if (storeDir != null) {
                return storeDir.shardId();
            }
        }
        return null;
    }
}

