/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.lucene.store.IndexOutput;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.InternalIndexShard;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.indices.recovery.RecoveryState;

public class RecoveryStatus {
    final ShardId shardId;
    final long recoveryId;
    final InternalIndexShard indexShard;
    final RecoveryState recoveryState;
    volatile Thread recoveryThread;
    private volatile boolean canceled;
    volatile boolean sentCanceledToSource;
    private volatile ConcurrentMap<String, IndexOutput> openIndexOutputs = ConcurrentCollections.newConcurrentMap();
    ConcurrentMap<String, String> checksums = ConcurrentCollections.newConcurrentMap();

    public RecoveryStatus(long recoveryId, InternalIndexShard indexShard) {
        this.recoveryId = recoveryId;
        this.indexShard = indexShard;
        this.shardId = indexShard.shardId();
        this.recoveryState = new RecoveryState(this.shardId);
        this.recoveryState.getTimer().startTime(System.currentTimeMillis());
    }

    public RecoveryState recoveryState() {
        return this.recoveryState;
    }

    public void stage(RecoveryState.Stage stage) {
        this.recoveryState.setStage(stage);
    }

    public RecoveryState.Stage stage() {
        return this.recoveryState.getStage();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public synchronized void cancel() {
        this.canceled = true;
    }

    public IndexOutput getOpenIndexOutput(String key) {
        ConcurrentMap<String, IndexOutput> outputs = this.openIndexOutputs;
        if (this.canceled || outputs == null) {
            return null;
        }
        return (IndexOutput)outputs.get(key);
    }

    public synchronized Set<Map.Entry<String, IndexOutput>> cancleAndClearOpenIndexInputs() {
        this.cancel();
        ConcurrentMap<String, IndexOutput> outputs = this.openIndexOutputs;
        this.openIndexOutputs = null;
        if (outputs == null) {
            return null;
        }
        Set<Map.Entry<String, IndexOutput>> entrySet = outputs.entrySet();
        return entrySet;
    }

    public IndexOutput removeOpenIndexOutputs(String name) {
        ConcurrentMap<String, IndexOutput> outputs = this.openIndexOutputs;
        if (outputs == null) {
            return null;
        }
        return (IndexOutput)outputs.remove(name);
    }

    public synchronized IndexOutput openAndPutIndexOutput(String key, String name, Store store) throws IOException {
        if (this.isCanceled()) {
            return null;
        }
        ConcurrentMap<String, IndexOutput> outputs = this.openIndexOutputs;
        IndexOutput indexOutput = store.createOutputRaw(name);
        outputs.put(key, indexOutput);
        return indexOutput;
    }
}

