/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.text.StringText;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.util.DoubleObjectPagedHashMap;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.terms.InternalOrder;
import org.elasticsearch.search.aggregations.bucket.terms.InternalTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.UnmappedTerms;
import org.elasticsearch.search.aggregations.bucket.terms.support.BucketPriorityQueue;
import org.elasticsearch.search.aggregations.support.numeric.ValueFormatter;
import org.elasticsearch.search.aggregations.support.numeric.ValueFormatterStreams;

public class DoubleTerms
extends InternalTerms {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("terms", "dterms");
    public static AggregationStreams.Stream STREAM = new AggregationStreams.Stream(){

        @Override
        public DoubleTerms readResult(StreamInput in) throws IOException {
            DoubleTerms buckets = new DoubleTerms();
            buckets.readFrom(in);
            return buckets;
        }
    };
    private ValueFormatter valueFormatter;

    public static void registerStreams() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
    }

    DoubleTerms() {
    }

    public DoubleTerms(String name, InternalOrder order, int requiredSize, long minDocCount, Collection<InternalTerms.Bucket> buckets) {
        this(name, order, null, requiredSize, minDocCount, buckets);
    }

    public DoubleTerms(String name, InternalOrder order, ValueFormatter valueFormatter, int requiredSize, long minDocCount, Collection<InternalTerms.Bucket> buckets) {
        super(name, order, requiredSize, minDocCount, buckets);
        this.valueFormatter = valueFormatter;
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InternalTerms reduce(InternalAggregation.ReduceContext reduceContext) {
        void var8_14;
        List<InternalAggregation> aggregations = reduceContext.aggregations();
        if (aggregations.size() == 1) {
            InternalTerms terms = (InternalTerms)aggregations.get(0);
            terms.trimExcessEntries(reduceContext.bigArrays());
            return terms;
        }
        InternalTerms reduced = null;
        DoubleObjectPagedHashMap<ArrayList<Bucket>> buckets = null;
        for (InternalAggregation aggregation : aggregations) {
            InternalTerms terms = (InternalTerms)aggregation;
            if (terms instanceof UnmappedTerms) continue;
            if (reduced == null) {
                reduced = terms;
            }
            if (buckets == null) {
                buckets = new DoubleObjectPagedHashMap<ArrayList<Bucket>>(terms.buckets.size(), reduceContext.bigArrays());
            }
            for (InternalTerms.Bucket bucket : terms.buckets) {
                ArrayList<Bucket> existingBuckets = (ArrayList<Bucket>)buckets.get(((Bucket)bucket).term);
                if (existingBuckets == null) {
                    existingBuckets = new ArrayList<Bucket>(aggregations.size());
                    buckets.put(((Bucket)bucket).term, existingBuckets);
                }
                existingBuckets.add((Bucket)bucket);
            }
        }
        if (reduced == null) {
            return (UnmappedTerms)aggregations.get(0);
        }
        int size = (int)Math.min((long)this.requiredSize, buckets.size());
        BucketPriorityQueue ordered = new BucketPriorityQueue(size, this.order.comparator(null));
        for (DoubleObjectPagedHashMap.Cursor cursor : buckets) {
            List sameTermBuckets = (List)cursor.value;
            InternalTerms.Bucket b = ((Bucket)sameTermBuckets.get(0)).reduce(sameTermBuckets, reduceContext.bigArrays());
            if (b.getDocCount() < this.minDocCount) continue;
            ordered.insertWithOverflow(b);
        }
        buckets.release();
        InternalTerms.Bucket[] list = new InternalTerms.Bucket[ordered.size()];
        int n = ordered.size() - 1;
        while (var8_14 >= 0) {
            list[var8_14] = (Bucket)ordered.pop();
            --var8_14;
        }
        reduced.buckets = Arrays.asList(list);
        return reduced;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readString();
        this.order = InternalOrder.Streams.readOrder(in);
        this.valueFormatter = ValueFormatterStreams.readOptional(in);
        this.requiredSize = DoubleTerms.readSize(in);
        this.minDocCount = in.readVLong();
        int size = in.readVInt();
        ArrayList<Bucket> buckets = new ArrayList<Bucket>(size);
        for (int i = 0; i < size; ++i) {
            buckets.add(new Bucket(in.readDouble(), in.readVLong(), InternalAggregations.readAggregations(in)));
        }
        this.buckets = buckets;
        this.bucketMap = null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        InternalOrder.Streams.writeOrder(this.order, out);
        ValueFormatterStreams.writeOptional(this.valueFormatter, out);
        DoubleTerms.writeSize(this.requiredSize, out);
        out.writeVLong(this.minDocCount);
        out.writeVInt(this.buckets.size());
        for (InternalTerms.Bucket bucket : this.buckets) {
            out.writeDouble(((Bucket)bucket).term);
            out.writeVLong(bucket.getDocCount());
            ((InternalAggregations)bucket.getAggregations()).writeTo(out);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name);
        builder.startArray(InternalAggregation.CommonFields.BUCKETS);
        for (InternalTerms.Bucket bucket : this.buckets) {
            builder.startObject();
            builder.field(InternalAggregation.CommonFields.KEY, ((Bucket)bucket).term);
            if (this.valueFormatter != null) {
                builder.field(InternalAggregation.CommonFields.KEY_AS_STRING, this.valueFormatter.format(((Bucket)bucket).term));
            }
            builder.field(InternalAggregation.CommonFields.DOC_COUNT, bucket.getDocCount());
            ((InternalAggregations)bucket.getAggregations()).toXContentInternal(builder, params);
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    static class Bucket
    extends InternalTerms.Bucket {
        double term;

        public Bucket(double term, long docCount, InternalAggregations aggregations) {
            super(docCount, aggregations);
            this.term = term;
        }

        @Override
        public String getKey() {
            return String.valueOf(this.term);
        }

        @Override
        public Text getKeyAsText() {
            return new StringText(String.valueOf(this.term));
        }

        @Override
        public Number getKeyAsNumber() {
            return this.term;
        }

        @Override
        int compareTerm(Terms.Bucket other) {
            return Double.compare(this.term, other.getKeyAsNumber().doubleValue());
        }
    }
}

