/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.core;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.Timer;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.deletebyquery.DeleteByQueryRequestBuilder;
import org.elasticsearch.action.deletebyquery.DeleteByQueryResponse;
import org.elasticsearch.action.deletebyquery.IndexDeleteByQueryResponse;
import org.elasticsearch.action.get.GetRequestBuilder;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.nuxeo.ecm.automation.jaxrs.io.documents.JsonESDocumentWriter;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.elasticsearch.api.ElasticSearchIndexing;
import org.nuxeo.elasticsearch.commands.IndexingCommand;
import org.nuxeo.elasticsearch.core.ElasticSearchAdminImpl;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.metrics.MetricsService;

public class ElasticSearchIndexingImpl
implements ElasticSearchIndexing {
    private static final Log log = LogFactory.getLog(ElasticSearchIndexingImpl.class);
    private final ElasticSearchAdminImpl esa;
    private final Timer deleteTimer;
    private final Timer indexTimer;
    private final Timer bulkIndexTimer;

    public ElasticSearchIndexingImpl(ElasticSearchAdminImpl esa) {
        this.esa = esa;
        MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
        this.indexTimer = registry.timer(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"elasticsearch", "service", "index"}));
        this.deleteTimer = registry.timer(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"elasticsearch", "service", "delete"}));
        this.bulkIndexTimer = registry.timer(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"elasticsearch", "service", "bulkIndex"}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void indexNow(List<IndexingCommand> cmds) throws ClientException {
        int nbCommands = cmds.size();
        this.esa.totalCommandRunning.addAndGet(nbCommands);
        try {
            this.processBulkDeleteCommands(cmds);
            Timer.Context stopWatch = this.bulkIndexTimer.time();
            try {
                this.processBulkIndexCommands(cmds);
            }
            finally {
                stopWatch.stop();
            }
        }
        finally {
            this.esa.totalCommandRunning.addAndGet(-nbCommands);
        }
        this.esa.totalCommandProcessed.addAndGet(nbCommands);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processBulkDeleteCommands(List<IndexingCommand> cmds) {
        for (IndexingCommand cmd : cmds) {
            if (!"ES_DELETE".equals(cmd.getName())) continue;
            Timer.Context stopWatch = this.deleteTimer.time();
            try {
                this.processDeleteCommand(cmd);
            }
            finally {
                stopWatch.stop();
            }
        }
    }

    void processBulkIndexCommands(List<IndexingCommand> cmds) throws ClientException {
        BulkRequestBuilder bulkRequest = this.esa.getClient().prepareBulk();
        for (IndexingCommand cmd : cmds) {
            String id = cmd.getDocId();
            if ("unknown".equals(id) || "ES_DELETE".equals(cmd.getName())) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)("Sending bulk indexing request to Elasticsearch: " + cmd));
            }
            if (cmd.getTargetDocument() == null) {
                log.warn((Object)("Skipping cmd because targetDocument is null " + cmd));
                continue;
            }
            try {
                IndexRequestBuilder idxRequest = this.buildEsIndexingRequest(cmd);
                bulkRequest.add(idxRequest);
            }
            catch (ClientException e) {
                log.error((Object)("Fail to create indexing request for cmd: " + cmd), (Throwable)e);
            }
        }
        if (bulkRequest.numberOfActions() > 0) {
            BulkResponse response;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Index %d docs in bulk request: curl -XPOST 'http://localhost:9200/_bulk' -d '%s'", bulkRequest.numberOfActions(), ((BulkRequest)bulkRequest.request()).requests().toString()));
            }
            if ((response = (BulkResponse)bulkRequest.execute().actionGet()).hasFailures()) {
                log.error((Object)response.buildFailureMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void indexNow(IndexingCommand cmd) throws ClientException {
        if (cmd.getTargetDocument() == null && "unknown".equals(cmd.getDocId())) {
            this.esa.totalCommandProcessed.addAndGet(1);
            return;
        }
        this.esa.totalCommandRunning.incrementAndGet();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Sending indexing request to Elasticsearch: " + cmd.toString()));
        }
        if ("ES_DELETE".equals(cmd.getName())) {
            Timer.Context stopWatch = this.deleteTimer.time();
            try {
                this.processDeleteCommand(cmd);
            }
            finally {
                stopWatch.stop();
                this.esa.totalCommandProcessed.addAndGet(1);
                this.esa.totalCommandRunning.decrementAndGet();
            }
        }
        Timer.Context stopWatch = this.indexTimer.time();
        try {
            this.processIndexCommand(cmd);
        }
        finally {
            stopWatch.stop();
            this.esa.totalCommandProcessed.addAndGet(1);
            this.esa.totalCommandRunning.decrementAndGet();
        }
    }

    void processIndexCommand(IndexingCommand cmd) {
        IndexRequestBuilder request;
        String docId = cmd.getDocId();
        if ("unknown".equals(docId) || cmd.getTargetDocument() == null) {
            log.warn((Object)("Skipping cmd because targetDocument is null " + cmd));
            return;
        }
        try {
            request = this.buildEsIndexingRequest(cmd);
        }
        catch (ClientException e) {
            log.error((Object)("Fail to create indexing request for cmd: " + cmd), (Throwable)e);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Index request: curl -XPUT 'http://localhost:9200/%s/%s/%s' -d '%s'", this.esa.getRepositoryIndex(cmd.getRepository()), "doc", docId, ((IndexRequest)request.request()).toString()));
        }
        request.execute().actionGet();
    }

    void processDeleteCommand(IndexingCommand cmd) {
        if (cmd.isRecurse()) {
            this.processDeleteCommandRecursive(cmd);
        } else {
            this.processDeleteCommandNonRecursive(cmd);
        }
    }

    void processDeleteCommandNonRecursive(IndexingCommand cmd) {
        String indexName = this.esa.getRepositoryIndex(cmd.getRepository());
        DeleteRequestBuilder request = this.esa.getClient().prepareDelete(indexName, "doc", cmd.getDocId());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Delete request: curl -XDELETE 'http://localhost:9200/%s/%s/%s'", indexName, "doc", cmd.getDocId()));
        }
        request.execute().actionGet();
    }

    void processDeleteCommandRecursive(IndexingCommand cmd) {
        String indexName = this.esa.getRepositoryIndex(cmd.getRepository());
        String docPath = this.getPathOfDocFromEs(cmd.getRepository(), cmd.getDocId());
        if (docPath == null) {
            if (!Framework.isTestModeSet()) {
                log.warn((Object)("Trying to delete a non existing doc: " + cmd.toString()));
            }
            return;
        }
        ConstantScoreQueryBuilder query = QueryBuilders.constantScoreQuery((FilterBuilder)FilterBuilders.termFilter((String)"ecm:path.children", (String)docPath));
        DeleteByQueryRequestBuilder deleteRequest = this.esa.getClient().prepareDeleteByQuery(new String[]{indexName}).setTypes(new String[]{"doc"}).setQuery((QueryBuilder)query);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Delete byQuery request: curl -XDELETE 'http://localhost:9200/%s/%s/_query' -d '%s'", indexName, "doc", query.toString()));
        }
        DeleteByQueryResponse responses = (DeleteByQueryResponse)deleteRequest.execute().actionGet();
        for (IndexDeleteByQueryResponse response : responses) {
            if (response.getFailedShards() <= 0) continue;
            log.error((Object)String.format("Delete byQuery fails on shard: %d out of %d", response.getFailedShards(), response.getTotalShards()));
        }
    }

    String getPathOfDocFromEs(String repository, String docId) {
        GetResponse ret;
        String indexName = this.esa.getRepositoryIndex(repository);
        GetRequestBuilder getRequest = this.esa.getClient().prepareGet(indexName, "doc", docId).setFields(new String[]{"ecm:path"});
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Get path of doc: curl -XGET 'http://localhost:9200/%s/%s/%s?fields=%s'", indexName, "doc", docId, "ecm:path"));
        }
        if (!(ret = (GetResponse)getRequest.execute().actionGet()).isExists()) {
            return null;
        }
        return ret.getField("ecm:path").getValue().toString();
    }

    IndexRequestBuilder buildEsIndexingRequest(IndexingCommand cmd) throws ClientException {
        DocumentModel doc = cmd.getTargetDocument();
        try {
            JsonFactory factory = new JsonFactory();
            XContentBuilder builder = XContentFactory.jsonBuilder();
            JsonGenerator jsonGen = factory.createJsonGenerator(builder.stream());
            JsonESDocumentWriter.writeESDocument((JsonGenerator)jsonGen, (DocumentModel)doc, (String[])cmd.getSchemas(), null);
            return this.esa.getClient().prepareIndex(this.esa.getRepositoryIndex(cmd.getRepository()), "doc", cmd.getDocId()).setSource(builder);
        }
        catch (Exception e) {
            throw new ClientException("Unable to create index request for Document " + cmd.getDocId(), (Throwable)e);
        }
    }

    @Override
    public void scheduleIndexing(IndexingCommand cmd) throws ClientException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean isAlreadyScheduled(IndexingCommand cmd) {
        throw new UnsupportedOperationException("Not implemented");
    }
}

