/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.info;

import java.io.IOException;
import java.io.Serializable;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class PluginInfo
implements Streamable,
Serializable,
ToXContent {
    public static final String DESCRIPTION_NOT_AVAILABLE = "No description found.";
    public static final String VERSION_NOT_AVAILABLE = "NA";
    private String name;
    private String description;
    private boolean site;
    private boolean jvm;
    private String version;

    public PluginInfo() {
    }

    public PluginInfo(String name, String description, boolean site, boolean jvm, String version) {
        this.name = name;
        this.description = description;
        this.site = site;
        this.jvm = jvm;
        this.version = Strings.hasText(version) ? version : VERSION_NOT_AVAILABLE;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isSite() {
        return this.site;
    }

    public boolean isJvm() {
        return this.jvm;
    }

    public String getUrl() {
        if (this.site) {
            return "/_plugin/" + this.name + "/";
        }
        return null;
    }

    public String getVersion() {
        return this.version;
    }

    public static PluginInfo readPluginInfo(StreamInput in) throws IOException {
        PluginInfo info = new PluginInfo();
        info.readFrom(in);
        return info;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readString();
        this.description = in.readString();
        this.site = in.readBoolean();
        this.jvm = in.readBoolean();
        this.version = in.getVersion().onOrAfter(Version.V_1_0_0_RC2) ? in.readString() : VERSION_NOT_AVAILABLE;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this.description);
        out.writeBoolean(this.site);
        out.writeBoolean(this.jvm);
        if (out.getVersion().onOrAfter(Version.V_1_0_0_RC2)) {
            out.writeString(this.version);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Fields.NAME, this.name);
        builder.field(Fields.VERSION, this.version);
        builder.field(Fields.DESCRIPTION, this.description);
        if (this.site) {
            builder.field(Fields.URL, this.getUrl());
        }
        builder.field(Fields.JVM, this.jvm);
        builder.field(Fields.SITE, this.site);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginInfo that = (PluginInfo)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("PluginInfo{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", description='").append(this.description).append('\'');
        sb.append(", site=").append(this.site);
        sb.append(", jvm=").append(this.jvm);
        sb.append(", version='").append(this.version).append('\'');
        sb.append('}');
        return sb.toString();
    }

    static final class Fields {
        static final XContentBuilderString NAME = new XContentBuilderString("name");
        static final XContentBuilderString DESCRIPTION = new XContentBuilderString("description");
        static final XContentBuilderString URL = new XContentBuilderString("url");
        static final XContentBuilderString JVM = new XContentBuilderString("jvm");
        static final XContentBuilderString SITE = new XContentBuilderString("site");
        static final XContentBuilderString VERSION = new XContentBuilderString("version");

        Fields() {
        }
    }
}

