/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.util.List;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.joda.time.DateTimeZone;
import org.elasticsearch.common.joda.time.MutableDateTime;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.util.SlicedDoubleList;
import org.elasticsearch.common.util.SlicedLongList;
import org.elasticsearch.common.util.SlicedObjectList;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.index.fielddata.GeoPointValues;
import org.elasticsearch.index.fielddata.LongValues;

public abstract class ScriptDocValues {
    public static final Longs EMPTY_LONGS = new Longs(LongValues.EMPTY);
    public static final Doubles EMPTY_DOUBLES = new Doubles(DoubleValues.EMPTY);
    public static final GeoPoints EMPTY_GEOPOINTS = new GeoPoints(GeoPointValues.EMPTY);
    public static final Strings EMPTY_STRINGS = new Strings(BytesValues.EMPTY);
    protected int docId;
    protected boolean listLoaded = false;

    public void setNextDocId(int docId) {
        this.docId = docId;
        this.listLoaded = false;
    }

    public abstract boolean isEmpty();

    public abstract List<?> getValues();

    public static class GeoPoints
    extends ScriptDocValues {
        private final GeoPointValues values;
        private final SlicedObjectList<GeoPoint> list;

        public GeoPoints(GeoPointValues values) {
            this.values = values;
            this.list = new SlicedObjectList<GeoPoint>(values.isMultiValued() ? new GeoPoint[10] : new GeoPoint[1]){

                @Override
                public void grow(int newLength) {
                    assert (this.offset == 0);
                    if (((GeoPoint[])this.values).length >= newLength) {
                        return;
                    }
                    GeoPoint[] current = (GeoPoint[])this.values;
                    this.values = new GeoPoint[ArrayUtil.oversize((int)newLength, (int)RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
                    System.arraycopy(current, 0, this.values, 0, current.length);
                }
            };
        }

        @Override
        public boolean isEmpty() {
            return this.values.setDocument(this.docId) == 0;
        }

        public GeoPoint getValue() {
            int numValues = this.values.setDocument(this.docId);
            if (numValues == 0) {
                return null;
            }
            return this.values.nextValue();
        }

        public double getLat() {
            return this.getValue().lat();
        }

        public double[] getLats() {
            List<GeoPoint> points = this.getValues();
            double[] lats = new double[points.size()];
            for (int i = 0; i < points.size(); ++i) {
                lats[i] = points.get(i).lat();
            }
            return lats;
        }

        public double[] getLons() {
            List<GeoPoint> points = this.getValues();
            double[] lons = new double[points.size()];
            for (int i = 0; i < points.size(); ++i) {
                lons[i] = points.get(i).lon();
            }
            return lons;
        }

        public double getLon() {
            return this.getValue().lon();
        }

        public List<GeoPoint> getValues() {
            if (!this.listLoaded) {
                int numValues = this.values.setDocument(this.docId);
                this.list.offset = 0;
                this.list.grow(numValues);
                this.list.length = numValues;
                for (int i = 0; i < numValues; ++i) {
                    GeoPoint next = this.values.nextValue();
                    GeoPoint point = ((GeoPoint[])this.list.values)[i];
                    if (point == null) {
                        GeoPoint geoPoint = new GeoPoint();
                        ((GeoPoint[])this.list.values)[i] = geoPoint;
                        point = geoPoint;
                    }
                    point.reset(next.lat(), next.lon());
                    ((GeoPoint[])this.list.values)[i] = point;
                }
                this.listLoaded = true;
            }
            return this.list;
        }

        public double factorDistance(double lat, double lon) {
            GeoPoint point = this.getValue();
            return GeoDistance.FACTOR.calculate(point.lat(), point.lon(), lat, lon, DistanceUnit.DEFAULT);
        }

        public double factorDistanceWithDefault(double lat, double lon, double defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            GeoPoint point = this.getValue();
            return GeoDistance.FACTOR.calculate(point.lat(), point.lon(), lat, lon, DistanceUnit.DEFAULT);
        }

        public double factorDistance02(double lat, double lon) {
            GeoPoint point = this.getValue();
            return GeoDistance.FACTOR.calculate(point.lat(), point.lon(), lat, lon, DistanceUnit.DEFAULT) + 1.0;
        }

        public double factorDistance13(double lat, double lon) {
            GeoPoint point = this.getValue();
            return GeoDistance.FACTOR.calculate(point.lat(), point.lon(), lat, lon, DistanceUnit.DEFAULT) + 2.0;
        }

        public double arcDistance(double lat, double lon) {
            GeoPoint point = this.getValue();
            return GeoDistance.ARC.calculate(point.lat(), point.lon(), lat, lon, DistanceUnit.DEFAULT);
        }

        public double arcDistanceWithDefault(double lat, double lon, double defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            GeoPoint point = this.getValue();
            return GeoDistance.ARC.calculate(point.lat(), point.lon(), lat, lon, DistanceUnit.DEFAULT);
        }

        public double arcDistanceInKm(double lat, double lon) {
            GeoPoint point = this.getValue();
            return GeoDistance.ARC.calculate(point.lat(), point.lon(), lat, lon, DistanceUnit.KILOMETERS);
        }

        public double arcDistanceInKmWithDefault(double lat, double lon, double defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            GeoPoint point = this.getValue();
            return GeoDistance.ARC.calculate(point.lat(), point.lon(), lat, lon, DistanceUnit.KILOMETERS);
        }

        public double arcDistanceInMiles(double lat, double lon) {
            GeoPoint point = this.getValue();
            return GeoDistance.ARC.calculate(point.lat(), point.lon(), lat, lon, DistanceUnit.MILES);
        }

        public double arcDistanceInMilesWithDefault(double lat, double lon, double defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            GeoPoint point = this.getValue();
            return GeoDistance.ARC.calculate(point.lat(), point.lon(), lat, lon, DistanceUnit.MILES);
        }

        public double distance(double lat, double lon) {
            GeoPoint point = this.getValue();
            return GeoDistance.PLANE.calculate(point.lat(), point.lon(), lat, lon, DistanceUnit.DEFAULT);
        }

        public double distanceWithDefault(double lat, double lon, double defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            GeoPoint point = this.getValue();
            return GeoDistance.PLANE.calculate(point.lat(), point.lon(), lat, lon, DistanceUnit.DEFAULT);
        }

        public double distanceInKm(double lat, double lon) {
            GeoPoint point = this.getValue();
            return GeoDistance.PLANE.calculate(point.lat(), point.lon(), lat, lon, DistanceUnit.KILOMETERS);
        }

        public double distanceInKmWithDefault(double lat, double lon, double defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            GeoPoint point = this.getValue();
            return GeoDistance.PLANE.calculate(point.lat(), point.lon(), lat, lon, DistanceUnit.KILOMETERS);
        }

        public double distanceInMiles(double lat, double lon) {
            GeoPoint point = this.getValue();
            return GeoDistance.PLANE.calculate(point.lat(), point.lon(), lat, lon, DistanceUnit.MILES);
        }

        public double distanceInMilesWithDefault(double lat, double lon, double defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            GeoPoint point = this.getValue();
            return GeoDistance.PLANE.calculate(point.lat(), point.lon(), lat, lon, DistanceUnit.MILES);
        }

        public double geohashDistance(String geohash) {
            GeoPoint point = this.getValue();
            GeoPoint p = new GeoPoint().resetFromGeoHash(geohash);
            return GeoDistance.ARC.calculate(point.lat(), point.lon(), p.lat(), p.lon(), DistanceUnit.DEFAULT);
        }

        public double geohashDistanceInKm(String geohash) {
            GeoPoint point = this.getValue();
            GeoPoint p = new GeoPoint().resetFromGeoHash(geohash);
            return GeoDistance.ARC.calculate(point.lat(), point.lon(), p.lat(), p.lon(), DistanceUnit.KILOMETERS);
        }

        public double geohashDistanceInMiles(String geohash) {
            GeoPoint point = this.getValue();
            GeoPoint p = new GeoPoint().resetFromGeoHash(geohash);
            return GeoDistance.ARC.calculate(point.lat(), point.lon(), p.lat(), p.lon(), DistanceUnit.MILES);
        }
    }

    public static class Doubles
    extends ScriptDocValues {
        private final DoubleValues values;
        private final SlicedDoubleList list;

        public Doubles(DoubleValues values) {
            this.values = values;
            this.list = new SlicedDoubleList(values.isMultiValued() ? 10 : 1);
        }

        public DoubleValues getInternalValues() {
            return this.values;
        }

        @Override
        public boolean isEmpty() {
            return this.values.setDocument(this.docId) == 0;
        }

        public double getValue() {
            int numValues = this.values.setDocument(this.docId);
            if (numValues == 0) {
                return 0.0;
            }
            return this.values.nextValue();
        }

        public List<Double> getValues() {
            if (!this.listLoaded) {
                int numValues = this.values.setDocument(this.docId);
                this.list.offset = 0;
                this.list.grow(numValues);
                this.list.length = numValues;
                for (int i = 0; i < numValues; ++i) {
                    this.list.values[i] = this.values.nextValue();
                }
                this.listLoaded = true;
            }
            return this.list;
        }
    }

    public static class Longs
    extends ScriptDocValues {
        private final LongValues values;
        private final MutableDateTime date = new MutableDateTime(0L, DateTimeZone.UTC);
        private final SlicedLongList list;

        public Longs(LongValues values) {
            this.values = values;
            this.list = new SlicedLongList(values.isMultiValued() ? 10 : 1);
        }

        public LongValues getInternalValues() {
            return this.values;
        }

        @Override
        public boolean isEmpty() {
            return this.values.setDocument(this.docId) == 0;
        }

        public long getValue() {
            int numValues = this.values.setDocument(this.docId);
            if (numValues == 0) {
                return 0L;
            }
            return this.values.nextValue();
        }

        public List<Long> getValues() {
            if (!this.listLoaded) {
                int numValues = this.values.setDocument(this.docId);
                this.list.offset = 0;
                this.list.grow(numValues);
                this.list.length = numValues;
                for (int i = 0; i < numValues; ++i) {
                    this.list.values[i] = this.values.nextValue();
                }
                this.listLoaded = true;
            }
            return this.list;
        }

        public MutableDateTime getDate() {
            this.date.setMillis(this.getValue());
            return this.date;
        }
    }

    public static final class Strings
    extends ScriptDocValues {
        private final BytesValues values;
        private final CharsRef spare = new CharsRef();
        private SlicedObjectList<String> list;

        public Strings(BytesValues values) {
            this.values = values;
            this.list = new SlicedObjectList<String>(values.isMultiValued() ? new String[10] : new String[1]){

                @Override
                public void grow(int newLength) {
                    assert (this.offset == 0);
                    if (((String[])this.values).length >= newLength) {
                        return;
                    }
                    String[] current = (String[])this.values;
                    this.values = new String[ArrayUtil.oversize((int)newLength, (int)RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
                    System.arraycopy(current, 0, this.values, 0, current.length);
                }
            };
        }

        @Override
        public boolean isEmpty() {
            return this.values.setDocument(this.docId) == 0;
        }

        public BytesValues getInternalValues() {
            return this.values;
        }

        public BytesRef getBytesValue() {
            int numValues = this.values.setDocument(this.docId);
            if (numValues == 0) {
                return null;
            }
            return this.values.nextValue();
        }

        public String getValue() {
            String value = null;
            if (this.values.setDocument(this.docId) > 0) {
                UnicodeUtil.UTF8toUTF16((BytesRef)this.values.nextValue(), (CharsRef)this.spare);
                value = this.spare.toString();
            }
            return value;
        }

        public List<String> getValues() {
            if (!this.listLoaded) {
                int numValues = this.values.setDocument(this.docId);
                this.list.offset = 0;
                this.list.grow(numValues);
                this.list.length = numValues;
                for (int i = 0; i < numValues; ++i) {
                    BytesRef next = this.values.nextValue();
                    UnicodeUtil.UTF8toUTF16((BytesRef)next, (CharsRef)this.spare);
                    ((String[])this.list.values)[i] = this.spare.toString();
                }
                this.listLoaded = true;
            }
            return this.list;
        }
    }
}

