/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.util.BigDoubleArrayList;
import org.elasticsearch.index.fielddata.AtomicGeoPointFieldData;
import org.elasticsearch.index.fielddata.GeoPointValues;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;

public abstract class GeoPointDoubleArrayAtomicFieldData
extends AtomicGeoPointFieldData<ScriptDocValues> {
    private final int numDocs;
    protected long size = -1L;

    public GeoPointDoubleArrayAtomicFieldData(int numDocs) {
        this.numDocs = numDocs;
    }

    @Override
    public void close() {
    }

    @Override
    public int getNumDocs() {
        return this.numDocs;
    }

    @Override
    public ScriptDocValues getScriptValues() {
        return new ScriptDocValues.GeoPoints(this.getGeoPointValues());
    }

    public static class Single
    extends GeoPointDoubleArrayAtomicFieldData {
        private final BigDoubleArrayList lon;
        private final BigDoubleArrayList lat;
        private final long numOrds;

        public Single(BigDoubleArrayList lon, BigDoubleArrayList lat, int numDocs, long numOrds) {
            super(numDocs);
            this.lon = lon;
            this.lat = lat;
            this.numOrds = numOrds;
        }

        @Override
        public boolean isMultiValued() {
            return false;
        }

        @Override
        public boolean isValuesOrdered() {
            return false;
        }

        @Override
        public long getNumberUniqueValues() {
            return this.numOrds;
        }

        @Override
        public long getMemorySizeInBytes() {
            if (this.size == -1L) {
                this.size = 8L + (this.lon.sizeInBytes() + this.lat.sizeInBytes());
            }
            return this.size;
        }

        @Override
        public GeoPointValues getGeoPointValues() {
            return new GeoPointValuesSingle(this.lon, this.lat);
        }

        static class GeoPointValuesSingle
        extends GeoPointValues {
            private final BigDoubleArrayList lon;
            private final BigDoubleArrayList lat;
            private final GeoPoint scratch = new GeoPoint();

            GeoPointValuesSingle(BigDoubleArrayList lon, BigDoubleArrayList lat) {
                super(false);
                this.lon = lon;
                this.lat = lat;
            }

            @Override
            public int setDocument(int docId) {
                this.docId = docId;
                return 1;
            }

            @Override
            public GeoPoint nextValue() {
                return this.scratch.reset(this.lat.get(this.docId), this.lon.get(this.docId));
            }
        }
    }

    public static class SingleFixedSet
    extends GeoPointDoubleArrayAtomicFieldData {
        private final BigDoubleArrayList lon;
        private final BigDoubleArrayList lat;
        private final FixedBitSet set;
        private final long numOrds;

        public SingleFixedSet(BigDoubleArrayList lon, BigDoubleArrayList lat, int numDocs, FixedBitSet set, long numOrds) {
            super(numDocs);
            this.lon = lon;
            this.lat = lat;
            this.set = set;
            this.numOrds = numOrds;
        }

        @Override
        public boolean isMultiValued() {
            return false;
        }

        @Override
        public boolean isValuesOrdered() {
            return false;
        }

        @Override
        public long getNumberUniqueValues() {
            return this.numOrds;
        }

        @Override
        public long getMemorySizeInBytes() {
            if (this.size == -1L) {
                this.size = 8L + this.lon.sizeInBytes() + this.lat.sizeInBytes() + RamUsageEstimator.sizeOf((long[])this.set.getBits());
            }
            return this.size;
        }

        @Override
        public GeoPointValues getGeoPointValues() {
            return new GeoPointValuesSingleFixedSet(this.lon, this.lat, this.set);
        }

        static class GeoPointValuesSingleFixedSet
        extends GeoPointValues {
            private final BigDoubleArrayList lon;
            private final BigDoubleArrayList lat;
            private final FixedBitSet set;
            private final GeoPoint scratch = new GeoPoint();

            GeoPointValuesSingleFixedSet(BigDoubleArrayList lon, BigDoubleArrayList lat, FixedBitSet set) {
                super(false);
                this.lon = lon;
                this.lat = lat;
                this.set = set;
            }

            @Override
            public int setDocument(int docId) {
                this.docId = docId;
                return this.set.get(docId) ? 1 : 0;
            }

            @Override
            public GeoPoint nextValue() {
                return this.scratch.reset(this.lat.get(this.docId), this.lon.get(this.docId));
            }
        }
    }

    static class WithOrdinals
    extends GeoPointDoubleArrayAtomicFieldData {
        private final BigDoubleArrayList lon;
        private final BigDoubleArrayList lat;
        private final Ordinals ordinals;

        public WithOrdinals(BigDoubleArrayList lon, BigDoubleArrayList lat, int numDocs, Ordinals ordinals) {
            super(numDocs);
            this.lon = lon;
            this.lat = lat;
            this.ordinals = ordinals;
        }

        @Override
        public boolean isMultiValued() {
            return this.ordinals.isMultiValued();
        }

        @Override
        public boolean isValuesOrdered() {
            return true;
        }

        @Override
        public long getNumberUniqueValues() {
            return this.ordinals.getNumOrds();
        }

        @Override
        public long getMemorySizeInBytes() {
            if (this.size == -1L) {
                this.size = 8L + this.lon.sizeInBytes() + this.lat.sizeInBytes();
            }
            return this.size;
        }

        @Override
        public GeoPointValues getGeoPointValues() {
            return new GeoPointValuesWithOrdinals(this.lon, this.lat, this.ordinals.ordinals());
        }

        public static class GeoPointValuesWithOrdinals
        extends GeoPointValues {
            private final BigDoubleArrayList lon;
            private final BigDoubleArrayList lat;
            private final Ordinals.Docs ordinals;
            private final GeoPoint scratch = new GeoPoint();

            GeoPointValuesWithOrdinals(BigDoubleArrayList lon, BigDoubleArrayList lat, Ordinals.Docs ordinals) {
                super(ordinals.isMultiValued());
                this.lon = lon;
                this.lat = lat;
                this.ordinals = ordinals;
            }

            @Override
            public GeoPoint nextValue() {
                long ord = this.ordinals.nextOrd();
                assert (ord > 0L);
                return this.scratch.reset(this.lat.get(ord), this.lon.get(ord));
            }

            @Override
            public int setDocument(int docId) {
                this.docId = docId;
                return this.ordinals.setDocument(docId);
            }
        }
    }
}

