/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.merge.policy;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.TieredMergePolicy;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.index.merge.policy.AbstractMergePolicyProvider;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.index.store.Store;

public class TieredMergePolicyProvider
extends AbstractMergePolicyProvider<TieredMergePolicy> {
    private final IndexSettingsService indexSettingsService;
    private final Set<CustomTieredMergePolicyProvider> policies = new CopyOnWriteArraySet<CustomTieredMergePolicyProvider>();
    private volatile double forceMergeDeletesPctAllowed;
    private volatile ByteSizeValue floorSegment;
    private volatile int maxMergeAtOnce;
    private volatile int maxMergeAtOnceExplicit;
    private volatile ByteSizeValue maxMergedSegment;
    private volatile double segmentsPerTier;
    private volatile double reclaimDeletesWeight;
    private final ApplySettings applySettings = new ApplySettings();
    public static final String INDEX_MERGE_POLICY_EXPUNGE_DELETES_ALLOWED = "index.merge.policy.expunge_deletes_allowed";
    public static final String INDEX_MERGE_POLICY_FLOOR_SEGMENT = "index.merge.policy.floor_segment";
    public static final String INDEX_MERGE_POLICY_MAX_MERGE_AT_ONCE = "index.merge.policy.max_merge_at_once";
    public static final String INDEX_MERGE_POLICY_MAX_MERGE_AT_ONCE_EXPLICIT = "index.merge.policy.max_merge_at_once_explicit";
    public static final String INDEX_MERGE_POLICY_MAX_MERGED_SEGMENT = "index.merge.policy.max_merged_segment";
    public static final String INDEX_MERGE_POLICY_SEGMENTS_PER_TIER = "index.merge.policy.segments_per_tier";
    public static final String INDEX_MERGE_POLICY_RECLAIM_DELETES_WEIGHT = "index.merge.policy.reclaim_deletes_weight";

    @Inject
    public TieredMergePolicyProvider(Store store, IndexSettingsService indexSettingsService) {
        super(store);
        this.indexSettingsService = indexSettingsService;
        this.forceMergeDeletesPctAllowed = this.componentSettings.getAsDouble("expunge_deletes_allowed", (Double)10.0);
        this.floorSegment = this.componentSettings.getAsBytesSize("floor_segment", new ByteSizeValue(2L, ByteSizeUnit.MB));
        this.maxMergeAtOnce = this.componentSettings.getAsInt("max_merge_at_once", (Integer)10);
        this.maxMergeAtOnceExplicit = this.componentSettings.getAsInt("max_merge_at_once_explicit", (Integer)30);
        this.maxMergedSegment = this.componentSettings.getAsBytesSize("max_merged_segment", this.componentSettings.getAsBytesSize("max_merge_segment", new ByteSizeValue(5L, ByteSizeUnit.GB)));
        this.segmentsPerTier = this.componentSettings.getAsDouble("segments_per_tier", (Double)10.0);
        this.reclaimDeletesWeight = this.componentSettings.getAsDouble("reclaim_deletes_weight", (Double)2.0);
        this.fixSettingsIfNeeded();
        this.logger.debug("using [tiered] merge policy with expunge_deletes_allowed[{}], floor_segment[{}], max_merge_at_once[{}], max_merge_at_once_explicit[{}], max_merged_segment[{}], segments_per_tier[{}], reclaim_deletes_weight[{}]", this.forceMergeDeletesPctAllowed, this.floorSegment, this.maxMergeAtOnce, this.maxMergeAtOnceExplicit, this.maxMergedSegment, this.segmentsPerTier, this.reclaimDeletesWeight);
        indexSettingsService.addListener(this.applySettings);
    }

    private void fixSettingsIfNeeded() {
        if (!(this.segmentsPerTier >= (double)this.maxMergeAtOnce)) {
            int newMaxMergeAtOnce = (int)this.segmentsPerTier;
            if (newMaxMergeAtOnce <= 1) {
                newMaxMergeAtOnce = 2;
            }
            this.logger.debug("[tiered] merge policy changing max_merge_at_once from [{}] to [{}] because segments_per_tier [{}] has to be higher or equal to it", this.maxMergeAtOnce, newMaxMergeAtOnce, this.segmentsPerTier);
            this.maxMergeAtOnce = newMaxMergeAtOnce;
        }
    }

    @Override
    public TieredMergePolicy newMergePolicy() {
        CustomTieredMergePolicyProvider mergePolicy = new CustomTieredMergePolicyProvider(this);
        mergePolicy.setNoCFSRatio(this.noCFSRatio);
        mergePolicy.setForceMergeDeletesPctAllowed(this.forceMergeDeletesPctAllowed);
        mergePolicy.setFloorSegmentMB(this.floorSegment.mbFrac());
        mergePolicy.setMaxMergeAtOnce(this.maxMergeAtOnce);
        mergePolicy.setMaxMergeAtOnceExplicit(this.maxMergeAtOnceExplicit);
        mergePolicy.setMaxMergedSegmentMB(this.maxMergedSegment.mbFrac());
        mergePolicy.setSegmentsPerTier(this.segmentsPerTier);
        mergePolicy.setReclaimDeletesWeight(this.reclaimDeletesWeight);
        return mergePolicy;
    }

    @Override
    public void close() throws ElasticsearchException {
        this.indexSettingsService.removeListener(this.applySettings);
    }

    public static class CustomTieredMergePolicyProvider
    extends TieredMergePolicy {
        private final TieredMergePolicyProvider provider;

        public CustomTieredMergePolicyProvider(TieredMergePolicyProvider provider) {
            this.provider = provider;
        }

        public void close() {
            super.close();
            this.provider.policies.remove((Object)this);
        }

        public MergePolicy clone() {
            return this;
        }
    }

    class ApplySettings
    implements IndexSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            double noCFSRatio;
            double reclaimDeletesWeight;
            double segmentsPerTier;
            ByteSizeValue maxMergedSegment;
            int maxMergeAtOnceExplicit;
            int maxMergeAtOnce;
            ByteSizeValue floorSegment;
            double expungeDeletesPctAllowed = settings.getAsDouble(TieredMergePolicyProvider.INDEX_MERGE_POLICY_EXPUNGE_DELETES_ALLOWED, (Double)TieredMergePolicyProvider.this.forceMergeDeletesPctAllowed);
            if (expungeDeletesPctAllowed != TieredMergePolicyProvider.this.forceMergeDeletesPctAllowed) {
                TieredMergePolicyProvider.this.logger.info("updating [expunge_deletes_allowed] from [{}] to [{}]", TieredMergePolicyProvider.this.forceMergeDeletesPctAllowed, expungeDeletesPctAllowed);
                TieredMergePolicyProvider.this.forceMergeDeletesPctAllowed = expungeDeletesPctAllowed;
                for (CustomTieredMergePolicyProvider policy : TieredMergePolicyProvider.this.policies) {
                    policy.setForceMergeDeletesPctAllowed(expungeDeletesPctAllowed);
                }
            }
            if (!(floorSegment = settings.getAsBytesSize(TieredMergePolicyProvider.INDEX_MERGE_POLICY_FLOOR_SEGMENT, TieredMergePolicyProvider.this.floorSegment)).equals(TieredMergePolicyProvider.this.floorSegment)) {
                TieredMergePolicyProvider.this.logger.info("updating [floor_segment] from [{}] to [{}]", TieredMergePolicyProvider.this.floorSegment, floorSegment);
                TieredMergePolicyProvider.this.floorSegment = floorSegment;
                for (CustomTieredMergePolicyProvider policy : TieredMergePolicyProvider.this.policies) {
                    policy.setFloorSegmentMB(floorSegment.mbFrac());
                }
            }
            if ((maxMergeAtOnce = settings.getAsInt(TieredMergePolicyProvider.INDEX_MERGE_POLICY_MAX_MERGE_AT_ONCE, (Integer)TieredMergePolicyProvider.this.maxMergeAtOnce).intValue()) != TieredMergePolicyProvider.this.maxMergeAtOnce) {
                TieredMergePolicyProvider.this.logger.info("updating [max_merge_at_once] from [{}] to [{}]", TieredMergePolicyProvider.this.maxMergeAtOnce, maxMergeAtOnce);
                TieredMergePolicyProvider.this.maxMergeAtOnce = maxMergeAtOnce;
                for (CustomTieredMergePolicyProvider policy : TieredMergePolicyProvider.this.policies) {
                    policy.setMaxMergeAtOnce(maxMergeAtOnce);
                }
            }
            if ((maxMergeAtOnceExplicit = settings.getAsInt(TieredMergePolicyProvider.INDEX_MERGE_POLICY_MAX_MERGE_AT_ONCE_EXPLICIT, (Integer)TieredMergePolicyProvider.this.maxMergeAtOnceExplicit).intValue()) != TieredMergePolicyProvider.this.maxMergeAtOnceExplicit) {
                TieredMergePolicyProvider.this.logger.info("updating [max_merge_at_once_explicit] from [{}] to [{}]", TieredMergePolicyProvider.this.maxMergeAtOnceExplicit, maxMergeAtOnceExplicit);
                TieredMergePolicyProvider.this.maxMergeAtOnceExplicit = maxMergeAtOnceExplicit;
                for (CustomTieredMergePolicyProvider policy : TieredMergePolicyProvider.this.policies) {
                    policy.setMaxMergeAtOnceExplicit(maxMergeAtOnceExplicit);
                }
            }
            if (!(maxMergedSegment = settings.getAsBytesSize(TieredMergePolicyProvider.INDEX_MERGE_POLICY_MAX_MERGED_SEGMENT, TieredMergePolicyProvider.this.maxMergedSegment)).equals(TieredMergePolicyProvider.this.maxMergedSegment)) {
                TieredMergePolicyProvider.this.logger.info("updating [max_merged_segment] from [{}] to [{}]", TieredMergePolicyProvider.this.maxMergedSegment, maxMergedSegment);
                TieredMergePolicyProvider.this.maxMergedSegment = maxMergedSegment;
                for (CustomTieredMergePolicyProvider policy : TieredMergePolicyProvider.this.policies) {
                    policy.setFloorSegmentMB(maxMergedSegment.mbFrac());
                }
            }
            if ((segmentsPerTier = settings.getAsDouble(TieredMergePolicyProvider.INDEX_MERGE_POLICY_SEGMENTS_PER_TIER, (Double)TieredMergePolicyProvider.this.segmentsPerTier).doubleValue()) != TieredMergePolicyProvider.this.segmentsPerTier) {
                TieredMergePolicyProvider.this.logger.info("updating [segments_per_tier] from [{}] to [{}]", TieredMergePolicyProvider.this.segmentsPerTier, segmentsPerTier);
                TieredMergePolicyProvider.this.segmentsPerTier = segmentsPerTier;
                for (CustomTieredMergePolicyProvider policy : TieredMergePolicyProvider.this.policies) {
                    policy.setSegmentsPerTier(segmentsPerTier);
                }
            }
            if ((reclaimDeletesWeight = settings.getAsDouble(TieredMergePolicyProvider.INDEX_MERGE_POLICY_RECLAIM_DELETES_WEIGHT, (Double)TieredMergePolicyProvider.this.reclaimDeletesWeight).doubleValue()) != TieredMergePolicyProvider.this.reclaimDeletesWeight) {
                TieredMergePolicyProvider.this.logger.info("updating [reclaim_deletes_weight] from [{}] to [{}]", TieredMergePolicyProvider.this.reclaimDeletesWeight, reclaimDeletesWeight);
                TieredMergePolicyProvider.this.reclaimDeletesWeight = reclaimDeletesWeight;
                for (CustomTieredMergePolicyProvider policy : TieredMergePolicyProvider.this.policies) {
                    policy.setReclaimDeletesWeight(reclaimDeletesWeight);
                }
            }
            if ((noCFSRatio = AbstractMergePolicyProvider.parseNoCFSRatio(settings.get("index.compound_format", Double.toString(TieredMergePolicyProvider.this.noCFSRatio)))) != TieredMergePolicyProvider.this.noCFSRatio) {
                TieredMergePolicyProvider.this.logger.info("updating index.compound_format from [{}] to [{}]", AbstractMergePolicyProvider.formatNoCFSRatio(TieredMergePolicyProvider.this.noCFSRatio), AbstractMergePolicyProvider.formatNoCFSRatio(noCFSRatio));
                TieredMergePolicyProvider.this.noCFSRatio = noCFSRatio;
                for (CustomTieredMergePolicyProvider policy : TieredMergePolicyProvider.this.policies) {
                    policy.setNoCFSRatio(noCFSRatio);
                }
            }
            TieredMergePolicyProvider.this.fixSettingsIfNeeded();
        }
    }
}

