/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.util.Locale;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.Query;

public class SimpleQueryParser
extends org.apache.lucene.queryparser.simple.SimpleQueryParser {
    private final Settings settings;

    public SimpleQueryParser(Analyzer analyzer, Map<String, Float> weights, int flags, Settings settings) {
        super(analyzer, weights, flags);
        this.settings = settings;
    }

    private Query rethrowUnlessLenient(RuntimeException e) {
        if (this.settings.lenient()) {
            return null;
        }
        throw e;
    }

    public Query newDefaultQuery(String text) {
        try {
            return super.newDefaultQuery(text);
        }
        catch (RuntimeException e) {
            return this.rethrowUnlessLenient(e);
        }
    }

    public Query newFuzzyQuery(String text, int fuzziness) {
        if (this.settings.lowercaseExpandedTerms()) {
            text = text.toLowerCase(this.settings.locale());
        }
        try {
            return super.newFuzzyQuery(text, fuzziness);
        }
        catch (RuntimeException e) {
            return this.rethrowUnlessLenient(e);
        }
    }

    public Query newPhraseQuery(String text, int slop) {
        try {
            return super.newPhraseQuery(text, slop);
        }
        catch (RuntimeException e) {
            return this.rethrowUnlessLenient(e);
        }
    }

    public Query newPrefixQuery(String text) {
        if (this.settings.lowercaseExpandedTerms()) {
            text = text.toLowerCase(this.settings.locale());
        }
        try {
            return super.newPrefixQuery(text);
        }
        catch (RuntimeException e) {
            return this.rethrowUnlessLenient(e);
        }
    }

    public static class Settings {
        private Locale locale = Locale.ROOT;
        private boolean lowercaseExpandedTerms = true;
        private boolean lenient = false;

        public void locale(Locale locale) {
            this.locale = locale;
        }

        public Locale locale() {
            return this.locale;
        }

        public void lowercaseExpandedTerms(boolean lowercaseExpandedTerms) {
            this.lowercaseExpandedTerms = lowercaseExpandedTerms;
        }

        public boolean lowercaseExpandedTerms() {
            return this.lowercaseExpandedTerms;
        }

        public void lenient(boolean lenient) {
            this.lenient = lenient;
        }

        public boolean lenient() {
            return this.lenient;
        }
    }
}

