/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.geogrid;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.common.geo.GeoHashUtils;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.text.StringText;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.LongObjectPagedHashMap;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoHashGrid;

public class InternalGeoHashGrid
extends InternalAggregation
implements GeoHashGrid {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("geohash_grid", "ghcells");
    public static AggregationStreams.Stream STREAM = new AggregationStreams.Stream(){

        @Override
        public InternalGeoHashGrid readResult(StreamInput in) throws IOException {
            InternalGeoHashGrid buckets = new InternalGeoHashGrid();
            buckets.readFrom(in);
            return buckets;
        }
    };
    private int requiredSize;
    private Collection<Bucket> buckets;
    protected Map<String, Bucket> bucketMap;

    public static void registerStreams() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
    }

    InternalGeoHashGrid() {
    }

    public InternalGeoHashGrid(String name, int requiredSize, Collection<Bucket> buckets) {
        super(name);
        this.requiredSize = requiredSize;
        this.buckets = buckets;
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    @Override
    public Collection<GeoHashGrid.Bucket> getBuckets() {
        Collection<GeoHashGrid.Bucket> o = this.buckets;
        return o;
    }

    @Override
    public GeoHashGrid.Bucket getBucketByKey(String geohash) {
        if (this.bucketMap == null) {
            this.bucketMap = new HashMap<String, Bucket>(this.buckets.size());
            for (Bucket bucket : this.buckets) {
                this.bucketMap.put(bucket.getKey(), bucket);
            }
        }
        return this.bucketMap.get(geohash);
    }

    @Override
    public GeoHashGrid.Bucket getBucketByKey(Number key) {
        return this.getBucketByKey(GeoHashUtils.toString(key.longValue()));
    }

    @Override
    public GeoHashGrid.Bucket getBucketByKey(GeoPoint key) {
        return this.getBucketByKey(key.geohash());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InternalGeoHashGrid reduce(InternalAggregation.ReduceContext reduceContext) {
        void var8_14;
        List<InternalAggregation> aggregations = reduceContext.aggregations();
        if (aggregations.size() == 1) {
            InternalGeoHashGrid grid = (InternalGeoHashGrid)aggregations.get(0);
            grid.reduceAndTrimBuckets(reduceContext.bigArrays());
            return grid;
        }
        InternalGeoHashGrid reduced = null;
        LongObjectPagedHashMap<ArrayList<Bucket>> buckets = null;
        for (InternalAggregation aggregation : aggregations) {
            InternalGeoHashGrid grid = (InternalGeoHashGrid)aggregation;
            if (reduced == null) {
                reduced = grid;
            }
            if (buckets == null) {
                buckets = new LongObjectPagedHashMap<ArrayList<Bucket>>(grid.buckets.size(), reduceContext.bigArrays());
            }
            for (Bucket bucket : grid.buckets) {
                ArrayList<Bucket> existingBuckets = (ArrayList<Bucket>)buckets.get(bucket.geohashAsLong);
                if (existingBuckets == null) {
                    existingBuckets = new ArrayList<Bucket>(aggregations.size());
                    buckets.put(bucket.geohashAsLong, existingBuckets);
                }
                existingBuckets.add(bucket);
            }
        }
        if (reduced == null) {
            return (InternalGeoHashGrid)aggregations.get(0);
        }
        int size = (int)Math.min((long)this.requiredSize, buckets.size());
        BucketPriorityQueue ordered = new BucketPriorityQueue(size);
        for (LongObjectPagedHashMap.Cursor cursor : buckets) {
            List sameCellBuckets = (List)cursor.value;
            ordered.insertWithOverflow(((Bucket)sameCellBuckets.get(0)).reduce(sameCellBuckets, reduceContext.bigArrays()));
        }
        buckets.release();
        Bucket[] list = new Bucket[ordered.size()];
        int n = ordered.size() - 1;
        while (var8_14 >= 0) {
            list[var8_14] = (Bucket)ordered.pop();
            --var8_14;
        }
        reduced.buckets = Arrays.asList(list);
        return reduced;
    }

    protected void reduceAndTrimBuckets(BigArrays bigArrays) {
        if (this.requiredSize > this.buckets.size()) {
            for (Bucket bucket : this.buckets) {
                bucket.aggregations.reduce(bigArrays);
            }
            return;
        }
        ArrayList<Bucket> trimmedBuckets = new ArrayList<Bucket>(this.requiredSize);
        for (Bucket bucket : this.buckets) {
            if (trimmedBuckets.size() >= this.requiredSize) break;
            bucket.aggregations.reduce(bigArrays);
            trimmedBuckets.add(bucket);
        }
        this.buckets = trimmedBuckets;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readString();
        this.requiredSize = InternalGeoHashGrid.readSize(in);
        int size = in.readVInt();
        ArrayList<Bucket> buckets = new ArrayList<Bucket>(size);
        for (int i = 0; i < size; ++i) {
            buckets.add(new Bucket(in.readLong(), in.readVLong(), InternalAggregations.readAggregations(in)));
        }
        this.buckets = buckets;
        this.bucketMap = null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        InternalGeoHashGrid.writeSize(this.requiredSize, out);
        out.writeVInt(this.buckets.size());
        for (Bucket bucket : this.buckets) {
            out.writeLong(bucket.geohashAsLong);
            out.writeVLong(bucket.getDocCount());
            ((InternalAggregations)bucket.getAggregations()).writeTo(out);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name);
        builder.startArray(InternalAggregation.CommonFields.BUCKETS);
        for (Bucket bucket : this.buckets) {
            builder.startObject();
            builder.field(InternalAggregation.CommonFields.KEY, bucket.getKeyAsText());
            builder.field(InternalAggregation.CommonFields.DOC_COUNT, bucket.getDocCount());
            ((InternalAggregations)bucket.getAggregations()).toXContentInternal(builder, params);
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    static class BucketPriorityQueue
    extends PriorityQueue<Bucket> {
        public BucketPriorityQueue(int size) {
            super(size);
        }

        protected boolean lessThan(Bucket o1, Bucket o2) {
            long i = o2.getDocCount() - o1.getDocCount();
            if (i == 0L && (i = (long)o2.compareTo(o1)) == 0L) {
                i = System.identityHashCode(o2) - System.identityHashCode(o1);
            }
            return i > 0L;
        }
    }

    static class Bucket
    implements GeoHashGrid.Bucket,
    Comparable<Bucket> {
        protected long geohashAsLong;
        protected long docCount;
        protected InternalAggregations aggregations;

        public Bucket(long geohashAsLong, long docCount, InternalAggregations aggregations) {
            this.docCount = docCount;
            this.aggregations = aggregations;
            this.geohashAsLong = geohashAsLong;
        }

        @Override
        public String getKey() {
            return GeoHashUtils.toString(this.geohashAsLong);
        }

        @Override
        public Text getKeyAsText() {
            return new StringText(this.getKey());
        }

        @Override
        public GeoPoint getKeyAsGeoPoint() {
            return GeoHashUtils.decode(this.geohashAsLong);
        }

        @Override
        public long getDocCount() {
            return this.docCount;
        }

        @Override
        public Aggregations getAggregations() {
            return this.aggregations;
        }

        @Override
        public int compareTo(Bucket other) {
            if (this.geohashAsLong > other.geohashAsLong) {
                return 1;
            }
            if (this.geohashAsLong < other.geohashAsLong) {
                return -1;
            }
            return 0;
        }

        public Bucket reduce(List<? extends Bucket> buckets, BigArrays bigArrays) {
            if (buckets.size() == 1) {
                Bucket bucket = buckets.get(0);
                bucket.aggregations.reduce(bigArrays);
                return bucket;
            }
            Bucket reduced = null;
            ArrayList<InternalAggregations> aggregationsList = new ArrayList<InternalAggregations>(buckets.size());
            for (Bucket bucket : buckets) {
                if (reduced == null) {
                    reduced = bucket;
                } else {
                    reduced.docCount += bucket.docCount;
                }
                aggregationsList.add(bucket.aggregations);
            }
            reduced.aggregations = InternalAggregations.reduce(aggregationsList, bigArrays);
            return reduced;
        }

        @Override
        public Number getKeyAsNumber() {
            return this.geohashAsLong;
        }
    }
}

