/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

public class DiskUsage {
    final String nodeId;
    final long totalBytes;
    final long freeBytes;

    public DiskUsage(String nodeId, long totalBytes, long freeBytes) {
        if (totalBytes < freeBytes || totalBytes < 0L) {
            throw new IllegalStateException("Free bytes [" + freeBytes + "] cannot be less than 0 or greater than total bytes [" + totalBytes + "]");
        }
        this.nodeId = nodeId;
        this.totalBytes = totalBytes;
        this.freeBytes = freeBytes;
    }

    public double getFreeDiskAsPercentage() {
        double freePct = 100.0 * ((double)this.freeBytes / (double)this.totalBytes);
        return freePct;
    }

    public long getFreeBytes() {
        return this.freeBytes;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public long getUsedBytes() {
        return this.getTotalBytes() - this.getFreeBytes();
    }

    public String toString() {
        return "[" + this.nodeId + "] free: " + this.getFreeBytes() + "[" + this.getFreeDiskAsPercentage() + "]";
    }
}

