/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.client.Client;
import org.elasticsearch.index.query.QueryBuilder;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.repository.RepositoryService;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.api.ElasticSearchIndexing;
import org.nuxeo.elasticsearch.api.ElasticSearchService;
import org.nuxeo.elasticsearch.commands.IndexingCommand;
import org.nuxeo.elasticsearch.config.ElasticSearchIndexConfig;
import org.nuxeo.elasticsearch.config.ElasticSearchLocalConfig;
import org.nuxeo.elasticsearch.config.ElasticSearchRemoteConfig;
import org.nuxeo.elasticsearch.core.ElasticSearchAdminImpl;
import org.nuxeo.elasticsearch.core.ElasticSearchIndexingImpl;
import org.nuxeo.elasticsearch.core.ElasticsearchServiceImpl;
import org.nuxeo.elasticsearch.query.NxQueryBuilder;
import org.nuxeo.elasticsearch.work.BaseIndexingWorker;
import org.nuxeo.elasticsearch.work.IndexingWorker;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class ElasticSearchComponent
extends DefaultComponent
implements ElasticSearchAdmin,
ElasticSearchIndexing,
ElasticSearchService {
    private static final String EP_REMOTE = "elasticSearchRemote";
    private static final String EP_LOCAL = "elasticSearchLocal";
    private static final String EP_INDEX = "elasticSearchIndex";
    private static final Log log = LogFactory.getLog(ElasticSearchComponent.class);
    private final Set<String> pendingWork = Collections.synchronizedSet(new HashSet());
    private final Set<String> pendingCommands = Collections.synchronizedSet(new HashSet());
    private final Map<String, ElasticSearchIndexConfig> indexConfig = new HashMap<String, ElasticSearchIndexConfig>();
    private final List<IndexingCommand> stackedCommands = new ArrayList<IndexingCommand>();
    private ElasticSearchLocalConfig localConfig;
    private ElasticSearchRemoteConfig remoteConfig;
    private ElasticSearchAdminImpl esa;
    private ElasticSearchIndexingImpl esi;
    private ElasticsearchServiceImpl ess;

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        switch (extensionPoint) {
            case "elasticSearchLocal": {
                ElasticSearchLocalConfig localContrib = (ElasticSearchLocalConfig)contribution;
                if (localContrib.isEnabled()) {
                    this.localConfig = localContrib;
                    this.remoteConfig = null;
                    log.info((Object)("Registering local embedded configuration: " + this.localConfig + ", loaded from " + contributor.getName()));
                    break;
                }
                if (this.localConfig == null) break;
                log.info((Object)("Disabling previous local embedded configuration, deactivated by " + contributor.getName()));
                this.localConfig = null;
                break;
            }
            case "elasticSearchRemote": {
                ElasticSearchRemoteConfig remoteContribution = (ElasticSearchRemoteConfig)contribution;
                if (remoteContribution.isEnabled()) {
                    this.remoteConfig = remoteContribution;
                    this.localConfig = null;
                    log.info((Object)("Registering remote configuration: " + this.remoteConfig + ", loaded from " + contributor.getName()));
                    break;
                }
                if (this.remoteConfig == null) break;
                log.info((Object)("Disabling previous remote configuration, deactivated by " + contributor.getName()));
                this.remoteConfig = null;
                break;
            }
            case "elasticSearchIndex": {
                ElasticSearchIndexConfig idx = (ElasticSearchIndexConfig)contribution;
                ElasticSearchIndexConfig previous = this.indexConfig.get(idx.getName());
                if (idx.isEnabled()) {
                    idx.merge(previous);
                    this.indexConfig.put(idx.getName(), idx);
                    log.info((Object)("Registering index configuration: " + idx + ", loaded from " + contributor.getName()));
                    break;
                }
                if (previous == null) break;
                log.info((Object)("Disabling index configuration: " + previous + ", deactivated by " + contributor.getName()));
                this.indexConfig.remove(idx.getName());
                break;
            }
            default: {
                throw new IllegalStateException("Invalid EP: " + extensionPoint);
            }
        }
    }

    public void applicationStarted(ComponentContext context) throws Exception {
        this.esa = new ElasticSearchAdminImpl(this.localConfig, this.remoteConfig, this.indexConfig);
        this.esi = new ElasticSearchIndexingImpl(this.esa);
        this.ess = new ElasticsearchServiceImpl(this.esa);
        this.processStackedCommands();
    }

    public void deactivate(ComponentContext context) throws Exception {
        if (this.esa != null) {
            this.esa.disconnect();
        }
    }

    public int getApplicationStartedOrder() {
        RepositoryService component = (RepositoryService)Framework.getRuntime().getComponent("org.nuxeo.ecm.core.repository.RepositoryService");
        return component.getApplicationStartedOrder() / 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processStackedCommands() {
        if (!this.stackedCommands.isEmpty()) {
            log.info((Object)String.format("Processing %d indexing commands stacked during startup", this.stackedCommands.size()));
            boolean txCreated = false;
            if (!TransactionHelper.isTransactionActive()) {
                txCreated = TransactionHelper.startTransaction();
            }
            try {
                for (final IndexingCommand cmd : this.stackedCommands) {
                    new UnrestrictedSessionRunner(cmd.getRepository()){

                        public void run() throws ClientException {
                            cmd.refresh(this.session);
                            ElasticSearchComponent.this.esi.indexNow(cmd);
                        }
                    }.runUnrestricted();
                }
            }
            catch (Exception e) {
                log.error((Object)("Unable to flush pending indexing commands: " + e.getMessage()), (Throwable)e);
            }
            finally {
                if (txCreated) {
                    TransactionHelper.commitOrRollbackTransaction();
                }
                this.stackedCommands.clear();
                log.debug((Object)"Done");
            }
        }
    }

    @Override
    public Client getClient() {
        return this.esa.getClient();
    }

    @Override
    public void initIndexes(boolean dropIfExists) {
        this.esa.initIndexes(dropIfExists);
    }

    @Override
    public void dropAndInitRepositoryIndex(String repositoryName) {
        this.esa.dropAndInitRepositoryIndex(repositoryName);
    }

    @Override
    public List<String> getRepositoryNames() {
        return this.esa.getRepositoryNames();
    }

    @Override
    public int getPendingDocs() {
        return this.pendingWork.size();
    }

    @Override
    public int getPendingCommands() {
        return this.pendingCommands.size() + BaseIndexingWorker.getRunningWorkers();
    }

    @Override
    public int getRunningCommands() {
        return this.esa.getRunningCommands();
    }

    @Override
    public int getTotalCommandProcessed() {
        return this.esa.getTotalCommandProcessed();
    }

    @Override
    public boolean isIndexingInProgress() {
        return this.getRunningCommands() > 0 || this.getPendingCommands() > 0;
    }

    @Override
    public void refresh() {
        this.esa.refresh();
    }

    @Override
    public void refreshRepositoryIndex(String repositoryName) {
        this.esa.refreshRepositoryIndex(repositoryName);
    }

    @Override
    public void flush() {
        this.esa.flush();
    }

    @Override
    public void flushRepositoryIndex(String repositoryName) {
        this.esa.flushRepositoryIndex(repositoryName);
    }

    @Override
    public void scheduleIndexing(IndexingCommand cmd) throws ClientException {
        String id = cmd.getDocId();
        if ("unknown".equals(id)) {
            return;
        }
        if (this.isAlreadyScheduled(cmd)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Skip indexing for " + cmd.toString() + " since it is already scheduled"));
            }
            return;
        }
        this.pendingCommands.add(cmd.getId());
        this.pendingWork.add(this.getWorkKey(cmd));
        if (cmd.isSync()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Schedule Sync PostCommit indexing request " + cmd.toString()));
            }
            this.schedulePostCommitIndexing(cmd);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Schedule Async indexing request  " + cmd.toString()));
            }
            WorkManager wm = (WorkManager)Framework.getLocalService(WorkManager.class);
            IndexingWorker idxWork = new IndexingWorker(cmd);
            wm.schedule((Work)idxWork, true);
        }
    }

    void schedulePostCommitIndexing(IndexingCommand cmd) throws ClientException {
        try {
            EventProducer evtProducer = (EventProducer)Framework.getLocalService(EventProducer.class);
            Event indexingEvent = cmd.asIndexingEvent();
            if (indexingEvent != null) {
                evtProducer.fireEvent(indexingEvent);
            }
        }
        catch (Exception e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    @Override
    public boolean isAlreadyScheduled(IndexingCommand cmd) {
        return this.pendingCommands.contains(cmd.getId()) || this.pendingWork.contains(this.getWorkKey(cmd));
    }

    @Override
    public void indexNow(IndexingCommand cmd) throws ClientException {
        if (!this.isReady()) {
            this.stackedCommands.add(cmd);
            log.debug((Object)"Delaying indexing command: Waiting for Index to be initialized.");
            return;
        }
        this.markCommandInProgress(cmd);
        this.esi.indexNow(cmd);
    }

    @Override
    public void indexNow(List<IndexingCommand> cmds) throws ClientException {
        if (!this.isReady()) {
            log.debug((Object)"Delaying indexing commands: Waiting for Index to be initialized.");
            this.stackedCommands.addAll(cmds);
            return;
        }
        this.markCommandInProgress(cmds);
        this.esi.indexNow(cmds);
    }

    @Override
    public void reindex(String repositoryName, String nxql) {
        this.esi.reindex(repositoryName, nxql);
    }

    @Override
    public DocumentModelList query(NxQueryBuilder queryBuilder) throws ClientException {
        return this.ess.query(queryBuilder);
    }

    @Override
    @Deprecated
    public DocumentModelList query(CoreSession session, String nxql, int limit, int offset, SortInfo ... sortInfos) throws ClientException {
        return this.ess.query(session, nxql, limit, offset, sortInfos);
    }

    @Override
    @Deprecated
    public DocumentModelList query(CoreSession session, QueryBuilder queryBuilder, int limit, int offset, SortInfo ... sortInfos) throws ClientException {
        return this.ess.query(session, queryBuilder, limit, offset, sortInfos);
    }

    private boolean isReady() {
        return this.esa != null && this.esa.isReady();
    }

    int markCommandInProgress(List<IndexingCommand> cmds) {
        int ret = 0;
        for (IndexingCommand cmd : cmds) {
            ret += this.markCommandInProgress(cmd);
        }
        return ret;
    }

    String getWorkKey(IndexingCommand cmd) {
        return cmd.getRepository() + ":" + cmd.getDocId() + ":" + cmd.isRecurse();
    }

    int markCommandInProgress(IndexingCommand cmd) {
        this.pendingWork.remove(this.getWorkKey(cmd));
        boolean isRemoved = this.pendingCommands.remove(cmd.getId());
        return isRemoved ? 1 : 0;
    }
}

