/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.config;

import java.io.File;
import java.io.Serializable;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.runtime.api.Framework;

@XObject(value="elasticSearchLocal")
public class ElasticSearchLocalConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XNode(value="@enabled")
    protected boolean isEnabled = true;
    @XNode(value="@clusterName")
    protected String clusterName;
    @XNode(value="@nodeName")
    protected String nodeName = "Nuxeo";
    @XNode(value="@pathData")
    protected String dataPath;
    @XNode(value="@indexStoreType")
    protected String indexStoreType;
    @XNode(value="@httpEnabled")
    protected boolean httpEnabled = false;

    public String getDataPath() {
        if (this.dataPath == null) {
            File dir = new File(Framework.getRuntime().getHome(), "data/elasticsearch");
            this.dataPath = dir.getPath();
        }
        return this.dataPath;
    }

    public void setDataPath(String dataPath) {
        this.dataPath = dataPath;
    }

    public String getIndexStorageType() {
        if (this.indexStoreType == null) {
            this.indexStoreType = Framework.isTestModeSet() ? "memory" : "mmapfs";
        }
        return this.indexStoreType;
    }

    public void setIndexStorageType(String indexStorageType) {
        this.indexStoreType = indexStorageType;
    }

    public boolean httpEnabled() {
        return this.httpEnabled;
    }

    public void setHttpEnabled(boolean httpEnabled) {
        this.httpEnabled = httpEnabled;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public String toString() {
        if (this.isEnabled()) {
            return String.format("EsLocalConfig(%s, %s, %s, %s)", this.getClusterName(), this.getDataPath(), this.httpEnabled(), this.getIndexStorageType());
        }
        return "EsLocalConfig disabled";
    }
}

