/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.work;

import java.util.concurrent.atomic.AtomicInteger;
import org.nuxeo.ecm.core.work.AbstractWork;

public abstract class BaseIndexingWorker
extends AbstractWork {
    private static final long serialVersionUID = 1L;
    private static final AtomicInteger pendingWorkerCount = new AtomicInteger(0);
    private static final AtomicInteger runningWorkerCount = new AtomicInteger(0);

    public static int getPendingWorkerCount() {
        return pendingWorkerCount.get();
    }

    public static int getRunningWorkerCount() {
        return runningWorkerCount.get();
    }

    public BaseIndexingWorker() {
        pendingWorkerCount.incrementAndGet();
    }

    public String getCategory() {
        return "elasticSearchIndexing";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retryableWork() throws Exception {
        runningWorkerCount.incrementAndGet();
        pendingWorkerCount.decrementAndGet();
        try {
            this.doWork();
        }
        finally {
            runningWorkerCount.decrementAndGet();
        }
    }

    protected abstract void doWork() throws Exception;
}

