/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.util.Map;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.search.SearchOperationThreading;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.internal.InternalClient;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.facet.FacetBuilder;
import org.elasticsearch.search.highlight.HighlightBuilder;
import org.elasticsearch.search.rescore.RescoreBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.search.suggest.SuggestBuilder;

public class SearchRequestBuilder
extends ActionRequestBuilder<SearchRequest, SearchResponse, SearchRequestBuilder> {
    private SearchSourceBuilder sourceBuilder;

    public SearchRequestBuilder(Client client) {
        super((InternalClient)client, new SearchRequest());
    }

    public SearchRequestBuilder setIndices(String ... indices) {
        ((SearchRequest)this.request).indices(indices);
        return this;
    }

    public SearchRequestBuilder setTypes(String ... types) {
        ((SearchRequest)this.request).types(types);
        return this;
    }

    public SearchRequestBuilder setSearchType(SearchType searchType) {
        ((SearchRequest)this.request).searchType(searchType);
        return this;
    }

    public SearchRequestBuilder setSearchType(String searchType) throws ElasticsearchIllegalArgumentException {
        ((SearchRequest)this.request).searchType(searchType);
        return this;
    }

    public SearchRequestBuilder setScroll(Scroll scroll) {
        ((SearchRequest)this.request).scroll(scroll);
        return this;
    }

    public SearchRequestBuilder setScroll(TimeValue keepAlive) {
        ((SearchRequest)this.request).scroll(keepAlive);
        return this;
    }

    public SearchRequestBuilder setScroll(String keepAlive) {
        ((SearchRequest)this.request).scroll(keepAlive);
        return this;
    }

    public SearchRequestBuilder setTimeout(TimeValue timeout) {
        this.sourceBuilder().timeout(timeout);
        return this;
    }

    public SearchRequestBuilder setTimeout(String timeout) {
        this.sourceBuilder().timeout(timeout);
        return this;
    }

    public SearchRequestBuilder setRouting(String routing) {
        ((SearchRequest)this.request).routing(routing);
        return this;
    }

    public SearchRequestBuilder setRouting(String ... routing) {
        ((SearchRequest)this.request).routing(routing);
        return this;
    }

    public SearchRequestBuilder setPreference(String preference) {
        ((SearchRequest)this.request).preference(preference);
        return this;
    }

    public SearchRequestBuilder setOperationThreading(SearchOperationThreading operationThreading) {
        ((SearchRequest)this.request).operationThreading(operationThreading);
        return this;
    }

    public SearchRequestBuilder setOperationThreading(String operationThreading) {
        ((SearchRequest)this.request).operationThreading(operationThreading);
        return this;
    }

    public SearchRequestBuilder setIndicesOptions(IndicesOptions indicesOptions) {
        this.request().indicesOptions(indicesOptions);
        return this;
    }

    public SearchRequestBuilder setQuery(QueryBuilder queryBuilder) {
        this.sourceBuilder().query(queryBuilder);
        return this;
    }

    public SearchRequestBuilder setQuery(String query) {
        this.sourceBuilder().query(query);
        return this;
    }

    public SearchRequestBuilder setQuery(BytesReference queryBinary) {
        this.sourceBuilder().query(queryBinary);
        return this;
    }

    public SearchRequestBuilder setQuery(byte[] queryBinary) {
        this.sourceBuilder().query(queryBinary);
        return this;
    }

    public SearchRequestBuilder setQuery(byte[] queryBinary, int queryBinaryOffset, int queryBinaryLength) {
        this.sourceBuilder().query(queryBinary, queryBinaryOffset, queryBinaryLength);
        return this;
    }

    public SearchRequestBuilder setQuery(XContentBuilder query) {
        this.sourceBuilder().query(query);
        return this;
    }

    public SearchRequestBuilder setQuery(Map query) {
        this.sourceBuilder().query(query);
        return this;
    }

    public SearchRequestBuilder setPostFilter(FilterBuilder postFilter) {
        this.sourceBuilder().postFilter(postFilter);
        return this;
    }

    public SearchRequestBuilder setPostFilter(String postFilter) {
        this.sourceBuilder().postFilter(postFilter);
        return this;
    }

    public SearchRequestBuilder setPostFilter(BytesReference postFilter) {
        this.sourceBuilder().postFilter(postFilter);
        return this;
    }

    public SearchRequestBuilder setPostFilter(byte[] postFilter) {
        this.sourceBuilder().postFilter(postFilter);
        return this;
    }

    public SearchRequestBuilder setPostFilter(byte[] postFilter, int postFilterOffset, int postFilterLength) {
        this.sourceBuilder().postFilter(postFilter, postFilterOffset, postFilterLength);
        return this;
    }

    public SearchRequestBuilder setPostFilter(XContentBuilder postFilter) {
        this.sourceBuilder().postFilter(postFilter);
        return this;
    }

    public SearchRequestBuilder setPostFilter(Map postFilter) {
        this.sourceBuilder().postFilter(postFilter);
        return this;
    }

    public SearchRequestBuilder setMinScore(float minScore) {
        this.sourceBuilder().minScore(minScore);
        return this;
    }

    public SearchRequestBuilder setFrom(int from) {
        this.sourceBuilder().from(from);
        return this;
    }

    public SearchRequestBuilder setSize(int size) {
        this.sourceBuilder().size(size);
        return this;
    }

    public SearchRequestBuilder setExplain(boolean explain) {
        this.sourceBuilder().explain(explain);
        return this;
    }

    public SearchRequestBuilder setVersion(boolean version) {
        this.sourceBuilder().version(version);
        return this;
    }

    public SearchRequestBuilder addIndexBoost(String index, float indexBoost) {
        this.sourceBuilder().indexBoost(index, indexBoost);
        return this;
    }

    public SearchRequestBuilder setStats(String ... statsGroups) {
        this.sourceBuilder().stats(statsGroups);
        return this;
    }

    public SearchRequestBuilder setNoFields() {
        this.sourceBuilder().noFields();
        return this;
    }

    public SearchRequestBuilder setFetchSource(boolean fetch) {
        this.sourceBuilder().fetchSource(fetch);
        return this;
    }

    public SearchRequestBuilder setFetchSource(@Nullable String include, @Nullable String exclude) {
        this.sourceBuilder().fetchSource(include, exclude);
        return this;
    }

    public SearchRequestBuilder setFetchSource(@Nullable String[] includes, @Nullable String[] excludes) {
        this.sourceBuilder().fetchSource(includes, excludes);
        return this;
    }

    public SearchRequestBuilder addField(String field) {
        this.sourceBuilder().field(field);
        return this;
    }

    public SearchRequestBuilder addFieldDataField(String name) {
        this.sourceBuilder().fieldDataField(name);
        return this;
    }

    public SearchRequestBuilder addScriptField(String name, String script) {
        this.sourceBuilder().scriptField(name, script);
        return this;
    }

    public SearchRequestBuilder addScriptField(String name, String script, Map<String, Object> params) {
        this.sourceBuilder().scriptField(name, script, params);
        return this;
    }

    @Deprecated
    public SearchRequestBuilder addPartialField(String name, @Nullable String include, @Nullable String exclude) {
        this.sourceBuilder().partialField(name, include, exclude);
        return this;
    }

    @Deprecated
    public SearchRequestBuilder addPartialField(String name, @Nullable String[] includes, @Nullable String[] excludes) {
        this.sourceBuilder().partialField(name, includes, excludes);
        return this;
    }

    public SearchRequestBuilder addScriptField(String name, String lang, String script, Map<String, Object> params) {
        this.sourceBuilder().scriptField(name, lang, script, params);
        return this;
    }

    public SearchRequestBuilder addSort(String field, SortOrder order) {
        this.sourceBuilder().sort(field, order);
        return this;
    }

    public SearchRequestBuilder addSort(SortBuilder sort) {
        this.sourceBuilder().sort(sort);
        return this;
    }

    public SearchRequestBuilder setTrackScores(boolean trackScores) {
        this.sourceBuilder().trackScores(trackScores);
        return this;
    }

    public SearchRequestBuilder addFields(String ... fields) {
        this.sourceBuilder().fields(fields);
        return this;
    }

    public SearchRequestBuilder addFacet(FacetBuilder facet) {
        this.sourceBuilder().facet(facet);
        return this;
    }

    public SearchRequestBuilder setFacets(BytesReference facets) {
        this.sourceBuilder().facets(facets);
        return this;
    }

    public SearchRequestBuilder setFacets(byte[] facets) {
        this.sourceBuilder().facets(facets);
        return this;
    }

    public SearchRequestBuilder setFacets(byte[] facets, int facetsOffset, int facetsLength) {
        this.sourceBuilder().facets(facets, facetsOffset, facetsLength);
        return this;
    }

    public SearchRequestBuilder setFacets(XContentBuilder facets) {
        this.sourceBuilder().facets(facets);
        return this;
    }

    public SearchRequestBuilder setFacets(Map facets) {
        this.sourceBuilder().facets(facets);
        return this;
    }

    public SearchRequestBuilder addAggregation(AbstractAggregationBuilder aggregation) {
        this.sourceBuilder().aggregation(aggregation);
        return this;
    }

    public SearchRequestBuilder setAggregations(BytesReference aggregations) {
        this.sourceBuilder().aggregations(aggregations);
        return this;
    }

    public SearchRequestBuilder setAggregations(byte[] aggregations) {
        this.sourceBuilder().aggregations(aggregations);
        return this;
    }

    public SearchRequestBuilder setAggregations(byte[] aggregations, int aggregationsOffset, int aggregationsLength) {
        this.sourceBuilder().facets(aggregations, aggregationsOffset, aggregationsLength);
        return this;
    }

    public SearchRequestBuilder setAggregations(XContentBuilder aggregations) {
        this.sourceBuilder().aggregations(aggregations);
        return this;
    }

    public SearchRequestBuilder setAggregations(Map aggregations) {
        this.sourceBuilder().aggregations(aggregations);
        return this;
    }

    public SearchRequestBuilder addHighlightedField(String name) {
        this.highlightBuilder().field(name);
        return this;
    }

    public SearchRequestBuilder addHighlightedField(String name, int fragmentSize) {
        this.highlightBuilder().field(name, fragmentSize);
        return this;
    }

    public SearchRequestBuilder addHighlightedField(String name, int fragmentSize, int numberOfFragments) {
        this.highlightBuilder().field(name, fragmentSize, numberOfFragments);
        return this;
    }

    public SearchRequestBuilder addHighlightedField(String name, int fragmentSize, int numberOfFragments, int fragmentOffset) {
        this.highlightBuilder().field(name, fragmentSize, numberOfFragments, fragmentOffset);
        return this;
    }

    public SearchRequestBuilder addHighlightedField(HighlightBuilder.Field field) {
        this.highlightBuilder().field(field);
        return this;
    }

    public SearchRequestBuilder setHighlighterTagsSchema(String schemaName) {
        this.highlightBuilder().tagsSchema(schemaName);
        return this;
    }

    public SearchRequestBuilder setHighlighterPreTags(String ... preTags) {
        this.highlightBuilder().preTags(preTags);
        return this;
    }

    public SearchRequestBuilder setHighlighterPostTags(String ... postTags) {
        this.highlightBuilder().postTags(postTags);
        return this;
    }

    public SearchRequestBuilder setHighlighterOrder(String order) {
        this.highlightBuilder().order(order);
        return this;
    }

    public SearchRequestBuilder setHighlighterEncoder(String encoder) {
        this.highlightBuilder().encoder(encoder);
        return this;
    }

    public SearchRequestBuilder setHighlighterQuery(QueryBuilder highlightQuery) {
        this.highlightBuilder().highlightQuery(highlightQuery);
        return this;
    }

    public SearchRequestBuilder setHighlighterRequireFieldMatch(boolean requireFieldMatch) {
        this.highlightBuilder().requireFieldMatch(requireFieldMatch);
        return this;
    }

    public SearchRequestBuilder setHighlighterType(String type) {
        this.highlightBuilder().highlighterType(type);
        return this;
    }

    public SearchRequestBuilder setHighlighterNoMatchSize(Integer noMatchSize) {
        this.highlightBuilder().noMatchSize(noMatchSize);
        return this;
    }

    public SearchRequestBuilder setHighlighterOptions(Map<String, Object> options) {
        this.highlightBuilder().options(options);
        return this;
    }

    public SearchRequestBuilder setSuggestText(String globalText) {
        this.suggestBuilder().setText(globalText);
        return this;
    }

    public SearchRequestBuilder addSuggestion(SuggestBuilder.SuggestionBuilder<?> suggestion) {
        this.suggestBuilder().addSuggestion(suggestion);
        return this;
    }

    public SearchRequestBuilder setRescorer(RescoreBuilder.Rescorer rescorer) {
        this.sourceBuilder().clearRescorers();
        return this.addRescorer(rescorer);
    }

    public SearchRequestBuilder setRescorer(RescoreBuilder.Rescorer rescorer, int window) {
        this.sourceBuilder().clearRescorers();
        return this.addRescorer(rescorer, window);
    }

    public SearchRequestBuilder addRescorer(RescoreBuilder.Rescorer rescorer) {
        this.sourceBuilder().addRescorer(new RescoreBuilder().rescorer(rescorer));
        return this;
    }

    public SearchRequestBuilder addRescorer(RescoreBuilder.Rescorer rescorer, int window) {
        this.sourceBuilder().addRescorer(new RescoreBuilder().rescorer(rescorer).windowSize(window));
        return this;
    }

    public SearchRequestBuilder clearRescorers() {
        this.sourceBuilder().clearRescorers();
        return this;
    }

    public SearchRequestBuilder setRescoreWindow(int window) {
        this.sourceBuilder().defaultRescoreWindowSize(window);
        return this;
    }

    public SearchRequestBuilder setSource(String source) {
        ((SearchRequest)this.request).source(source);
        return this;
    }

    public SearchRequestBuilder setExtraSource(String source) {
        ((SearchRequest)this.request).extraSource(source);
        return this;
    }

    public SearchRequestBuilder setSource(BytesReference source) {
        ((SearchRequest)this.request).source(source, false);
        return this;
    }

    public SearchRequestBuilder setSource(BytesReference source, boolean unsafe) {
        ((SearchRequest)this.request).source(source, unsafe);
        return this;
    }

    public SearchRequestBuilder setSource(byte[] source) {
        ((SearchRequest)this.request).source(source);
        return this;
    }

    public SearchRequestBuilder setExtraSource(BytesReference source) {
        ((SearchRequest)this.request).extraSource(source, false);
        return this;
    }

    public SearchRequestBuilder setExtraSource(BytesReference source, boolean unsafe) {
        ((SearchRequest)this.request).extraSource(source, unsafe);
        return this;
    }

    public SearchRequestBuilder setExtraSource(byte[] source) {
        ((SearchRequest)this.request).extraSource(source);
        return this;
    }

    public SearchRequestBuilder setSource(byte[] source, int offset, int length) {
        ((SearchRequest)this.request).source(source, offset, length);
        return this;
    }

    public SearchRequestBuilder setExtraSource(byte[] source, int offset, int length) {
        ((SearchRequest)this.request).extraSource(source, offset, length);
        return this;
    }

    public SearchRequestBuilder setSource(XContentBuilder builder) {
        ((SearchRequest)this.request).source(builder);
        return this;
    }

    public SearchRequestBuilder setExtraSource(XContentBuilder builder) {
        ((SearchRequest)this.request).extraSource(builder);
        return this;
    }

    public SearchRequestBuilder setSource(Map source) {
        ((SearchRequest)this.request).source(source);
        return this;
    }

    public SearchRequestBuilder setExtraSource(Map source) {
        ((SearchRequest)this.request).extraSource(source);
        return this;
    }

    public SearchRequestBuilder setTemplateName(String templateName) {
        ((SearchRequest)this.request).templateName(templateName);
        return this;
    }

    public SearchRequestBuilder setTemplateParams(Map<String, String> templateParams) {
        ((SearchRequest)this.request).templateParams(templateParams);
        return this;
    }

    public SearchRequestBuilder setTemplateSource(String source) {
        ((SearchRequest)this.request).templateSource(source);
        return this;
    }

    public SearchRequestBuilder setTemplateSource(BytesReference source) {
        ((SearchRequest)this.request).templateSource(source, true);
        return this;
    }

    public SearchRequestBuilder internalBuilder(SearchSourceBuilder sourceBuilder) {
        this.sourceBuilder = sourceBuilder;
        return this;
    }

    public SearchSourceBuilder internalBuilder() {
        return this.sourceBuilder();
    }

    public String toString() {
        return this.internalBuilder().toString();
    }

    @Override
    public SearchRequest request() {
        if (this.sourceBuilder != null) {
            ((SearchRequest)this.request).source(this.sourceBuilder());
        }
        return (SearchRequest)this.request;
    }

    @Override
    protected void doExecute(ActionListener<SearchResponse> listener) {
        if (this.sourceBuilder != null) {
            ((SearchRequest)this.request).source(this.sourceBuilder());
        }
        ((Client)((Object)this.client)).search((SearchRequest)this.request, listener);
    }

    private SearchSourceBuilder sourceBuilder() {
        if (this.sourceBuilder == null) {
            this.sourceBuilder = new SearchSourceBuilder();
        }
        return this.sourceBuilder;
    }

    private HighlightBuilder highlightBuilder() {
        return this.sourceBuilder().highlighter();
    }

    private SuggestBuilder suggestBuilder() {
        return this.sourceBuilder().suggest();
    }
}

