/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.flush;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class FlushStats
implements Streamable,
ToXContent {
    private long total;
    private long totalTimeInMillis;

    public FlushStats() {
    }

    public FlushStats(long total, long totalTimeInMillis) {
        this.total = total;
        this.totalTimeInMillis = totalTimeInMillis;
    }

    public void add(long total, long totalTimeInMillis) {
        this.total += total;
        this.totalTimeInMillis += totalTimeInMillis;
    }

    public void add(FlushStats flushStats) {
        if (flushStats == null) {
            return;
        }
        this.total += flushStats.total;
        this.totalTimeInMillis += flushStats.totalTimeInMillis;
    }

    public long getTotal() {
        return this.total;
    }

    public long getTotalTimeInMillis() {
        return this.totalTimeInMillis;
    }

    public TimeValue getTotalTime() {
        return new TimeValue(this.totalTimeInMillis);
    }

    public static FlushStats readFlushStats(StreamInput in) throws IOException {
        FlushStats flushStats = new FlushStats();
        flushStats.readFrom(in);
        return flushStats;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.FLUSH);
        builder.field(Fields.TOTAL, this.total);
        builder.timeValueField(Fields.TOTAL_TIME_IN_MILLIS, Fields.TOTAL_TIME, this.totalTimeInMillis);
        builder.endObject();
        return builder;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.total = in.readVLong();
        this.totalTimeInMillis = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.total);
        out.writeVLong(this.totalTimeInMillis);
    }

    static final class Fields {
        static final XContentBuilderString FLUSH = new XContentBuilderString("flush");
        static final XContentBuilderString TOTAL = new XContentBuilderString("total");
        static final XContentBuilderString TOTAL_TIME = new XContentBuilderString("total_time");
        static final XContentBuilderString TOTAL_TIME_IN_MILLIS = new XContentBuilderString("total_time_in_millis");

        Fields() {
        }
    }
}

