/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.action.support.master.MasterNodeOperationRequest;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.TimeoutClusterStateUpdateTask;
import org.elasticsearch.cluster.action.index.NodeIndexDeletedAction;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.metadata.MetaDataService;
import org.elasticsearch.cluster.metadata.ProcessClusterEventTimeoutException;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.threadpool.ThreadPool;

public class MetaDataDeleteIndexService
extends AbstractComponent {
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final AllocationService allocationService;
    private final NodeIndexDeletedAction nodeIndexDeletedAction;
    private final MetaDataService metaDataService;

    @Inject
    public MetaDataDeleteIndexService(Settings settings, ThreadPool threadPool, ClusterService clusterService, AllocationService allocationService, NodeIndexDeletedAction nodeIndexDeletedAction, MetaDataService metaDataService) {
        super(settings);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.allocationService = allocationService;
        this.nodeIndexDeletedAction = nodeIndexDeletedAction;
        this.metaDataService = metaDataService;
    }

    public void deleteIndex(final Request request, final Listener userListener) {
        final Semaphore mdLock = this.metaDataService.indexMetaDataLock(request.index);
        if (mdLock.tryAcquire()) {
            this.deleteIndex(request, userListener, mdLock);
            return;
        }
        this.threadPool.executor("management").execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!mdLock.tryAcquire(request.masterTimeout.nanos(), TimeUnit.NANOSECONDS)) {
                        userListener.onFailure(new ProcessClusterEventTimeoutException(request.masterTimeout, "acquire index lock"));
                        return;
                    }
                }
                catch (InterruptedException e) {
                    userListener.onFailure(e);
                    return;
                }
                MetaDataDeleteIndexService.this.deleteIndex(request, userListener, mdLock);
            }
        });
    }

    private void deleteIndex(final Request request, Listener userListener, Semaphore mdLock) {
        final DeleteIndexListener listener = new DeleteIndexListener(mdLock, userListener);
        this.clusterService.submitStateUpdateTask("delete-index [" + request.index + "]", Priority.URGENT, new TimeoutClusterStateUpdateTask(){

            @Override
            public TimeValue timeout() {
                return request.masterTimeout;
            }

            @Override
            public void onFailure(String source, Throwable t) {
                listener.onFailure(t);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                if (!currentState.metaData().hasConcreteIndex(request.index)) {
                    throw new IndexMissingException(new Index(request.index));
                }
                MetaDataDeleteIndexService.this.logger.info("[{}] deleting index", request.index);
                RoutingTable.Builder routingTableBuilder = RoutingTable.builder(currentState.routingTable());
                routingTableBuilder.remove(request.index);
                MetaData newMetaData = MetaData.builder(currentState.metaData()).remove(request.index).build();
                RoutingAllocation.Result routingResult = MetaDataDeleteIndexService.this.allocationService.reroute(ClusterState.builder(currentState).routingTable(routingTableBuilder).metaData(newMetaData).build());
                ClusterBlocks blocks = ClusterBlocks.builder().blocks(currentState.blocks()).removeIndexBlocks(request.index).build();
                int count = currentState.nodes().size();
                final AtomicInteger counter = new AtomicInteger(count += currentState.nodes().dataNodes().size());
                final NodeIndexDeletedAction.Listener nodeIndexDeleteListener = new NodeIndexDeletedAction.Listener(){

                    @Override
                    public void onNodeIndexDeleted(String index, String nodeId) {
                        if (index.equals(request.index) && counter.decrementAndGet() == 0) {
                            listener.onResponse(new Response(true));
                            MetaDataDeleteIndexService.this.nodeIndexDeletedAction.remove(this);
                        }
                    }

                    @Override
                    public void onNodeIndexStoreDeleted(String index, String nodeId) {
                        if (index.equals(request.index) && counter.decrementAndGet() == 0) {
                            listener.onResponse(new Response(true));
                            MetaDataDeleteIndexService.this.nodeIndexDeletedAction.remove(this);
                        }
                    }
                };
                MetaDataDeleteIndexService.this.nodeIndexDeletedAction.add(nodeIndexDeleteListener);
                listener.future = MetaDataDeleteIndexService.this.threadPool.schedule(request.timeout, "same", new Runnable(){

                    @Override
                    public void run() {
                        listener.onResponse(new Response(false));
                        MetaDataDeleteIndexService.this.nodeIndexDeletedAction.remove(nodeIndexDeleteListener);
                    }
                });
                return ClusterState.builder(currentState).routingResult(routingResult).metaData(newMetaData).blocks(blocks).build();
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
            }
        });
    }

    public static class Response {
        private final boolean acknowledged;

        public Response(boolean acknowledged) {
            this.acknowledged = acknowledged;
        }

        public boolean acknowledged() {
            return this.acknowledged;
        }
    }

    public static class Request {
        final String index;
        TimeValue timeout = TimeValue.timeValueSeconds(10L);
        TimeValue masterTimeout = MasterNodeOperationRequest.DEFAULT_MASTER_NODE_TIMEOUT;

        public Request(String index) {
            this.index = index;
        }

        public Request timeout(TimeValue timeout) {
            this.timeout = timeout;
            return this;
        }

        public Request masterTimeout(TimeValue masterTimeout) {
            this.masterTimeout = masterTimeout;
            return this;
        }
    }

    public static interface Listener {
        public void onResponse(Response var1);

        public void onFailure(Throwable var1);
    }

    class DeleteIndexListener
    implements Listener {
        private final AtomicBoolean notified = new AtomicBoolean();
        private final Semaphore mdLock;
        private final Listener listener;
        volatile ScheduledFuture<?> future;

        private DeleteIndexListener(Semaphore mdLock, Listener listener) {
            this.mdLock = mdLock;
            this.listener = listener;
        }

        @Override
        public void onResponse(Response response) {
            if (this.notified.compareAndSet(false, true)) {
                this.mdLock.release();
                if (this.future != null) {
                    this.future.cancel(false);
                }
                this.listener.onResponse(response);
            }
        }

        @Override
        public void onFailure(Throwable t) {
            if (this.notified.compareAndSet(false, true)) {
                this.mdLock.release();
                if (this.future != null) {
                    this.future.cancel(false);
                }
                this.listener.onFailure(t);
            }
        }
    }
}

