/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.merge;

import java.io.IOException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergeScheduler;

public class EnableMergeScheduler
extends MergeScheduler {
    private final MergeScheduler mergeScheduler;
    private final ThreadLocal<Boolean> enabled = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };

    public EnableMergeScheduler(MergeScheduler mergeScheduler) {
        this.mergeScheduler = mergeScheduler;
    }

    void enableMerge() {
        assert (!this.enabled.get().booleanValue());
        this.enabled.set(Boolean.TRUE);
    }

    void disableMerge() {
        assert (this.enabled.get().booleanValue());
        this.enabled.set(Boolean.FALSE);
    }

    public void merge(IndexWriter writer) throws IOException {
        if (this.enabled.get().booleanValue()) {
            this.mergeScheduler.merge(writer);
        }
    }

    public void close() throws IOException {
        this.mergeScheduler.close();
    }

    public MergeScheduler clone() {
        return this;
    }
}

