/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.commands;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.elasticsearch.commands.IndexingCommand;

public class IndexingCommands {
    protected final List<IndexingCommand> commands = new ArrayList<IndexingCommand>();
    protected final List<String> commandNames = new ArrayList<String>();
    protected DocumentModel targetDocument;
    protected static final Log log = LogFactory.getLog(IndexingCommands.class);

    protected IndexingCommands() {
    }

    public IndexingCommands(DocumentModel targetDocument) {
        this.targetDocument = targetDocument;
    }

    public IndexingCommand add(String command, boolean sync, boolean recurse) {
        IndexingCommand cmd;
        if (sync && recurse) {
            cmd = new IndexingCommand(this.targetDocument, command, true, false);
            this.add(cmd);
            cmd = new IndexingCommand(this.targetDocument, command, false, true);
        } else {
            cmd = new IndexingCommand(this.targetDocument, command, sync, recurse);
        }
        return this.add(cmd);
    }

    protected IndexingCommand find(String command) {
        for (IndexingCommand cmd : this.commands) {
            if (!cmd.name.equals(command)) continue;
            return cmd;
        }
        return null;
    }

    public IndexingCommand add(IndexingCommand command) {
        if (command == null) {
            return null;
        }
        if (this.commandNames.contains(command.name)) {
            IndexingCommand existing = this.find(command.name);
            if (existing.canBeMerged(command)) {
                existing.merge(command);
                return null;
            }
        } else if (this.commandNames.contains("ESIndex")) {
            if (command.name.equals("ESUnIndex")) {
                this.clear();
            } else if (command.isSync()) {
                this.find("ESIndex").makeSync();
            }
            return null;
        }
        if (command.name.equals("ESUnIndex")) {
            this.clear();
        }
        this.commands.add(command);
        this.commandNames.add(command.name);
        return command;
    }

    protected void clear() {
        this.commands.clear();
        this.commandNames.clear();
    }

    public DocumentModel getTargetDocument() {
        return this.targetDocument;
    }

    public boolean contains(String command) {
        return this.commandNames.contains(command);
    }

    public String toJSON() throws IOException {
        StringWriter out = new StringWriter();
        JsonFactory factory = new JsonFactory();
        JsonGenerator jsonGen = factory.createJsonGenerator((Writer)out);
        jsonGen.writeStartArray();
        for (IndexingCommand cmd : this.commands) {
            cmd.toJSON(jsonGen);
        }
        jsonGen.writeEndArray();
        out.flush();
        jsonGen.close();
        return out.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IndexingCommands fromJSON(CoreSession session, String json) throws ClientException {
        IndexingCommands indexingCommands;
        JsonFactory jsonFactory = new JsonFactory();
        JsonParser jp = jsonFactory.createJsonParser(json);
        try {
            indexingCommands = IndexingCommands.fromJSON(session, jp);
        }
        catch (Throwable throwable) {
            try {
                jp.close();
                throw throwable;
            }
            catch (Exception e) {
                throw ClientException.wrap((Throwable)e);
            }
        }
        jp.close();
        return indexingCommands;
    }

    public static IndexingCommands fromJSON(CoreSession session, JsonParser jp) throws Exception {
        IndexingCommand cmd;
        IndexingCommands cmds = new IndexingCommands();
        JsonToken token = jp.nextToken();
        if (token != JsonToken.START_ARRAY) {
            return null;
        }
        while (token != JsonToken.END_ARRAY && (cmd = IndexingCommand.fromJSON(session, jp)) != null) {
            cmds.add(cmd);
        }
        return cmds;
    }

    public List<IndexingCommand> getCommands() {
        return this.commands;
    }
}

