/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mustache.codes;

import java.io.Writer;
import org.elasticsearch.common.mustache.Code;
import org.elasticsearch.common.mustache.DefaultMustacheFactory;
import org.elasticsearch.common.mustache.Mustache;
import org.elasticsearch.common.mustache.TemplateContext;
import org.elasticsearch.common.mustache.codes.DefaultCode;

public class DefaultMustache
extends DefaultCode
implements Mustache {
    private Code[] codes;
    private boolean inited = false;

    public DefaultMustache(TemplateContext tc, DefaultMustacheFactory df, Code[] codes, String name) {
        super(tc, df, null, name, null);
        this.setCodes(codes);
    }

    @Override
    public Code[] getCodes() {
        return this.codes;
    }

    @Override
    public Writer run(Writer writer, Object[] scopes) {
        if (this.codes != null) {
            for (Code code : this.codes) {
                writer = code.execute(writer, scopes);
            }
        }
        return writer;
    }

    @Override
    public void setCodes(Code[] newcodes) {
        this.codes = newcodes;
    }

    @Override
    public void identity(Writer writer) {
        this.runIdentity(writer);
    }

    @Override
    public synchronized void init() {
        if (!this.inited) {
            this.inited = true;
            super.init();
        }
    }
}

