/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.util;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Queue;
import org.elasticsearch.common.mvel2.CompileException;
import org.elasticsearch.common.mvel2.ParserContext;
import org.elasticsearch.common.mvel2.ast.EndOfStatement;
import org.elasticsearch.common.mvel2.ast.Proto;
import org.elasticsearch.common.mvel2.compiler.ExecutableStatement;
import org.elasticsearch.common.mvel2.util.ExecutionStack;
import org.elasticsearch.common.mvel2.util.FunctionParser;
import org.elasticsearch.common.mvel2.util.ParseTools;

public class ProtoParser {
    private char[] expr;
    private ParserContext pCtx;
    private int endOffset;
    private int cursor;
    private String protoName;
    String tk1 = null;
    String tk2 = null;
    private Class type;
    private String name;
    private String deferredName;
    private boolean interpreted = false;
    private ExecutionStack splitAccumulator;
    private static ThreadLocal<Queue<DeferredTypeResolve>> deferred = new ThreadLocal();

    public ProtoParser(char[] expr, int offset, int offsetEnd, String protoName, ParserContext pCtx, int fields, ExecutionStack splitAccumulator) {
        this.expr = expr;
        this.cursor = offset;
        this.endOffset = offsetEnd;
        this.protoName = protoName;
        this.pCtx = pCtx;
        this.interpreted = (0x10 & fields) == 0;
        this.splitAccumulator = splitAccumulator;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Proto parse() {
        Proto proto = new Proto(this.protoName, this.pCtx);
        block8: while (this.cursor < this.endOffset) {
            int start = this.cursor = ParseTools.skipWhitespace(this.expr, this.cursor);
            if (this.tk2 == null) {
                while (this.cursor < this.endOffset && ParseTools.isIdentifierPart(this.expr[this.cursor])) {
                    ++this.cursor;
                }
                if (this.cursor > start) {
                    this.tk1 = new String(this.expr, start, this.cursor - start);
                    if ("def".equals(this.tk1) || "function".equals(this.tk1)) {
                        ++this.cursor;
                        start = this.cursor = ParseTools.skipWhitespace(this.expr, this.cursor);
                        while (this.cursor < this.endOffset && ParseTools.isIdentifierPart(this.expr[this.cursor])) {
                            ++this.cursor;
                        }
                        if (start == this.cursor) {
                            throw new CompileException("attempt to declare an anonymous function as a prototype member", this.expr, start);
                        }
                        FunctionParser parser = new FunctionParser(new String(this.expr, start, this.cursor - start), this.cursor, this.endOffset, this.expr, 0, this.pCtx, null);
                        proto.declareReceiver(parser.getName(), parser.parse());
                        this.cursor = parser.getCursor() + 1;
                        this.tk1 = null;
                        continue;
                    }
                }
                this.cursor = ParseTools.skipWhitespace(this.expr, this.cursor);
            }
            if (this.cursor > this.endOffset) {
                throw new CompileException("unexpected end of statement in proto declaration: " + this.protoName, this.expr, start);
            }
            switch (this.expr[this.cursor]) {
                case ';': {
                    ++this.cursor;
                    this.calculateDecl();
                    if (this.interpreted && this.type == DeferredTypeResolve.class) {
                        this.enqueueReceiverForLateResolution(this.deferredName, proto.declareReceiver(this.name, Proto.ReceiverType.DEFERRED, null), null);
                        continue block8;
                    }
                    proto.declareReceiver(this.name, this.type, null);
                    continue block8;
                }
                case '=': {
                    ++this.cursor;
                    start = this.cursor = ParseTools.skipWhitespace(this.expr, this.cursor);
                    block11: while (this.cursor < this.endOffset) {
                        switch (this.expr[this.cursor]) {
                            case '\"': 
                            case '\'': 
                            case '(': 
                            case '[': 
                            case '{': {
                                this.cursor = ParseTools.balancedCaptureWithLineAccounting(this.expr, this.cursor, this.endOffset, this.expr[this.cursor], this.pCtx);
                                break;
                            }
                            case ';': {
                                break block11;
                            }
                        }
                        ++this.cursor;
                    }
                    this.calculateDecl();
                    String initString = new String(this.expr, start, this.cursor++ - start);
                    if (this.interpreted && this.type == DeferredTypeResolve.class) {
                        this.enqueueReceiverForLateResolution(this.deferredName, proto.declareReceiver(this.name, Proto.ReceiverType.DEFERRED, null), initString);
                        continue block8;
                    }
                    proto.declareReceiver(this.name, this.type, (ExecutableStatement)ParseTools.subCompileExpression(initString, this.pCtx));
                    continue block8;
                }
            }
            start = this.cursor;
            while (this.cursor < this.endOffset && ParseTools.isIdentifierPart(this.expr[this.cursor])) {
                ++this.cursor;
            }
            if (this.cursor <= start) continue;
            this.tk2 = new String(this.expr, start, this.cursor - start);
        }
        ++this.cursor;
        if (this.splitAccumulator != null && ParseTools.isStatementNotManuallyTerminated(this.expr, this.cursor)) {
            this.splitAccumulator.add(new EndOfStatement(this.pCtx));
        }
        return proto;
    }

    private void calculateDecl() {
        if (this.tk2 != null) {
            try {
                this.type = this.pCtx.hasProtoImport(this.tk1) ? Proto.class : ParseTools.findClass(null, this.tk1, this.pCtx);
                this.name = this.tk2;
            }
            catch (ClassNotFoundException e) {
                if (this.interpreted) {
                    this.type = DeferredTypeResolve.class;
                    this.deferredName = this.tk1;
                    this.name = this.tk2;
                }
                throw new CompileException("could not resolve class: " + this.tk1, this.expr, this.cursor, e);
            }
        } else {
            this.type = Object.class;
            this.name = this.tk1;
        }
        this.tk1 = null;
        this.tk2 = null;
    }

    private void enqueueReceiverForLateResolution(final String name, final Proto.Receiver receiver, final String initializer) {
        Queue<DeferredTypeResolve> recv = deferred.get();
        if (recv == null) {
            recv = new LinkedList<DeferredTypeResolve>();
            deferred.set(recv);
        }
        recv.add(new DeferredTypeResolve(){

            public boolean isWaitingFor(Proto proto) {
                if (name.equals(proto.getName())) {
                    receiver.setType(Proto.ReceiverType.PROPERTY);
                    receiver.setInitValue((ExecutableStatement)ParseTools.subCompileExpression(initializer, ProtoParser.this.pCtx));
                    return true;
                }
                return false;
            }

            public String getName() {
                return name;
            }
        });
    }

    public static void notifyForLateResolution(Proto proto) {
        if (deferred.get() != null) {
            Queue<DeferredTypeResolve> recv = deferred.get();
            HashSet<DeferredTypeResolve> remove = new HashSet<DeferredTypeResolve>();
            for (DeferredTypeResolve r : recv) {
                if (!r.isWaitingFor(proto)) continue;
                remove.add(r);
            }
            for (DeferredTypeResolve r : remove) {
                recv.remove(r);
            }
        }
    }

    public int getCursor() {
        return this.cursor;
    }

    public static void checkForPossibleUnresolvedViolations(char[] expr, int cursor, ParserContext pCtx) {
        LinkedHashMap imports;
        Object o;
        if (ProtoParser.isUnresolvedWaiting() && (o = (imports = (LinkedHashMap)pCtx.getParserConfiguration().getImports()).values().toArray()[imports.size() - 1]) instanceof Proto) {
            Proto proto = (Proto)o;
            int last = proto.getCursorEnd();
            --cursor;
            while (cursor > last && ParseTools.isWhitespace(expr[cursor])) {
                --cursor;
            }
            while (cursor > last && ParseTools.isIdentifierPart(expr[cursor])) {
                --cursor;
            }
            while (cursor > last && (ParseTools.isWhitespace(expr[cursor]) || expr[cursor] == ';')) {
                --cursor;
            }
            if (cursor != last) {
                throw new CompileException("unresolved reference (possible illegal forward-reference?): " + ProtoParser.getNextUnresolvedWaiting(), expr, proto.getCursorStart());
            }
        }
    }

    public static boolean isUnresolvedWaiting() {
        return deferred.get() != null && !deferred.get().isEmpty();
    }

    public static String getNextUnresolvedWaiting() {
        if (deferred.get() != null && !deferred.get().isEmpty()) {
            return deferred.get().poll().getName();
        }
        return null;
    }

    private static interface DeferredTypeResolve {
        public boolean isWaitingFor(Proto var1);

        public String getName();
    }
}

