/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.Timer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.action.admin.indices.status.IndicesStatusRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.deletebyquery.DeleteByQueryRequestBuilder;
import org.elasticsearch.action.deletebyquery.DeleteByQueryResponse;
import org.elasticsearch.action.deletebyquery.IndexDeleteByQueryResponse;
import org.elasticsearch.action.get.GetRequestBuilder;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.NoNodeAvailableException;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.query.AndFilterBuilder;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.sort.SortBuilder;
import org.nuxeo.ecm.automation.jaxrs.io.documents.JsonESDocumentWriter;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.query.sql.NXQL;
import org.nuxeo.ecm.core.security.SecurityService;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.api.ElasticSearchIndexing;
import org.nuxeo.elasticsearch.api.ElasticSearchService;
import org.nuxeo.elasticsearch.commands.IndexingCommand;
import org.nuxeo.elasticsearch.config.ElasticSearchIndexConfig;
import org.nuxeo.elasticsearch.config.ElasticSearchLocalConfig;
import org.nuxeo.elasticsearch.config.ElasticSearchRemoteConfig;
import org.nuxeo.elasticsearch.io.DocumentModelReaders;
import org.nuxeo.elasticsearch.query.NxQueryBuilder;
import org.nuxeo.elasticsearch.work.ChildrenIndexingWorker;
import org.nuxeo.elasticsearch.work.IndexingWorker;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.metrics.MetricsService;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class ElasticSearchComponent
extends DefaultComponent
implements ElasticSearchService,
ElasticSearchIndexing,
ElasticSearchAdmin {
    public static final String EP_REMOTE = "elasticSearchRemote";
    public static final String EP_LOCAL = "elasticSearchLocal";
    public static final String EP_INDEX = "elasticSearchIndex";
    public static final String ID_FIELD = "_id";
    private static final Log log = LogFactory.getLog(ElasticSearchComponent.class);
    protected final List<IndexingCommand> stackedCommands = new ArrayList<IndexingCommand>();
    protected final Map<String, String> indexNames = new HashMap<String, String>();
    protected final Set<String> pendingWork = Collections.synchronizedSet(new HashSet());
    protected final Set<String> pendingCommands = Collections.synchronizedSet(new HashSet());
    protected final Map<String, ElasticSearchIndexConfig> indexes = new HashMap<String, ElasticSearchIndexConfig>();
    protected final MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
    private final AtomicInteger totalCommandProcessed = new AtomicInteger(0);
    private final AtomicInteger totalCommandRunning = new AtomicInteger(0);
    protected Node localNode;
    protected Client client;
    protected boolean indexInitDone = false;
    protected Timer searchTimer;
    protected Timer fetchTimer;
    protected Timer deleteTimer;
    protected Timer indexTimer;
    protected Timer bulkIndexTimer;
    protected ElasticSearchLocalConfig localConfig;
    protected ElasticSearchRemoteConfig remoteConfig;
    protected String[] includeSourceFields;
    protected String[] excludeSourceFields;

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (EP_LOCAL.equals(extensionPoint)) {
            this.release();
            this.localConfig = (ElasticSearchLocalConfig)contribution;
            this.remoteConfig = null;
        } else if (EP_REMOTE.equals(extensionPoint)) {
            this.release();
            this.remoteConfig = (ElasticSearchRemoteConfig)contribution;
            this.localConfig = null;
        } else if (EP_INDEX.equals(extensionPoint)) {
            ElasticSearchIndexConfig idx = (ElasticSearchIndexConfig)contribution;
            ElasticSearchIndexConfig previous = this.indexes.put(idx.getType(), idx);
            idx.merge(previous);
            if ("doc".equals(idx.getType())) {
                log.info((Object)("Associate index " + idx.getName() + " with repository: " + idx.getRepositoryName()));
                this.indexNames.put(idx.getRepositoryName(), idx.getName());
                LinkedHashSet<String> set = new LinkedHashSet<String>();
                if (this.includeSourceFields != null) {
                    set.addAll(Arrays.asList(this.includeSourceFields));
                }
                set.addAll(Arrays.asList(idx.getIncludes()));
                if (set.contains("*")) {
                    set.clear();
                    set.add("*");
                }
                this.includeSourceFields = set.toArray(new String[set.size()]);
                set.clear();
                if (this.excludeSourceFields != null) {
                    set.addAll(Arrays.asList(this.excludeSourceFields));
                }
                set.addAll(Arrays.asList(idx.getExcludes()));
                this.excludeSourceFields = set.toArray(new String[set.size()]);
            }
        }
    }

    public ElasticSearchLocalConfig getLocalConfig() {
        if (Framework.isTestModeSet() && this.localConfig == null && this.remoteConfig == null) {
            this.localConfig = new ElasticSearchLocalConfig();
            this.localConfig.setHttpEnabled(true);
            this.localConfig.setIndexStorageType("memory");
            this.localConfig.setNodeName("nuxeoTestNode");
            this.localConfig.setClusterName("nuxeoTestCluster-" + RandomStringUtils.randomAlphanumeric((int)6));
            this.remoteConfig = null;
        }
        return this.localConfig;
    }

    protected void schedulePostCommitIndexing(IndexingCommand cmd) throws ClientException {
        try {
            EventProducer evtProducer = (EventProducer)Framework.getLocalService(EventProducer.class);
            Event indexingEvent = cmd.asIndexingEvent();
            if (indexingEvent != null) {
                evtProducer.fireEvent(indexingEvent);
            }
        }
        catch (Exception e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void indexNow(List<IndexingCommand> cmds) throws ClientException {
        if (!this.indexInitDone) {
            log.debug((Object)"Delaying indexing commands: Waiting for Index to be initialized.");
            this.stackedCommands.addAll(cmds);
            return;
        }
        this.markCommandInProgress(cmds);
        int nbCommands = cmds.size();
        this.totalCommandRunning.addAndGet(nbCommands);
        try {
            this.processBulkDeleteCommands(cmds);
            Timer.Context stopWatch = this.bulkIndexTimer.time();
            try {
                this.processBulkIndexCommands(cmds);
            }
            finally {
                stopWatch.stop();
            }
        }
        finally {
            this.totalCommandRunning.addAndGet(-nbCommands);
        }
        this.totalCommandProcessed.addAndGet(nbCommands);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processBulkDeleteCommands(List<IndexingCommand> cmds) {
        for (IndexingCommand cmd : cmds) {
            if (!"ES_DELETE".equals(cmd.getName())) continue;
            Timer.Context stopWatch = this.deleteTimer.time();
            try {
                this.processDeleteCommand(cmd);
            }
            finally {
                stopWatch.stop();
            }
        }
    }

    protected void processBulkIndexCommands(List<IndexingCommand> cmds) throws ClientException {
        BulkRequestBuilder bulkRequest = this.getClient().prepareBulk();
        for (IndexingCommand cmd : cmds) {
            if (cmd.getTargetDocument() == null || "ES_DELETE".equals(cmd.getName())) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)("Sending bulk indexing request to Elasticsearch: " + cmd.toString()));
            }
            IndexRequestBuilder idxRequest = this.buildEsIndexingRequest(cmd);
            bulkRequest.add(idxRequest);
        }
        if (bulkRequest.numberOfActions() > 0) {
            BulkResponse response;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Index %d docs in bulk request: curl -XPOST 'http://localhost:9200/_bulk' -d '%s'", bulkRequest.numberOfActions(), ((BulkRequest)bulkRequest.request()).requests().toString()));
            }
            if ((response = (BulkResponse)bulkRequest.execute().actionGet()).hasFailures()) {
                log.error((Object)response.buildFailureMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void indexNow(IndexingCommand cmd) throws ClientException {
        if (cmd.getTargetDocument() == null) {
            return;
        }
        if (!this.indexInitDone) {
            this.stackedCommands.add(cmd);
            log.debug((Object)"Delaying indexing command: Waiting for Index to be initialized.");
            return;
        }
        this.markCommandInProgress(cmd);
        this.totalCommandRunning.incrementAndGet();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Sending indexing request to Elasticsearch: " + cmd.toString()));
        }
        if ("ES_DELETE".equals(cmd.getName())) {
            Timer.Context stopWatch = this.deleteTimer.time();
            try {
                this.processDeleteCommand(cmd);
            }
            finally {
                stopWatch.stop();
                this.totalCommandProcessed.addAndGet(1);
                this.totalCommandRunning.decrementAndGet();
            }
        }
        Timer.Context stopWatch = this.indexTimer.time();
        try {
            this.processIndexCommand(cmd);
        }
        finally {
            stopWatch.stop();
            this.totalCommandProcessed.addAndGet(1);
            this.totalCommandRunning.decrementAndGet();
        }
    }

    protected void processIndexCommand(IndexingCommand cmd) throws ClientException {
        DocumentModel doc = cmd.getTargetDocument();
        assert (doc != null);
        IndexRequestBuilder request = this.buildEsIndexingRequest(cmd);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Index request: curl -XPUT 'http://localhost:9200/%s/%s/%s' -d '%s'", this.getRepositoryIndex(doc.getRepositoryName()), "doc", doc.getId(), ((IndexRequest)request.request()).toString()));
        }
        request.execute().actionGet();
    }

    protected void processDeleteCommand(IndexingCommand cmd) {
        if (cmd.isRecurse()) {
            this.processDeleteCommandRecursive(cmd);
        } else {
            this.processDeleteCommandNonRecursive(cmd);
        }
    }

    protected void processDeleteCommandNonRecursive(IndexingCommand cmd) {
        String indexName = this.getRepositoryIndex(cmd.getRepository());
        DeleteRequestBuilder request = this.getClient().prepareDelete(indexName, "doc", cmd.getDocId());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Delete request: curl -XDELETE 'http://localhost:9200/%s/%s/%s'", indexName, "doc", cmd.getDocId()));
        }
        request.execute().actionGet();
    }

    protected void processDeleteCommandRecursive(IndexingCommand cmd) {
        String indexName = this.getRepositoryIndex(cmd.getRepository());
        String docPath = this.getPathOfDocFromEs(cmd.getRepository(), cmd.getDocId());
        if (docPath == null) {
            if (!Framework.isTestModeSet()) {
                log.warn((Object)("Trying to delete a non existing doc: " + cmd.toString()));
            }
            return;
        }
        ConstantScoreQueryBuilder query = QueryBuilders.constantScoreQuery((FilterBuilder)FilterBuilders.termFilter((String)"ecm:path.children", (String)docPath));
        DeleteByQueryRequestBuilder deleteRequest = this.getClient().prepareDeleteByQuery(new String[]{indexName}).setTypes(new String[]{"doc"}).setQuery((QueryBuilder)query);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Delete byQuery request: curl -XDELETE 'http://localhost:9200/%s/%s/_query' -d '%s'", indexName, "doc", query.toString()));
        }
        DeleteByQueryResponse responses = (DeleteByQueryResponse)deleteRequest.execute().actionGet();
        for (IndexDeleteByQueryResponse response : responses) {
            if (response.getFailedShards() <= 0) continue;
            log.error((Object)String.format("Delete byQuery fails on shard: %d out of %d", response.getFailedShards(), response.getTotalShards()));
        }
    }

    protected String getPathOfDocFromEs(String repository, String docId) {
        GetResponse ret;
        String indexName = this.getRepositoryIndex(repository);
        GetRequestBuilder getRequest = this.getClient().prepareGet(indexName, "doc", docId).setFields(new String[]{"ecm:path"});
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Get path of doc: curl -XGET 'http://localhost:9200/%s/%s/%s?fields=%s'", indexName, "doc", docId, "ecm:path"));
        }
        if (!(ret = (GetResponse)getRequest.execute().actionGet()).isExists()) {
            return null;
        }
        return ret.getField("ecm:path").getValue().toString();
    }

    protected IndexRequestBuilder buildEsIndexingRequest(IndexingCommand cmd) throws ClientException {
        DocumentModel doc = cmd.getTargetDocument();
        try {
            JsonFactory factory = new JsonFactory();
            XContentBuilder builder = XContentFactory.jsonBuilder();
            JsonGenerator jsonGen = factory.createJsonGenerator(builder.stream());
            JsonESDocumentWriter.writeESDocument((JsonGenerator)jsonGen, (DocumentModel)doc, (String[])cmd.getSchemas(), null);
            return this.getClient().prepareIndex(this.getRepositoryIndex(doc.getRepositoryName()), "doc", doc.getId()).setSource(builder);
        }
        catch (Exception e) {
            throw new ClientException("Unable to create index request for Document " + doc.getId(), (Throwable)e);
        }
    }

    protected int markCommandInProgress(List<IndexingCommand> cmds) {
        int ret = 0;
        for (IndexingCommand cmd : cmds) {
            ret += this.markCommandInProgress(cmd);
        }
        return ret;
    }

    protected int markCommandInProgress(IndexingCommand cmd) {
        this.pendingWork.remove(this.getWorkKey(cmd));
        boolean isRemoved = this.pendingCommands.remove(cmd.getId());
        return isRemoved ? 1 : 0;
    }

    @Override
    public void scheduleIndexing(IndexingCommand cmd) throws ClientException {
        DocumentModel doc = cmd.getTargetDocument();
        if (doc == null) {
            return;
        }
        if (this.isAlreadyScheduled(cmd)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Skip indexing for " + cmd.toString() + " since it is already scheduled"));
            }
            return;
        }
        this.pendingCommands.add(cmd.getId());
        this.pendingWork.add(this.getWorkKey(cmd));
        if (cmd.isSync()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Schedule Sync PostCommit indexing request " + cmd.toString()));
            }
            this.schedulePostCommitIndexing(cmd);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Schedule Async indexing request  " + cmd.toString()));
            }
            WorkManager wm = (WorkManager)Framework.getLocalService(WorkManager.class);
            IndexingWorker idxWork = new IndexingWorker(cmd);
            wm.schedule((Work)idxWork, true);
        }
    }

    protected String getRepositoryIndex(String repositoryName) {
        String ret = this.indexNames.get(repositoryName);
        if (ret == null) {
            throw new NoSuchElementException("No index defined for repository: " + repositoryName);
        }
        return ret;
    }

    protected String[] getSearchIndexes() {
        Collection<String> values = this.indexNames.values();
        return values.toArray(new String[values.size()]);
    }

    protected String getSearchIndexesAsString() {
        return StringUtils.join(this.indexNames.values(), (char)',');
    }

    @Override
    public void refreshRepositoryIndex(String repositoryName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Refreshing index associated with repo: " + repositoryName));
        }
        this.getClient().admin().indices().prepareRefresh(new String[]{this.getRepositoryIndex(repositoryName)}).execute().actionGet();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Refreshing index done");
        }
    }

    @Override
    public void flushRepositoryIndex(String repositoryName) {
        log.info((Object)("Flushing index associated with repo: " + repositoryName));
        this.getClient().admin().indices().prepareFlush(new String[]{this.getRepositoryIndex(repositoryName)}).execute().actionGet();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Flushing index done");
        }
    }

    @Override
    public void refresh() {
        for (String RepositoryName : this.indexNames.keySet()) {
            this.refreshRepositoryIndex(RepositoryName);
        }
    }

    @Override
    public void flush() {
        for (String RepositoryName : this.indexNames.keySet()) {
            this.flushRepositoryIndex(RepositoryName);
        }
    }

    @Override
    public Client getClient() {
        if (this.client == null) {
            ElasticSearchLocalConfig lConf = this.getLocalConfig();
            if (lConf != null) {
                log.info((Object)"Creating a local ES node inJVM");
                ImmutableSettings.Builder sBuilder = ImmutableSettings.settingsBuilder();
                sBuilder.put("http.enabled", lConf.httpEnabled()).put("path.data", lConf.getDataPath()).put("index.number_of_shards", 1).put("index.number_of_replicas", 1).put("cluster.name", lConf.getClusterName()).put("node.name", lConf.getNodeName());
                if (lConf.getIndexStorageType() != null) {
                    sBuilder.put("index.store.type", lConf.getIndexStorageType());
                    if (lConf.getIndexStorageType().equals("memory")) {
                        sBuilder.put("gateway.type", "none");
                    }
                }
                Settings settings = sBuilder.build();
                log.debug((Object)("Using settings: " + settings.toDelimitedString(',')));
                this.localNode = NodeBuilder.nodeBuilder().local(true).settings(settings).node();
                this.client = this.localNode.start().client();
                this.client.admin().cluster().prepareHealth(new String[0]).setWaitForYellowStatus().execute().actionGet();
            } else if (this.remoteConfig != null) {
                log.info((Object)"Connecting to an ES cluster");
                ImmutableSettings.Builder builder = ImmutableSettings.settingsBuilder().put("cluster.name", this.remoteConfig.getClusterName()).put("client.transport.nodes_sampler_interval", this.remoteConfig.getSamplerInterval()).put("index.number_of_shards", this.remoteConfig.getNumberOfShards()).put("index.number_of_replicas", this.remoteConfig.getNumberOfReplicas()).put("client.transport.ping_timeout", this.remoteConfig.getPingTimeout()).put("client.transport.ignore_cluster_name", this.remoteConfig.isIgnoreClusterName()).put("client.transport.sniff", this.remoteConfig.isClusterSniff());
                Settings settings = builder.build();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Using settings: " + settings.toDelimitedString(',')));
                }
                TransportClient tClient = new TransportClient(settings);
                String[] addresses = this.remoteConfig.getAddresses();
                if (addresses == null) {
                    log.error((Object)"You need to provide an addressList to join a cluster");
                } else {
                    for (String item : this.remoteConfig.getAddresses()) {
                        String[] address = item.split(":");
                        log.info((Object)("Add transport address: " + item));
                        try {
                            InetAddress inet = InetAddress.getByName(address[0]);
                            tClient.addTransportAddress((TransportAddress)new InetSocketTransportAddress(inet, Integer.parseInt(address[1])));
                        }
                        catch (UnknownHostException e) {
                            log.error((Object)("Unable to resolve host " + address[0]), (Throwable)e);
                        }
                    }
                }
                this.client = tClient;
            }
            if (this.client != null) {
                try {
                    this.client.admin().indices().status(new IndicesStatusRequest()).get();
                }
                catch (InterruptedException | ExecutionException | NoNodeAvailableException e) {
                    log.error((Object)("Failed to connect to elasticsearch: " + e.getMessage()), e);
                    this.client = null;
                }
            }
        }
        return this.client;
    }

    @Override
    public DocumentModelList query(CoreSession session, String nxql, int limit, int offset, SortInfo ... sortInfos) throws ClientException {
        NxQueryBuilder query = new NxQueryBuilder(session).nxql(nxql).limit(limit).offset(offset).addSort(sortInfos);
        return this.query(query);
    }

    @Override
    public DocumentModelList query(CoreSession session, QueryBuilder queryBuilder, int limit, int offset, SortInfo ... sortInfos) throws ClientException {
        NxQueryBuilder query = new NxQueryBuilder(session).esQuery(queryBuilder).limit(limit).offset(offset).addSort(sortInfos);
        return this.query(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocumentModelList query(NxQueryBuilder queryBuilder) throws ClientException {
        DocumentModelListImpl ret;
        SearchResponse response = this.search(queryBuilder);
        if (response.getHits().getHits().length == 0) {
            ret = new DocumentModelListImpl(0);
        } else {
            Timer.Context stopWatch = this.fetchTimer.time();
            try {
                ret = queryBuilder.isFetchFromElasticsearch() ? this.fetchDocumentsFromElasticsearch(queryBuilder, response) : this.fetchDocumentsFromVcs(queryBuilder, response);
            }
            finally {
                stopWatch.stop();
            }
        }
        long totalSize = response.getHits().getTotalHits();
        ret.setTotalSize(totalSize);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SearchResponse search(NxQueryBuilder query) {
        Timer.Context stopWatch = this.searchTimer.time();
        try {
            SearchRequestBuilder request = this.buildEsSearchRequest(query);
            this.logSearchRequest(request);
            SearchResponse response = (SearchResponse)request.execute().actionGet();
            this.logSearchResponse(response);
            SearchResponse searchResponse = response;
            return searchResponse;
        }
        finally {
            stopWatch.stop();
        }
    }

    protected SearchRequestBuilder buildEsSearchRequest(NxQueryBuilder query) {
        SearchRequestBuilder request = this.getClient().prepareSearch(this.getSearchIndexes()).setTypes(new String[]{"doc"}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setFrom(query.getOffset()).setSize(query.getLimit());
        if (query.isFetchFromElasticsearch()) {
            request.setFetchSource(this.getIncludeSourceFields(), this.getExcludeSourceFields());
        } else {
            request.addField(ID_FIELD);
        }
        request.setQuery(this.addSecurityFilter(query.getSession(), query.makeQuery()));
        for (SortBuilder sortBuilder : query.getSortBuilders()) {
            request.addSort(sortBuilder);
        }
        return request;
    }

    protected void logSearchResponse(SearchResponse response) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Response: " + response.toString()));
        }
    }

    protected void logSearchRequest(SearchRequestBuilder request) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Search query: curl -XGET 'http://localhost:9200/%s/%s/_search?pretty' -d '%s'", this.getSearchIndexesAsString(), "doc", request.toString()));
        }
    }

    protected QueryBuilder addSecurityFilter(CoreSession session, QueryBuilder queryBuilder) {
        Principal principal = session.getPrincipal();
        if (principal == null || principal instanceof NuxeoPrincipal && ((NuxeoPrincipal)principal).isAdministrator()) {
            return queryBuilder;
        }
        String[] principals = SecurityService.getPrincipalsToCheck((Principal)principal);
        AndFilterBuilder aclFilter = FilterBuilders.andFilter((FilterBuilder[])new FilterBuilder[]{FilterBuilders.inFilter((String)"ecm:acl", (String[])principals), FilterBuilders.notFilter((FilterBuilder)FilterBuilders.inFilter((String)"ecm:acl", (String[])new String[]{"_UNSUPPORTED_ACL_"}))});
        return QueryBuilders.filteredQuery((QueryBuilder)queryBuilder, (FilterBuilder)aclFilter);
    }

    protected DocumentModelListImpl fetchDocumentsFromElasticsearch(NxQueryBuilder queryBuilder, SearchResponse response) {
        DocumentModelListImpl ret = new DocumentModelListImpl(response.getHits().getHits().length);
        String sid = queryBuilder.getSession().getSessionId();
        for (SearchHit hit : response.getHits()) {
            DocumentModel doc = DocumentModelReaders.fromSource(hit.getSource()).sid(sid).getDocumentModel();
            ret.add((Object)doc);
        }
        return ret;
    }

    protected DocumentModelListImpl fetchDocumentsFromVcs(NxQueryBuilder queryBuilder, SearchResponse response) {
        ArrayList<String> ids = new ArrayList<String>(queryBuilder.getLimit());
        for (SearchHit hit : response.getHits()) {
            ids.add(hit.getId());
        }
        DocumentModelListImpl ret = new DocumentModelListImpl(ids.size());
        if (!ids.isEmpty()) {
            try {
                ret.addAll(this.fetchDocumentsFromVcs(ids, queryBuilder.getSession()));
            }
            catch (ClientException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return ret;
    }

    protected List<DocumentModel> fetchDocumentsFromVcs(final List<String> ids, CoreSession session) throws ClientException {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT * FROM Document WHERE ecm:uuid IN (");
        for (int i = 0; i < ids.size(); ++i) {
            sb.append(NXQL.escapeString((String)ids.get(i)));
            if (i >= ids.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        DocumentModelList ret = session.query(sb.toString());
        Collections.sort(ret, new Comparator<DocumentModel>(){

            @Override
            public int compare(DocumentModel a, DocumentModel b) {
                return ids.indexOf(a.getId()) - ids.indexOf(b.getId());
            }
        });
        return ret;
    }

    public void applicationStarted(ComponentContext context) throws Exception {
        super.applicationStarted(context);
        if (this.remoteConfig == null && this.getLocalConfig() == null) {
            log.warn((Object)"Unable to initialize Elasticsearch service : no configuration is provided");
            return;
        }
        this.searchTimer = this.registry.timer(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"elasticsearch", "service", "search"}));
        this.fetchTimer = this.registry.timer(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"elasticsearch", "service", "fetch"}));
        this.indexTimer = this.registry.timer(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"elasticsearch", "service", "index"}));
        this.deleteTimer = this.registry.timer(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"elasticsearch", "service", "delete"}));
        this.bulkIndexTimer = this.registry.timer(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"elasticsearch", "service", "bulkIndex"}));
        this.getClient();
        this.initIndexes(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initIndexes(boolean dropIfExists) {
        for (ElasticSearchIndexConfig idx : this.indexes.values()) {
            this.initIndex(idx, dropIfExists);
        }
        this.indexInitDone = true;
        if (!this.stackedCommands.isEmpty()) {
            log.info((Object)"Processing indexing command stacked during startup");
            boolean txCreated = false;
            if (!TransactionHelper.isTransactionActive()) {
                txCreated = TransactionHelper.startTransaction();
            }
            try {
                for (final IndexingCommand cmd : this.stackedCommands) {
                    new UnrestrictedSessionRunner(cmd.getRepository()){

                        public void run() throws ClientException {
                            cmd.refresh(this.session);
                            ElasticSearchComponent.this.indexNow(cmd);
                        }
                    }.runUnrestricted();
                }
            }
            catch (Exception e) {
                log.error((Object)("Unable to flush pending indexing commands: " + e.getMessage()), (Throwable)e);
            }
            finally {
                if (txCreated) {
                    TransactionHelper.commitOrRollbackTransaction();
                }
                this.stackedCommands.clear();
                log.debug((Object)"Done");
            }
        }
    }

    protected void initIndex(ElasticSearchIndexConfig conf, boolean dropIfExists) {
        if (!conf.mustCreate()) {
            return;
        }
        log.info((Object)String.format("Initialize index: %s, type: %s", conf.getName(), conf.getType()));
        boolean mappingExists = false;
        boolean indexExists = ((IndicesExistsResponse)this.getClient().admin().indices().prepareExists(new String[]{conf.getName()}).execute().actionGet()).isExists();
        if (indexExists) {
            if (!dropIfExists) {
                log.debug((Object)("Index " + conf.getName() + " already exists"));
                mappingExists = ((GetMappingsResponse)this.getClient().admin().indices().prepareGetMappings(new String[]{conf.getName()}).execute().actionGet()).getMappings().containsKey((Object)"doc");
            } else {
                if (!Framework.isTestModeSet()) {
                    log.warn((Object)String.format("Initializing index: %s, type: %s with dropIfExists flag, deleting an existing index", conf.getName(), conf.getType()));
                }
                this.getClient().admin().indices().delete(new DeleteIndexRequest(conf.getName())).actionGet();
                indexExists = false;
            }
        }
        if (!indexExists) {
            log.info((Object)String.format("Creating index: %s", conf.getName()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using settings: " + conf.getSettings()));
            }
            this.getClient().admin().indices().prepareCreate(conf.getName()).setSettings(conf.getSettings()).execute().actionGet();
        }
        if (!mappingExists) {
            log.info((Object)String.format("Creating mapping type: %s on index: %s", conf.getType(), conf.getName()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using mapping: " + conf.getMapping()));
            }
            this.getClient().admin().indices().preparePutMapping(new String[]{conf.getName()}).setType(conf.getType()).setSource(conf.getMapping()).execute().actionGet();
        }
    }

    public void deactivate(ComponentContext context) throws Exception {
        super.deactivate(context);
        this.release();
    }

    protected void release() {
        if (this.client != null) {
            this.client.close();
        }
        if (this.localNode != null) {
            log.info((Object)"Shutting down local node");
            this.localNode.stop();
            this.localNode.close();
        }
        this.client = null;
        this.localNode = null;
        this.indexNames.clear();
    }

    protected String getWorkKey(IndexingCommand cmd) {
        return cmd.getRepository() + ":" + cmd.getDocId() + ":" + cmd.isRecurse();
    }

    @Override
    public boolean isAlreadyScheduled(IndexingCommand cmd) {
        return this.pendingCommands.contains(cmd.getId()) || this.pendingWork.contains(this.getWorkKey(cmd));
    }

    @Override
    public int getPendingDocs() {
        return this.pendingWork.size();
    }

    @Override
    public int getPendingCommands() {
        return this.pendingCommands.size() + ChildrenIndexingWorker.getRunningWorkers();
    }

    @Override
    public int getTotalCommandProcessed() {
        return this.totalCommandProcessed.get();
    }

    @Override
    public int getRunningCommands() {
        return this.totalCommandRunning.get();
    }

    @Override
    public boolean isIndexingInProgress() {
        return this.getRunningCommands() > 0 || this.getPendingCommands() > 0;
    }

    public String[] getIncludeSourceFields() {
        return this.includeSourceFields;
    }

    public String[] getExcludeSourceFields() {
        return this.excludeSourceFields;
    }
}

